/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;

public class Cell
implements Comparable<Cell>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int index;
    final Integer boxedIndex;
    private final Column column;
    private final int hashcode;

    public Cell(Column column, int colSeq) {
        this.column = column;
        this.index = column.getIndex() * column.getNumCellsPerColumn() + colSeq;
        this.boxedIndex = new Integer(this.index);
        this.hashcode = this.hashCode();
    }

    public int getIndex() {
        return this.index;
    }

    public Column getColumn() {
        return this.column;
    }

    public Set<Synapse> getReceptorSynapses(Connections c) {
        return this.getReceptorSynapses(c, false);
    }

    public Set<Synapse> getReceptorSynapses(Connections c, boolean doLazyCreate) {
        return c.getReceptorSynapses(this, doLazyCreate);
    }

    public List<DistalDendrite> getSegments(Connections c) {
        return this.getSegments(c, false);
    }

    public List<DistalDendrite> getSegments(Connections c, boolean doLazyCreate) {
        return c.getSegments(this, doLazyCreate);
    }

    public String toString() {
        return String.valueOf(this.index);
    }

    @Override
    public int compareTo(Cell arg0) {
        return this.boxedIndex.compareTo(arg0.boxedIndex);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            return result;
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cell other = (Cell)obj;
        return this.index == other.index;
    }
}

