/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Persistable;

public class ComputeCycle
implements Persistable {
    private static final long serialVersionUID = 1L;
    public Set<Cell> activeCells = new LinkedHashSet<Cell>();
    public Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    public List<DistalDendrite> activeSegments = new ArrayList<DistalDendrite>();
    public List<DistalDendrite> matchingSegments = new ArrayList<DistalDendrite>();
    public Set<Cell> predictiveCells = new LinkedHashSet<Cell>();

    public ComputeCycle() {
    }

    public ComputeCycle(Connections c) {
        this.activeCells = new LinkedHashSet<Cell>(c.activeCells);
        this.winnerCells = new LinkedHashSet<Cell>(c.winnerCells);
        this.predictiveCells = new LinkedHashSet<Cell>(c.predictiveCells);
        this.activeSegments = new ArrayList<DistalDendrite>(c.activeSegments);
        this.matchingSegments = new ArrayList<DistalDendrite>(c.matchingSegments);
    }

    public Set<Cell> activeCells() {
        return this.activeCells;
    }

    public Set<Cell> winnerCells() {
        return this.winnerCells;
    }

    public Set<Cell> predictiveCells() {
        if (this.predictiveCells.isEmpty()) {
            Cell previousCell = null;
            Cell currCell = null;
            for (DistalDendrite activeSegment : this.activeSegments) {
                currCell = activeSegment.getParentCell();
                if (currCell == previousCell) continue;
                previousCell = currCell;
                this.predictiveCells.add(previousCell);
            }
        }
        return this.predictiveCells;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activeCells == null ? 0 : this.activeCells.hashCode());
        result = 31 * result + (this.predictiveCells == null ? 0 : this.predictiveCells.hashCode());
        result = 31 * result + (this.winnerCells == null ? 0 : this.winnerCells.hashCode());
        result = 31 * result + (this.activeSegments == null ? 0 : this.activeSegments.hashCode());
        result = 31 * result + (this.matchingSegments == null ? 0 : this.matchingSegments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeCycle other = (ComputeCycle)obj;
        if (this.activeCells == null ? other.activeCells != null : !this.activeCells.equals(other.activeCells)) {
            return false;
        }
        if (this.predictiveCells == null ? other.predictiveCells != null : !this.predictiveCells.equals(other.predictiveCells)) {
            return false;
        }
        if (this.winnerCells == null ? other.winnerCells != null : !this.winnerCells.equals(other.winnerCells)) {
            return false;
        }
        if (this.activeSegments == null ? other.activeSegments != null : !this.activeSegments.equals(other.activeSegments)) {
            return false;
        }
        return !(this.matchingSegments == null ? other.matchingSegments != null : !this.matchingSegments.equals(other.matchingSegments));
    }
}

