/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import chaschev.lang.Pair;
import gnu.trove.list.array.TIntArrayList;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.ProximalDendrite;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.network.Persistence;
import org.numenta.nupic.network.PersistenceAPI;
import org.numenta.nupic.serialize.SerialConfig;
import org.numenta.nupic.util.AbstractSparseBinaryMatrix;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.FlatMatrix;
import org.numenta.nupic.util.SparseMatrix;
import org.numenta.nupic.util.SparseObjectMatrix;
import org.numenta.nupic.util.Topology;
import org.numenta.nupic.util.UniversalRandom;

public class Connections
implements Persistable {
    private static final long serialVersionUID = 1L;
    private static final double EPSILON = 1.0E-5;
    private int potentialRadius = 16;
    private double potentialPct = 0.5;
    private boolean globalInhibition = false;
    private double localAreaDensity = -1.0;
    private double numActiveColumnsPerInhArea;
    private double stimulusThreshold = 0.0;
    private double synPermInactiveDec = 0.008;
    private double synPermActiveInc = 0.05;
    private double synPermConnected = 0.1;
    private double synPermBelowStimulusInc = this.synPermConnected / 10.0;
    private double minPctOverlapDutyCycles = 0.001;
    private double minPctActiveDutyCycles = 0.001;
    private double predictedSegmentDecrement = 0.0;
    private int dutyCyclePeriod = 1000;
    private double maxBoost = 10.0;
    private boolean wrapAround = true;
    private int numInputs = 1;
    private int numColumns = 1;
    private double synPermMin = 0.0;
    private double synPermMax = 1.0;
    private double synPermTrimThreshold = this.synPermActiveInc / 2.0;
    private int updatePeriod = 50;
    private double initConnectedPct = 0.5;
    private double version = 1.0;
    public int spIterationNum = 0;
    public int spIterationLearnNum = 0;
    public long tmIteration = 0L;
    public double[] boostedOverlaps;
    public int[] overlaps;
    private Topology inputTopology;
    private Topology columnTopology;
    protected SparseMatrix<?> inputMatrix;
    private FlatMatrix<Pool> potentialPools;
    private double[] tieBreaker;
    private AbstractSparseBinaryMatrix connectedCounts;
    private int inhibitionRadius = 0;
    private double[] overlapDutyCycles;
    private double[] activeDutyCycles;
    private volatile double[] minOverlapDutyCycles;
    private volatile double[] minActiveDutyCycles;
    private double[] boostFactors;
    protected Set<Cell> activeCells = new LinkedHashSet<Cell>();
    protected Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    protected Set<Cell> predictiveCells = new LinkedHashSet<Cell>();
    protected List<DistalDendrite> activeSegments = new ArrayList<DistalDendrite>();
    protected List<DistalDendrite> matchingSegments = new ArrayList<DistalDendrite>();
    protected int[] columnDimensions = new int[]{2048};
    protected int cellsPerColumn = 32;
    protected int[] inputDimensions = new int[]{32, 32};
    private int activationThreshold = 13;
    private int learningRadius = 2048;
    private int minThreshold = 10;
    private int maxNewSynapseCount = 20;
    private int maxSegmentsPerCell = 255;
    private int maxSynapsesPerSegment = 255;
    private double initialPermanence = 0.21;
    private double connectedPermanence = 0.5;
    private double permanenceIncrement = 0.1;
    private double permanenceDecrement = 0.1;
    private SparseObjectMatrix<Column> memory;
    private Cell[] cells;
    public Map<Cell, LinkedHashSet<Synapse>> receptorSynapses;
    protected Map<Cell, List<DistalDendrite>> segments;
    public Map<Segment, List<Synapse>> distalSynapses;
    protected Map<Segment, List<Synapse>> proximalSynapses;
    protected int proximalSynapseCounter = -1;
    protected int nextFlatIdx;
    protected int nextSegmentOrdinal;
    protected int nextSynapseOrdinal;
    protected long numSynapses;
    protected TIntArrayList freeFlatIdxs = new TIntArrayList();
    protected List<DistalDendrite> segmentForFlatIdx = new ArrayList<DistalDendrite>();
    public Activity lastActivity;
    protected int seed = 42;
    public Random random = new UniversalRandom(this.seed);
    public Comparator<DistalDendrite> segmentPositionSortKey = (Comparator & Serializable)(s1, s2) -> {
        double c2;
        double c1 = (double)s1.getParentCell().getIndex() + (double)s1.getOrdinal() / (double)this.nextSegmentOrdinal;
        return c1 == (c2 = (double)s2.getParentCell().getIndex() + (double)s2.getOrdinal() / (double)this.nextSegmentOrdinal) ? 0 : (c1 > c2 ? 1 : -1);
    };
    public Comparator<Pair<Integer, Double>> inhibitionComparator = (Comparator & Serializable)(p1, p2) -> {
        int p1key = (Integer)p1.getFirst();
        int p2key = (Integer)p2.getFirst();
        double p1val = (Double)p1.getSecond();
        double p2val = (Double)p2.getSecond();
        if (Math.abs(p2val - p1val) < 1.0E-9) {
            return (double)Math.abs(p2key - p1key) < 1.0E-9 ? 0 : (p2key > p1key ? -1 : 1);
        }
        return p2val > p1val ? -1 : 1;
    };

    public Connections copy() {
        PersistenceAPI api = Persistence.get(new SerialConfig());
        byte[] myBytes = api.serializer().serialize(this);
        return (Connections)api.serializer().deSerialize(myBytes);
    }

    public void doSpatialPoolerPostInit() {
        this.synPermBelowStimulusInc = this.synPermConnected / 10.0;
        this.synPermTrimThreshold = this.synPermActiveInc / 2.0;
        if (this.potentialRadius == -1) {
            this.potentialRadius = ArrayUtils.product(this.inputDimensions);
        }
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getSeed() {
        return this.seed;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public Cell getCell(int index) {
        return this.cells[index];
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public void setCells(Cell[] cells) {
        this.cells = cells;
    }

    public Cell[] getCells(int ... cellIndexes) {
        Cell[] retVal = new Cell[cellIndexes.length];
        for (int i = 0; i < cellIndexes.length; ++i) {
            retVal[i] = this.cells[cellIndexes[i]];
        }
        return retVal;
    }

    public LinkedHashSet<Cell> getCellSet(int ... cellIndexes) {
        LinkedHashSet<Cell> retVal = new LinkedHashSet<Cell>(cellIndexes.length);
        for (int i = 0; i < cellIndexes.length; ++i) {
            retVal.add(this.cells[cellIndexes[i]]);
        }
        return retVal;
    }

    public void setMemory(SparseObjectMatrix<Column> mem) {
        this.memory = mem;
    }

    public SparseObjectMatrix<Column> getMemory() {
        return this.memory;
    }

    public Topology getInputTopology() {
        return this.inputTopology;
    }

    public void setInputTopology(Topology topology) {
        this.inputTopology = topology;
    }

    public Topology getColumnTopology() {
        return this.columnTopology;
    }

    public void setColumnTopology(Topology topology) {
        this.columnTopology = topology;
    }

    public SparseMatrix<?> getInputMatrix() {
        return this.inputMatrix;
    }

    public void setInputMatrix(SparseMatrix<?> matrix) {
        this.inputMatrix = matrix;
    }

    public double getInitConnectedPct() {
        return this.initConnectedPct;
    }

    public int getIterationNum() {
        return this.spIterationNum;
    }

    public void setIterationNum(int num) {
        this.spIterationNum = num;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(int period) {
        this.updatePeriod = period;
    }

    public int getInhibitionRadius() {
        return this.inhibitionRadius;
    }

    public void setInhibitionRadius(int radius) {
        this.inhibitionRadius = radius;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public void setNumInputs(int n) {
        this.numInputs = n;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int n) {
        this.numColumns = n;
    }

    public void setPotentialRadius(int potentialRadius) {
        this.potentialRadius = potentialRadius;
    }

    public int getPotentialRadius() {
        return this.potentialRadius;
    }

    public void setPotentialPct(double potentialPct) {
        this.potentialPct = potentialPct;
    }

    public double getPotentialPct() {
        return this.potentialPct;
    }

    public void setProximalPermanences(SparseObjectMatrix<double[]> s) {
        for (int idx : s.getSparseIndices()) {
            this.memory.getObject(idx).setProximalPermanences(this, s.getObject(idx));
        }
    }

    public int getProximalSynapseCount() {
        return this.proximalSynapseCounter + 1;
    }

    public void setProximalSynapseCount(int i) {
        this.proximalSynapseCounter = i;
    }

    public int incrementProximalSynapses() {
        return ++this.proximalSynapseCounter;
    }

    public int decrementProximalSynapses() {
        return --this.proximalSynapseCounter;
    }

    public AbstractSparseBinaryMatrix getConnectedCounts() {
        return this.connectedCounts;
    }

    public int getConnectedCount(int columnIndex) {
        return this.connectedCounts.getTrueCount(columnIndex);
    }

    public void setConnectedCounts(int[] counts) {
        for (int i = 0; i < counts.length; ++i) {
            this.connectedCounts.setTrueCount(i, counts[i]);
        }
    }

    public void setConnectedMatrix(AbstractSparseBinaryMatrix matrix) {
        this.connectedCounts = matrix;
    }

    public void setTieBreaker(double[] tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public double[] getTieBreaker() {
        return this.tieBreaker;
    }

    public void setGlobalInhibition(boolean globalInhibition) {
        this.globalInhibition = globalInhibition;
    }

    public boolean getGlobalInhibition() {
        return this.globalInhibition;
    }

    public void setLocalAreaDensity(double localAreaDensity) {
        this.localAreaDensity = localAreaDensity;
    }

    public double getLocalAreaDensity() {
        return this.localAreaDensity;
    }

    public void setNumActiveColumnsPerInhArea(double numActiveColumnsPerInhArea) {
        this.numActiveColumnsPerInhArea = numActiveColumnsPerInhArea;
    }

    public double getNumActiveColumnsPerInhArea() {
        return this.numActiveColumnsPerInhArea;
    }

    public void setStimulusThreshold(double stimulusThreshold) {
        this.stimulusThreshold = stimulusThreshold;
    }

    public double getStimulusThreshold() {
        return this.stimulusThreshold;
    }

    public void setSynPermInactiveDec(double synPermInactiveDec) {
        this.synPermInactiveDec = synPermInactiveDec;
    }

    public double getSynPermInactiveDec() {
        return this.synPermInactiveDec;
    }

    public void setSynPermActiveInc(double synPermActiveInc) {
        this.synPermActiveInc = synPermActiveInc;
    }

    public double getSynPermActiveInc() {
        return this.synPermActiveInc;
    }

    public void setSynPermConnected(double synPermConnected) {
        this.synPermConnected = synPermConnected;
    }

    public double getSynPermConnected() {
        return this.synPermConnected;
    }

    public void setSynPermBelowStimulusInc(double stim) {
        this.synPermBelowStimulusInc = stim;
    }

    public double getSynPermBelowStimulusInc() {
        return this.synPermBelowStimulusInc;
    }

    public void setMinPctOverlapDutyCycles(double minPctOverlapDutyCycle) {
        this.minPctOverlapDutyCycles = minPctOverlapDutyCycle;
    }

    public double getMinPctOverlapDutyCycles() {
        return this.minPctOverlapDutyCycles;
    }

    public void setMinPctActiveDutyCycles(double minPctActiveDutyCycle) {
        this.minPctActiveDutyCycles = minPctActiveDutyCycle;
    }

    public double getMinPctActiveDutyCycles() {
        return this.minPctActiveDutyCycles;
    }

    public void setDutyCyclePeriod(int dutyCyclePeriod) {
        this.dutyCyclePeriod = dutyCyclePeriod;
    }

    public int getDutyCyclePeriod() {
        return this.dutyCyclePeriod;
    }

    public void setMaxBoost(double maxBoost) {
        this.maxBoost = maxBoost;
    }

    public double getMaxBoost() {
        return this.maxBoost;
    }

    public void setWrapAround(boolean b) {
        this.wrapAround = b;
    }

    public boolean isWrapAround() {
        return this.wrapAround;
    }

    public double[] setBoostedOverlaps(double[] boostedOverlaps) {
        this.boostedOverlaps = boostedOverlaps;
        return boostedOverlaps;
    }

    public double[] getBoostedOverlaps() {
        return this.boostedOverlaps;
    }

    public int[] setOverlaps(int[] overlaps) {
        this.overlaps = overlaps;
        return overlaps;
    }

    public int[] getOverlaps() {
        return this.overlaps;
    }

    public void setSynPermTrimThreshold(double threshold) {
        this.synPermTrimThreshold = threshold;
    }

    public double getSynPermTrimThreshold() {
        return this.synPermTrimThreshold;
    }

    public void setPotentialPools(FlatMatrix<Pool> pools) {
        this.potentialPools = pools;
    }

    public FlatMatrix<Pool> getPotentialPools() {
        return this.potentialPools;
    }

    public double getSynPermMin() {
        return this.synPermMin;
    }

    public double getSynPermMax() {
        return this.synPermMax;
    }

    public double getVersion() {
        return this.version;
    }

    public double[] getOverlapDutyCycles() {
        return this.overlapDutyCycles;
    }

    public void setOverlapDutyCycles(double[] overlapDutyCycles) {
        this.overlapDutyCycles = overlapDutyCycles;
    }

    public double[] getActiveDutyCycles() {
        return this.activeDutyCycles;
    }

    public void setActiveDutyCycles(double[] activeDutyCycles) {
        this.activeDutyCycles = activeDutyCycles;
    }

    public void updateActiveDutyCycles(double[] denseActiveDutyCycles) {
        for (int i = 0; i < denseActiveDutyCycles.length; ++i) {
            if (denseActiveDutyCycles[i] == -1.0) continue;
            this.activeDutyCycles[i] = denseActiveDutyCycles[i];
        }
    }

    public double[] getMinOverlapDutyCycles() {
        return this.minOverlapDutyCycles;
    }

    public void setMinOverlapDutyCycles(double[] minOverlapDutyCycles) {
        this.minOverlapDutyCycles = minOverlapDutyCycles;
    }

    public double[] getMinActiveDutyCycles() {
        return this.minActiveDutyCycles;
    }

    public void setMinActiveDutyCycles(double[] minActiveDutyCycles) {
        this.minActiveDutyCycles = minActiveDutyCycles;
    }

    public double[] getBoostFactors() {
        return this.boostFactors;
    }

    public void setBoostFactors(double[] boostFactors) {
        this.boostFactors = boostFactors;
    }

    public Activity computeActivity(Collection<Cell> activePresynapticCells, double connectedPermanence) {
        int[] numActiveConnectedSynapsesForSegment = new int[this.nextFlatIdx];
        int[] numActivePotentialSynapsesForSegment = new int[this.nextFlatIdx];
        double threshold = connectedPermanence - 1.0E-5;
        for (Cell cell : activePresynapticCells) {
            for (Synapse synapse : this.getReceptorSynapses(cell)) {
                int flatIdx;
                int n = flatIdx = synapse.getSegment().getIndex();
                numActivePotentialSynapsesForSegment[n] = numActivePotentialSynapsesForSegment[n] + 1;
                if (!(synapse.getPermanence() > threshold)) continue;
                int n2 = flatIdx;
                numActiveConnectedSynapsesForSegment[n2] = numActiveConnectedSynapsesForSegment[n2] + 1;
            }
        }
        this.lastActivity = new Activity(numActiveConnectedSynapsesForSegment, numActivePotentialSynapsesForSegment);
        return this.lastActivity;
    }

    public Activity getLastActivity() {
        return this.lastActivity;
    }

    public void recordSegmentActivity(DistalDendrite segment) {
        segment.setLastUsedIteration(this.tmIteration);
    }

    public void startNewIteration() {
        ++this.tmIteration;
    }

    public DistalDendrite createSegment(Cell cell) {
        int flatIdx;
        while (this.numSegments(cell) >= this.maxSegmentsPerCell) {
            this.destroySegment(this.leastRecentlyUsedSegment(cell));
        }
        int len = this.freeFlatIdxs.size();
        if (len > 0) {
            flatIdx = this.freeFlatIdxs.get(len - 1);
            this.freeFlatIdxs.remove(len - 1, 1);
        } else {
            flatIdx = this.nextFlatIdx++;
            this.segmentForFlatIdx.add(null);
        }
        int ordinal = this.nextSegmentOrdinal++;
        DistalDendrite segment = new DistalDendrite(cell, flatIdx, this.tmIteration, ordinal);
        this.getSegments(cell, true).add(segment);
        this.segmentForFlatIdx.set(flatIdx, segment);
        return segment;
    }

    public void destroySegment(DistalDendrite segment) {
        List<Synapse> synapses = this.getSynapses(segment);
        int len = synapses.size();
        this.getSynapses(segment).stream().forEach(s -> this.removeSynapseFromPresynapticMap((Synapse)s));
        this.numSynapses -= (long)len;
        this.getSegments(segment.getParentCell()).remove(segment);
        this.distalSynapses.remove(segment);
        this.freeFlatIdxs.add(segment.getIndex());
        this.segmentForFlatIdx.set(segment.getIndex(), null);
    }

    private DistalDendrite leastRecentlyUsedSegment(Cell cell) {
        List<DistalDendrite> segments = this.getSegments(cell, false);
        DistalDendrite minSegment = null;
        long minIteration = Long.MAX_VALUE;
        for (DistalDendrite dd : segments) {
            if (dd.lastUsedIteration() >= minIteration) continue;
            minSegment = dd;
            minIteration = dd.lastUsedIteration();
        }
        return minSegment;
    }

    public int numSegments() {
        return this.numSegments(null);
    }

    public int numSegments(Cell optionalCellArg) {
        if (optionalCellArg != null) {
            return this.getSegments(optionalCellArg).size();
        }
        return this.nextFlatIdx - this.freeFlatIdxs.size();
    }

    public List<DistalDendrite> getSegments(Cell cell) {
        return this.getSegments(cell, false);
    }

    public List<DistalDendrite> getSegments(Cell cell, boolean doLazyCreate) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell was null");
        }
        if (this.segments == null) {
            this.segments = new LinkedHashMap<Cell, List<DistalDendrite>>();
        }
        List<DistalDendrite> retVal = null;
        retVal = this.segments.get(cell);
        if (retVal == null) {
            if (!doLazyCreate) {
                return Collections.emptyList();
            }
            retVal = new ArrayList<DistalDendrite>();
            this.segments.put(cell, retVal);
        }
        return retVal;
    }

    public DistalDendrite segmentForFlatIdx(int index) {
        return this.segmentForFlatIdx.get(index);
    }

    public int columnIndexForSegment(DistalDendrite segment) {
        return segment.getParentCell().getIndex() / this.cellsPerColumn;
    }

    public Map<Cell, List<DistalDendrite>> getSegmentMapping() {
        return new LinkedHashMap<Cell, List<DistalDendrite>>(this.segments);
    }

    public void setActiveSegments(List<DistalDendrite> l) {
        this.activeSegments = l;
    }

    public List<DistalDendrite> getActiveSegments() {
        return this.activeSegments;
    }

    public void setMatchingSegments(List<DistalDendrite> l) {
        this.matchingSegments = l;
    }

    public List<DistalDendrite> getMatchingSegments() {
        return this.matchingSegments;
    }

    public Synapse createSynapse(DistalDendrite segment, Cell presynapticCell, double permanence) {
        while (this.numSynapses(segment) >= (long)this.maxSynapsesPerSegment) {
            this.destroySynapse(this.minPermanenceSynapse(segment));
        }
        Synapse synapse = null;
        synapse = new Synapse(presynapticCell, segment, this.nextSynapseOrdinal, permanence);
        this.getSynapses(segment).add(synapse);
        this.getReceptorSynapses(presynapticCell, true).add(synapse);
        ++this.nextSynapseOrdinal;
        ++this.numSynapses;
        return synapse;
    }

    public void destroySynapse(Synapse synapse) {
        --this.numSynapses;
        this.removeSynapseFromPresynapticMap(synapse);
        this.getSynapses((DistalDendrite)synapse.getSegment()).remove(synapse);
    }

    public void removeSynapseFromPresynapticMap(Synapse synapse) {
        Cell cell = synapse.getPresynapticCell();
        Set<Synapse> presynapticSynapses = this.getReceptorSynapses(cell, false);
        presynapticSynapses.remove(synapse);
        if (presynapticSynapses.isEmpty()) {
            this.receptorSynapses.remove(cell);
        }
    }

    private Synapse minPermanenceSynapse(DistalDendrite dd) {
        List synapses = this.getSynapses(dd).stream().sorted().collect(Collectors.toList());
        Synapse min = null;
        double minPermanence = Double.MAX_VALUE;
        for (Synapse synapse : synapses) {
            if (synapse.destroyed() || !(synapse.getPermanence() < minPermanence - 1.0E-5)) continue;
            min = synapse;
            minPermanence = synapse.getPermanence();
        }
        return min;
    }

    public long numSynapses() {
        return this.numSynapses(null);
    }

    public long numSynapses(DistalDendrite optionalSegmentArg) {
        if (optionalSegmentArg != null) {
            return this.getSynapses(optionalSegmentArg).size();
        }
        return this.numSynapses;
    }

    public Set<Synapse> getReceptorSynapses(Cell cell) {
        return this.getReceptorSynapses(cell, false);
    }

    public Set<Synapse> getReceptorSynapses(Cell cell, boolean doLazyCreate) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell was null");
        }
        if (this.receptorSynapses == null) {
            this.receptorSynapses = new LinkedHashMap<Cell, LinkedHashSet<Synapse>>();
        }
        LinkedHashSet<Synapse> retVal = null;
        retVal = this.receptorSynapses.get(cell);
        if (retVal == null) {
            if (!doLazyCreate) {
                return Collections.emptySet();
            }
            retVal = new LinkedHashSet();
            this.receptorSynapses.put(cell, retVal);
        }
        return retVal;
    }

    public List<Synapse> getSynapses(DistalDendrite segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment was null");
        }
        if (this.distalSynapses == null) {
            this.distalSynapses = new LinkedHashMap<Segment, List<Synapse>>();
        }
        List<Synapse> retVal = null;
        retVal = this.distalSynapses.get(segment);
        if (retVal == null) {
            retVal = new ArrayList<Synapse>();
            this.distalSynapses.put(segment, retVal);
        }
        return retVal;
    }

    public List<Synapse> getSynapses(ProximalDendrite segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment was null");
        }
        if (this.proximalSynapses == null) {
            this.proximalSynapses = new LinkedHashMap<Segment, List<Synapse>>();
        }
        List<Synapse> retVal = null;
        retVal = this.proximalSynapses.get(segment);
        if (retVal == null) {
            retVal = new ArrayList<Synapse>();
            this.proximalSynapses.put(segment, retVal);
        }
        return retVal;
    }

    public Map<Cell, HashSet<Synapse>> getReceptorSynapseMapping() {
        return new LinkedHashMap<Cell, HashSet<Synapse>>(this.receptorSynapses);
    }

    public void clear() {
        this.activeCells.clear();
        this.winnerCells.clear();
        this.predictiveCells.clear();
    }

    public Set<Cell> getActiveCells() {
        return this.activeCells;
    }

    public void setActiveCells(Set<Cell> cells) {
        this.activeCells = cells;
    }

    public Set<Cell> getWinnerCells() {
        return this.winnerCells;
    }

    public void setWinnerCells(Set<Cell> cells) {
        this.winnerCells = cells;
    }

    public Set<Cell> getPredictiveCells() {
        if (this.predictiveCells.isEmpty()) {
            Cell previousCell = null;
            Cell currCell = null;
            ArrayList<DistalDendrite> temp = new ArrayList<DistalDendrite>(this.activeSegments);
            for (DistalDendrite activeSegment : temp) {
                currCell = activeSegment.getParentCell();
                if (currCell == previousCell) continue;
                previousCell = currCell;
                this.predictiveCells.add(previousCell);
            }
        }
        return this.predictiveCells;
    }

    public void clearPredictiveCells() {
        this.predictiveCells.clear();
    }

    public Column getColumn(int index) {
        return this.memory.getObject(index);
    }

    public void setColumnDimensions(int[] columnDimensions) {
        this.columnDimensions = columnDimensions;
    }

    public int[] getColumnDimensions() {
        return this.columnDimensions;
    }

    public void setInputDimensions(int[] inputDimensions) {
        this.inputDimensions = inputDimensions;
    }

    public int[] getInputDimensions() {
        return this.inputDimensions;
    }

    public void setCellsPerColumn(int cellsPerColumn) {
        this.cellsPerColumn = cellsPerColumn;
    }

    public int getCellsPerColumn() {
        return this.cellsPerColumn;
    }

    public void setActivationThreshold(int activationThreshold) {
        this.activationThreshold = activationThreshold;
    }

    public int getActivationThreshold() {
        return this.activationThreshold;
    }

    public void setLearningRadius(int learningRadius) {
        this.learningRadius = learningRadius;
    }

    public int getLearningRadius() {
        return this.learningRadius;
    }

    public void setMinThreshold(int minThreshold) {
        this.minThreshold = minThreshold;
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public void setMaxNewSynapseCount(int maxNewSynapseCount) {
        this.maxNewSynapseCount = maxNewSynapseCount;
    }

    public int getMaxNewSynapseCount() {
        return this.maxNewSynapseCount;
    }

    public void setMaxSegmentsPerCell(int maxSegmentsPerCell) {
        this.maxSegmentsPerCell = maxSegmentsPerCell;
    }

    public int getMaxSegmentsPerCell() {
        return this.maxSegmentsPerCell;
    }

    public void setMaxSynapsesPerSegment(int maxSynapsesPerSegment) {
        this.maxSynapsesPerSegment = maxSynapsesPerSegment;
    }

    public int getMaxSynapsesPerSegment() {
        return this.maxSynapsesPerSegment;
    }

    public void setInitialPermanence(double initialPermanence) {
        this.initialPermanence = initialPermanence;
    }

    public double getInitialPermanence() {
        return this.initialPermanence;
    }

    public void setConnectedPermanence(double connectedPermanence) {
        this.connectedPermanence = connectedPermanence;
    }

    public double getConnectedPermanence() {
        return this.connectedPermanence;
    }

    public void setPermanenceIncrement(double permanenceIncrement) {
        this.permanenceIncrement = permanenceIncrement;
    }

    public double getPermanenceIncrement() {
        return this.permanenceIncrement;
    }

    public void setPermanenceDecrement(double permanenceDecrement) {
        this.permanenceDecrement = permanenceDecrement;
    }

    public double getPermanenceDecrement() {
        return this.permanenceDecrement;
    }

    public void setPredictedSegmentDecrement(double predictedSegmentDecrement) {
        this.predictedSegmentDecrement = predictedSegmentDecrement;
    }

    public double getPredictedSegmentDecrement() {
        return this.predictedSegmentDecrement;
    }

    public static List<Integer> asCellIndexes(Collection<Cell> cells) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (Cell cell : cells) {
            ints.add(cell.getIndex());
        }
        return ints;
    }

    public static List<Integer> asColumnIndexes(Collection<Column> columns) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (Column col : columns) {
            ints.add(col.getIndex());
        }
        return ints;
    }

    public List<Cell> asCellObjects(Collection<Integer> cells) {
        ArrayList<Cell> objs = new ArrayList<Cell>();
        for (int i : cells) {
            objs.add(this.cells[i]);
        }
        return objs;
    }

    public List<Column> asColumnObjects(Collection<Integer> cols) {
        ArrayList<Column> objs = new ArrayList<Column>();
        for (int i : cols) {
            objs.add(this.memory.getObject(i));
        }
        return objs;
    }

    public LinkedHashSet<Column> getColumnSet(int[] indexes) {
        LinkedHashSet<Column> retVal = new LinkedHashSet<Column>();
        for (int i = 0; i < indexes.length; ++i) {
            retVal.add(this.memory.getObject(indexes[i]));
        }
        return retVal;
    }

    public List<Column> getColumnList(int[] indexes) {
        ArrayList<Column> retVal = new ArrayList<Column>();
        for (int i = 0; i < indexes.length; ++i) {
            retVal.add(this.memory.getObject(indexes[i]));
        }
        return retVal;
    }

    public void printParameters() {
        System.out.println("------------ SpatialPooler Parameters ------------------");
        System.out.println("numInputs                  = " + this.getNumInputs());
        System.out.println("numColumns                 = " + this.getNumColumns());
        System.out.println("cellsPerColumn             = " + this.getCellsPerColumn());
        System.out.println("columnDimensions           = " + Arrays.toString(this.getColumnDimensions()));
        System.out.println("numActiveColumnsPerInhArea = " + this.getNumActiveColumnsPerInhArea());
        System.out.println("potentialPct               = " + this.getPotentialPct());
        System.out.println("potentialRadius            = " + this.getPotentialRadius());
        System.out.println("globalInhibition           = " + this.getGlobalInhibition());
        System.out.println("localAreaDensity           = " + this.getLocalAreaDensity());
        System.out.println("inhibitionRadius           = " + this.getInhibitionRadius());
        System.out.println("stimulusThreshold          = " + this.getStimulusThreshold());
        System.out.println("synPermActiveInc           = " + this.getSynPermActiveInc());
        System.out.println("synPermInactiveDec         = " + this.getSynPermInactiveDec());
        System.out.println("synPermConnected           = " + this.getSynPermConnected());
        System.out.println("minPctOverlapDutyCycle     = " + this.getMinPctOverlapDutyCycles());
        System.out.println("minPctActiveDutyCycle      = " + this.getMinPctActiveDutyCycles());
        System.out.println("dutyCyclePeriod            = " + this.getDutyCyclePeriod());
        System.out.println("maxBoost                   = " + this.getMaxBoost());
        System.out.println("version                    = " + this.getVersion());
        System.out.println("\n------------ TemporalMemory Parameters ------------------");
        System.out.println("activationThreshold        = " + this.getActivationThreshold());
        System.out.println("learningRadius             = " + this.getLearningRadius());
        System.out.println("minThreshold               = " + this.getMinThreshold());
        System.out.println("maxNewSynapseCount         = " + this.getMaxNewSynapseCount());
        System.out.println("maxSynapsesPerSegment      = " + this.getMaxSynapsesPerSegment());
        System.out.println("maxSegmentsPerCell         = " + this.getMaxSegmentsPerCell());
        System.out.println("initialPermanence          = " + this.getInitialPermanence());
        System.out.println("connectedPermanence        = " + this.getConnectedPermanence());
        System.out.println("permanenceIncrement        = " + this.getPermanenceIncrement());
        System.out.println("permanenceDecrement        = " + this.getPermanenceDecrement());
        System.out.println("predictedSegmentDecrement  = " + this.getPredictedSegmentDecrement());
    }

    public String getPrintString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("---------------------- General -------------------------");
        pw.println("columnDimensions           = " + Arrays.toString(this.getColumnDimensions()));
        pw.println("inputDimensions            = " + Arrays.toString(this.getInputDimensions()));
        pw.println("cellsPerColumn             = " + this.getCellsPerColumn());
        pw.println("random                     = " + this.getRandom());
        pw.println("seed                       = " + this.getSeed());
        pw.println("\n------------ SpatialPooler Parameters ------------------");
        pw.println("numInputs                  = " + this.getNumInputs());
        pw.println("numColumns                 = " + this.getNumColumns());
        pw.println("numActiveColumnsPerInhArea = " + this.getNumActiveColumnsPerInhArea());
        pw.println("potentialPct               = " + this.getPotentialPct());
        pw.println("potentialRadius            = " + this.getPotentialRadius());
        pw.println("globalInhibition           = " + this.getGlobalInhibition());
        pw.println("localAreaDensity           = " + this.getLocalAreaDensity());
        pw.println("inhibitionRadius           = " + this.getInhibitionRadius());
        pw.println("stimulusThreshold          = " + this.getStimulusThreshold());
        pw.println("synPermActiveInc           = " + this.getSynPermActiveInc());
        pw.println("synPermInactiveDec         = " + this.getSynPermInactiveDec());
        pw.println("synPermConnected           = " + this.getSynPermConnected());
        pw.println("synPermBelowStimulusInc    = " + this.getSynPermBelowStimulusInc());
        pw.println("synPermTrimThreshold       = " + this.getSynPermTrimThreshold());
        pw.println("minPctOverlapDutyCycles    = " + this.getMinPctOverlapDutyCycles());
        pw.println("minPctActiveDutyCycles     = " + this.getMinPctActiveDutyCycles());
        pw.println("dutyCyclePeriod            = " + this.getDutyCyclePeriod());
        pw.println("wrapAround                 = " + this.isWrapAround());
        pw.println("maxBoost                   = " + this.getMaxBoost());
        pw.println("version                    = " + this.getVersion());
        pw.println("\n------------ TemporalMemory Parameters ------------------");
        pw.println("activationThreshold        = " + this.getActivationThreshold());
        pw.println("learningRadius             = " + this.getLearningRadius());
        pw.println("minThreshold               = " + this.getMinThreshold());
        pw.println("maxNewSynapseCount         = " + this.getMaxNewSynapseCount());
        pw.println("maxSynapsesPerSegment      = " + this.getMaxSynapsesPerSegment());
        pw.println("maxSegmentsPerCell         = " + this.getMaxSegmentsPerCell());
        pw.println("initialPermanence          = " + this.getInitialPermanence());
        pw.println("connectedPermanence        = " + this.getConnectedPermanence());
        pw.println("permanenceIncrement        = " + this.getPermanenceIncrement());
        pw.println("permanenceDecrement        = " + this.getPermanenceDecrement());
        pw.println("predictedSegmentDecrement  = " + this.getPredictedSegmentDecrement());
        return sw.toString();
    }

    public int[][] getConnecteds() {
        int[][] retVal = new int[this.getNumColumns()][];
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Pool pool = this.getPotentialPools().get(i);
            int[] indexes = pool.getDenseConnected(this);
            retVal[i] = indexes;
        }
        return retVal;
    }

    public int[][] getPotentials() {
        int[][] retVal = new int[this.getNumColumns()][];
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Pool pool = this.getPotentialPools().get(i);
            int[] indexes = pool.getDensePotential(this);
            retVal[i] = indexes;
        }
        return retVal;
    }

    public double[][] getPermanences() {
        double[][] retVal = new double[this.getNumColumns()][];
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Pool pool = this.getPotentialPools().get(i);
            double[] perm = pool.getDensePermanences(this);
            retVal[i] = perm;
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.activationThreshold;
        result = 31 * result + (this.activeCells == null ? 0 : this.activeCells.hashCode());
        result = 31 * result + Arrays.hashCode(this.activeDutyCycles);
        result = 31 * result + Arrays.hashCode(this.boostFactors);
        result = 31 * result + Arrays.hashCode(this.cells);
        result = 31 * result + this.cellsPerColumn;
        result = 31 * result + Arrays.hashCode(this.columnDimensions);
        result = 31 * result + (this.connectedCounts == null ? 0 : this.connectedCounts.hashCode());
        long temp = Double.doubleToLongBits(this.connectedPermanence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.dutyCyclePeriod;
        result = 31 * result + (this.globalInhibition ? 1231 : 1237);
        result = 31 * result + this.inhibitionRadius;
        temp = Double.doubleToLongBits(this.initConnectedPct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.initialPermanence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.inputDimensions);
        result = 31 * result + (this.inputMatrix == null ? 0 : this.inputMatrix.hashCode());
        result = 31 * result + this.spIterationLearnNum;
        result = 31 * result + this.spIterationNum;
        result = 31 * result + new Long(this.tmIteration).intValue();
        result = 31 * result + this.learningRadius;
        temp = Double.doubleToLongBits(this.localAreaDensity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxBoost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxNewSynapseCount;
        result = 31 * result + (this.memory == null ? 0 : this.memory.hashCode());
        result = 31 * result + Arrays.hashCode(this.minActiveDutyCycles);
        result = 31 * result + Arrays.hashCode(this.minOverlapDutyCycles);
        temp = Double.doubleToLongBits(this.minPctActiveDutyCycles);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minPctOverlapDutyCycles);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.minThreshold;
        temp = Double.doubleToLongBits(this.numActiveColumnsPerInhArea);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numColumns;
        result = 31 * result + this.numInputs;
        temp = this.numSynapses;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.overlapDutyCycles);
        temp = Double.doubleToLongBits(this.permanenceDecrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.permanenceIncrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.potentialPct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.potentialPools == null ? 0 : this.potentialPools.hashCode());
        result = 31 * result + this.potentialRadius;
        temp = Double.doubleToLongBits(this.predictedSegmentDecrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.predictiveCells == null ? 0 : this.predictiveCells.hashCode());
        result = 31 * result + (this.random == null ? 0 : this.random.hashCode());
        result = 31 * result + (this.receptorSynapses == null ? 0 : this.receptorSynapses.hashCode());
        result = 31 * result + this.seed;
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        temp = Double.doubleToLongBits(this.stimulusThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermActiveInc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermBelowStimulusInc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermConnected);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermInactiveDec);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermMax);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermMin);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermTrimThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.proximalSynapseCounter;
        result = 31 * result + (this.proximalSynapses == null ? 0 : this.proximalSynapses.hashCode());
        result = 31 * result + (this.distalSynapses == null ? 0 : this.distalSynapses.hashCode());
        result = 31 * result + Arrays.hashCode(this.tieBreaker);
        result = 31 * result + this.updatePeriod;
        temp = Double.doubleToLongBits(this.version);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.winnerCells == null ? 0 : this.winnerCells.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connections other = (Connections)obj;
        if (this.activationThreshold != other.activationThreshold) {
            return false;
        }
        if (this.activeCells == null ? other.activeCells != null : !this.activeCells.equals(other.activeCells)) {
            return false;
        }
        if (!Arrays.equals(this.activeDutyCycles, other.activeDutyCycles)) {
            return false;
        }
        if (!Arrays.equals(this.boostFactors, other.boostFactors)) {
            return false;
        }
        if (!Arrays.equals(this.cells, other.cells)) {
            return false;
        }
        if (this.cellsPerColumn != other.cellsPerColumn) {
            return false;
        }
        if (!Arrays.equals(this.columnDimensions, other.columnDimensions)) {
            return false;
        }
        if (this.connectedCounts == null ? other.connectedCounts != null : !this.connectedCounts.equals(other.connectedCounts)) {
            return false;
        }
        if (Double.doubleToLongBits(this.connectedPermanence) != Double.doubleToLongBits(other.connectedPermanence)) {
            return false;
        }
        if (this.dutyCyclePeriod != other.dutyCyclePeriod) {
            return false;
        }
        if (this.globalInhibition != other.globalInhibition) {
            return false;
        }
        if (this.inhibitionRadius != other.inhibitionRadius) {
            return false;
        }
        if (Double.doubleToLongBits(this.initConnectedPct) != Double.doubleToLongBits(other.initConnectedPct)) {
            return false;
        }
        if (Double.doubleToLongBits(this.initialPermanence) != Double.doubleToLongBits(other.initialPermanence)) {
            return false;
        }
        if (!Arrays.equals(this.inputDimensions, other.inputDimensions)) {
            return false;
        }
        if (this.inputMatrix == null ? other.inputMatrix != null : !this.inputMatrix.equals(other.inputMatrix)) {
            return false;
        }
        if (this.spIterationLearnNum != other.spIterationLearnNum) {
            return false;
        }
        if (this.spIterationNum != other.spIterationNum) {
            return false;
        }
        if (this.tmIteration != other.tmIteration) {
            return false;
        }
        if (this.learningRadius != other.learningRadius) {
            return false;
        }
        if (Double.doubleToLongBits(this.localAreaDensity) != Double.doubleToLongBits(other.localAreaDensity)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxBoost) != Double.doubleToLongBits(other.maxBoost)) {
            return false;
        }
        if (this.maxNewSynapseCount != other.maxNewSynapseCount) {
            return false;
        }
        if (this.memory == null ? other.memory != null : !this.memory.equals(other.memory)) {
            return false;
        }
        if (!Arrays.equals(this.minActiveDutyCycles, other.minActiveDutyCycles)) {
            return false;
        }
        if (!Arrays.equals(this.minOverlapDutyCycles, other.minOverlapDutyCycles)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minPctActiveDutyCycles) != Double.doubleToLongBits(other.minPctActiveDutyCycles)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minPctOverlapDutyCycles) != Double.doubleToLongBits(other.minPctOverlapDutyCycles)) {
            return false;
        }
        if (this.minThreshold != other.minThreshold) {
            return false;
        }
        if (Double.doubleToLongBits(this.numActiveColumnsPerInhArea) != Double.doubleToLongBits(other.numActiveColumnsPerInhArea)) {
            return false;
        }
        if (this.numColumns != other.numColumns) {
            return false;
        }
        if (this.numInputs != other.numInputs) {
            return false;
        }
        if (this.numSynapses != other.numSynapses) {
            return false;
        }
        if (!Arrays.equals(this.overlapDutyCycles, other.overlapDutyCycles)) {
            return false;
        }
        if (Double.doubleToLongBits(this.permanenceDecrement) != Double.doubleToLongBits(other.permanenceDecrement)) {
            return false;
        }
        if (Double.doubleToLongBits(this.permanenceIncrement) != Double.doubleToLongBits(other.permanenceIncrement)) {
            return false;
        }
        if (Double.doubleToLongBits(this.potentialPct) != Double.doubleToLongBits(other.potentialPct)) {
            return false;
        }
        if (this.potentialPools == null ? other.potentialPools != null : !this.potentialPools.equals(other.potentialPools)) {
            return false;
        }
        if (this.potentialRadius != other.potentialRadius) {
            return false;
        }
        if (Double.doubleToLongBits(this.predictedSegmentDecrement) != Double.doubleToLongBits(other.predictedSegmentDecrement)) {
            return false;
        }
        if (this.predictiveCells == null ? other.predictiveCells != null : !this.getPredictiveCells().equals(other.getPredictiveCells())) {
            return false;
        }
        if (this.receptorSynapses == null ? other.receptorSynapses != null : !this.receptorSynapses.toString().equals(other.receptorSynapses.toString())) {
            return false;
        }
        if (this.seed != other.seed) {
            return false;
        }
        if (this.segments == null ? other.segments != null : !this.segments.equals(other.segments)) {
            return false;
        }
        if (Double.doubleToLongBits(this.stimulusThreshold) != Double.doubleToLongBits(other.stimulusThreshold)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermActiveInc) != Double.doubleToLongBits(other.synPermActiveInc)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermBelowStimulusInc) != Double.doubleToLongBits(other.synPermBelowStimulusInc)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermConnected) != Double.doubleToLongBits(other.synPermConnected)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermInactiveDec) != Double.doubleToLongBits(other.synPermInactiveDec)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermMax) != Double.doubleToLongBits(other.synPermMax)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermMin) != Double.doubleToLongBits(other.synPermMin)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermTrimThreshold) != Double.doubleToLongBits(other.synPermTrimThreshold)) {
            return false;
        }
        if (this.proximalSynapseCounter != other.proximalSynapseCounter) {
            return false;
        }
        if (this.proximalSynapses == null ? other.proximalSynapses != null : !this.proximalSynapses.equals(other.proximalSynapses)) {
            return false;
        }
        if (this.distalSynapses == null ? other.distalSynapses != null : !this.distalSynapses.equals(other.distalSynapses)) {
            return false;
        }
        if (!Arrays.equals(this.tieBreaker, other.tieBreaker)) {
            return false;
        }
        if (this.updatePeriod != other.updatePeriod) {
            return false;
        }
        if (Double.doubleToLongBits(this.version) != Double.doubleToLongBits(other.version)) {
            return false;
        }
        return !(this.winnerCells == null ? other.winnerCells != null : !this.winnerCells.equals(other.winnerCells));
    }

    public static class Activity
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int[] numActiveConnected;
        public int[] numActivePotential;

        public Activity(int[] numConnected, int[] numPotential) {
            this.numActiveConnected = numConnected;
            this.numActivePotential = numPotential;
        }
    }
}

