/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.datagen.ResourceLocator;
import org.numenta.nupic.network.sensor.MetaSource;

public class CSVSource
implements MetaSource {
    private List<String[]> header;
    private List<String[]> body;
    private List<List<String[]>> file;
    private TObjectIntMap<String> fieldIndexMap = new TObjectIntHashMap();
    private FieldMetaType[] fieldTypes;
    private String datePattern;
    private DateTimeFormatter format;
    public static final int HEADER_SIZE = 3;
    public static final int HEADER_IDX = 0;
    public static final int BODY_IDX = 1;

    public CSVSource(String fileName) {
        this(fileName, null);
    }

    public CSVSource(String fileName, String datePattern) {
        int i;
        String s = ResourceLocator.path(fileName);
        this.file = this.createSource(new File(s));
        this.header = this.file.get(0);
        this.body = this.file.get(1);
        this.datePattern = datePattern;
        this.format = DateTimeFormat.forPattern((String)this.datePattern);
        for (i = 0; i < this.header.get(0).length; ++i) {
            this.fieldIndexMap.put((Object)this.header.get(0)[i], i);
        }
        this.fieldTypes = new FieldMetaType[this.header.get(0).length];
        for (i = 0; i < this.fieldTypes.length; ++i) {
            this.fieldTypes[i] = FieldMetaType.fromString(this.header.get(1)[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String[]>> createSource(File f) {
        ArrayList<String[]> body = new ArrayList<String[]>();
        ArrayList<String[]> header = new ArrayList<String[]>();
        ArrayList<List<String[]>> file = new ArrayList<List<String[]>>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = null;
            int headerIdx = 0;
            while ((line = br.readLine()) != null) {
                if (headerIdx++ < 3) {
                    header.add(line.split("[\\s]*\\,[\\s]*"));
                    continue;
                }
                body.add(line.split("[\\s]*\\,[\\s]*"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        file.add(header);
        file.add(body);
        return file;
    }

    @Override
    public List<String[]> getHeader() {
        return this.header;
    }

    @Override
    public List<String[]> getBody() {
        return this.body;
    }

    @Override
    public Iterator<Map<String, Object>> multiIterator() {
        return new Iterator<Map<String, Object>>(){
            int idx = -1;
            int size = CSVSource.access$000(CSVSource.this).size();
            Map<String, Object> map = new HashMap<String, Object>(){

                @Override
                public Object get(Object name) {
                    int typeIndex = CSVSource.this.fieldIndexMap.get(name);
                    if (CSVSource.this.fieldTypes[typeIndex] == FieldMetaType.DATETIME) {
                        if (CSVSource.this.format == null) {
                            throw new IllegalStateException("DateField requires pattern configuration on construction.");
                        }
                        return CSVSource.this.format.parseDateTime(((String[])CSVSource.this.body.get(idx))[typeIndex]);
                    }
                    if (CSVSource.this.fieldTypes[typeIndex] == FieldMetaType.FLOAT || CSVSource.this.fieldTypes[typeIndex] == FieldMetaType.INTEGER) {
                        return Double.parseDouble(((String[])CSVSource.this.body.get(idx))[CSVSource.this.fieldIndexMap.get(name)]);
                    }
                    return ((String[])CSVSource.this.body.get(idx))[CSVSource.this.fieldIndexMap.get(name)];
                }
            };

            @Override
            public boolean hasNext() {
                return this.idx < this.size - 1;
            }

            @Override
            public Map<String, Object> next() {
                ++this.idx;
                return this.map;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }
}

