/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.numenta.nupic.network.sensor.BatchedCsvStream;
import org.numenta.nupic.network.sensor.MetaStream;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;
import org.numenta.nupic.network.sensor.ValueList;

public class FileSensor
implements Sensor<File>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HEADER_SIZE = 3;
    private static final int BATCH_SIZE = 20;
    private static final boolean DEFAULT_PARALLEL_MODE = false;
    private transient BatchedCsvStream<String[]> stream;
    private SensorParams params;

    private FileSensor(SensorParams params) {
        this.params = params;
        if (!params.hasKey("PATH")) {
            throw new IllegalArgumentException("Passed improperly formed Tuple: no key for \"PATH\"");
        }
        String pathStr = (String)params.get("PATH");
        if (pathStr.indexOf("!") != -1) {
            pathStr = pathStr.indexOf("file:") != -1 ? pathStr.substring("file:".length()) : pathStr;
            Stream<String> stream = FileSensor.getJarEntryStream(pathStr);
            this.stream = BatchedCsvStream.batch(stream, 20, false, 3);
        } else {
            File f = new File(pathStr);
            if (!f.exists()) {
                throw new IllegalArgumentException("Passed improperly formed Tuple: invalid PATH: " + params.get("PATH"));
            }
            try {
                Stream<String> stream = Files.lines(f.toPath(), Charset.forName("UTF-8"));
                this.stream = BatchedCsvStream.batch(stream, 20, false, 3);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Sensor<File> create(SensorParams p) {
        FileSensor fs = new FileSensor(p);
        return fs;
    }

    @Override
    public SensorParams getSensorParams() {
        return this.params;
    }

    @Override
    public <K> MetaStream<K> getInputStream() {
        return this.stream;
    }

    @Override
    public ValueList getMetaInfo() {
        return this.stream.getMeta();
    }

    public static Stream<String> getJarEntryStream(String path) {
        Stream retVal = null;
        String[] parts = path.split("\\!");
        try {
            JarFile jar = new JarFile(parts[0]);
            String innerPath = parts[1];
            innerPath = innerPath.startsWith("!") ? innerPath.substring(1) : innerPath;
            InputStream inStream = jar.getInputStream(jar.getEntry(innerPath));
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
            retVal = (Stream)br.lines().onClose(() -> {
                try {
                    br.close();
                    jar.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static void main(String[] args) {
        String filepart = System.getProperty("user.home") + "/git/htm.java/src/test/resources/pathtest.jar";
        File f = new File(filepart);
        System.out.println("file exists ? " + f.exists());
        String path = filepart + "!rec-center-hourly.csv";
        Stream<String> stream = FileSensor.getJarEntryStream(path);
        stream.forEach(l -> System.out.println((String)l));
    }
}

