/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.numenta.nupic.network.sensor.BatchedCsvStream;
import org.numenta.nupic.network.sensor.MetaStream;
import org.numenta.nupic.network.sensor.Publisher;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;
import org.numenta.nupic.network.sensor.ValueList;
import rx.Observable;

public class ObservableSensor<T>
implements Sensor<Observable<T>> {
    private static final long serialVersionUID = 1L;
    private static final int HEADER_SIZE = 3;
    private static final int BATCH_SIZE = 20;
    private static final boolean DEFAULT_PARALLEL_MODE = false;
    private transient BatchedCsvStream<String[]> stream;
    private SensorParams params;

    public ObservableSensor(SensorParams params) {
        if (!params.hasKey("ONSUB")) {
            throw new IllegalArgumentException("Passed improperly formed Tuple: no key for \"ONSUB\"");
        }
        this.params = params;
        Observable<String> obs = null;
        Object publisher = params.get("ONSUB");
        obs = publisher instanceof Publisher ? ((Publisher)publisher).observable() : (publisher instanceof Supplier ? ((Publisher)((Supplier)publisher).get()).observable() : (Observable<String>)publisher);
        final Iterator observerator = obs.toBlocking().getIterator();
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return observerator.hasNext();
            }

            @Override
            public String next() {
                return (String)observerator.next();
            }
        };
        int characteristics = 20;
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, characteristics);
        this.stream = BatchedCsvStream.batch(StreamSupport.stream(spliterator, false), 20, false, 3);
    }

    public static <T> Sensor<T> create(SensorParams p) {
        ObservableSensor<T> sensor = new ObservableSensor<T>(p);
        return sensor;
    }

    @Override
    public SensorParams getSensorParams() {
        return this.params;
    }

    @Override
    public <K> MetaStream<K> getInputStream() {
        return this.stream;
    }

    @Override
    public ValueList getMetaInfo() {
        return this.stream.getMeta();
    }
}

