/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.io.Serializable;

public class Coordinator
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] dimensions;
    protected int[] dimensionMultiples;
    protected boolean isColumnMajor;
    protected int numDimensions;

    public Coordinator(int[] shape) {
        this(shape, false);
    }

    public Coordinator(int[] shape, boolean useColumnMajorOrdering) {
        this.dimensions = shape;
        this.numDimensions = shape.length;
        this.dimensionMultiples = this.initDimensionMultiples(useColumnMajorOrdering ? Coordinator.reverse(shape) : shape);
        this.isColumnMajor = useColumnMajorOrdering;
    }

    public int computeIndex(int[] coordinates) {
        int[] localMults = this.isColumnMajor ? Coordinator.reverse(this.dimensionMultiples) : this.dimensionMultiples;
        int base = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            base += localMults[i] * coordinates[i];
        }
        return base;
    }

    public int[] computeCoordinates(int index) {
        int[] returnVal = new int[this.numDimensions];
        int base = index;
        for (int i = 0; i < this.dimensionMultiples.length; ++i) {
            int quotient = base / this.dimensionMultiples[i];
            base %= this.dimensionMultiples[i];
            returnVal[i] = quotient;
        }
        return this.isColumnMajor ? Coordinator.reverse(returnVal) : returnVal;
    }

    protected int[] initDimensionMultiples(int[] dimensions) {
        int holder = 1;
        int len = dimensions.length;
        int[] dimensionMultiples = new int[this.numDimensions];
        for (int i = 0; i < len; ++i) {
            dimensionMultiples[len - 1 - i] = holder *= i == 0 ? 1 : dimensions[len - i];
        }
        return dimensionMultiples;
    }

    public static int[] reverse(int[] input) {
        int[] retVal = new int[input.length];
        int i = input.length - 1;
        int j = 0;
        while (i >= 0) {
            retVal[j] = input[i];
            --i;
            ++j;
        }
        return retVal;
    }
}

