/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import com.cedarsoftware.util.DeepEquals;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

public class Deque<E>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedBlockingDeque<E> backingList = new LinkedBlockingDeque();
    private int capacity;
    private int currentSize;

    public Deque(int capacity) {
        this.capacity = capacity;
    }

    public boolean append(E t) {
        boolean ret;
        boolean bl = ret = this.currentSize == this.capacity;
        if (ret) {
            this.backingList.removeFirst();
            this.backingList.addLast(t);
        } else {
            this.backingList.addLast(t);
            ++this.currentSize;
        }
        return ret;
    }

    public boolean insert(E t) {
        boolean ret;
        boolean bl = ret = this.currentSize == this.capacity;
        if (ret) {
            this.backingList.removeLast();
            this.backingList.addFirst(t);
        } else {
            this.backingList.addFirst(t);
            ++this.currentSize;
        }
        return ret;
    }

    public E pushLast(E t) {
        boolean ret;
        E retVal = null;
        boolean bl = ret = this.currentSize == this.capacity;
        if (ret) {
            retVal = this.backingList.removeFirst();
            this.backingList.addLast(t);
        } else {
            this.backingList.addLast(t);
            ++this.currentSize;
        }
        return retVal;
    }

    public E pushFirst(E t) {
        boolean ret;
        E retVal = null;
        boolean bl = ret = this.currentSize == this.capacity;
        if (ret) {
            retVal = this.backingList.removeLast();
            this.backingList.addFirst(t);
        } else {
            this.backingList.addFirst(t);
            ++this.currentSize;
        }
        return retVal;
    }

    public void clear() {
        this.backingList.clear();
        this.currentSize = 0;
    }

    public E takeFirst() {
        if (this.currentSize == 0) {
            return null;
        }
        E val = null;
        try {
            val = this.backingList.takeFirst();
            --this.currentSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public E takeLast() {
        if (this.currentSize == 0) {
            return null;
        }
        E val = null;
        try {
            val = this.backingList.takeLast();
            --this.currentSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public E head() {
        E val = null;
        try {
            val = this.backingList.takeFirst();
            --this.currentSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public E tail() {
        E val = null;
        try {
            val = this.backingList.takeLast();
            --this.currentSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public <T> T[] toArray(T[] a) {
        return this.backingList.toArray(a);
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.capacity;
    }

    public void resize(int newCapacity) {
        if (this.capacity == newCapacity) {
            return;
        }
        if (this.capacity > newCapacity) {
            throw new IllegalArgumentException("Cannot resize to less than the original capacity: " + this.capacity + " > " + newCapacity);
        }
        this.capacity = newCapacity;
    }

    public E peekFirst() {
        return this.backingList.peekFirst();
    }

    public E peekLast() {
        return this.backingList.peekLast();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingList.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backingList == null ? 0 : DeepEquals.deepHashCode(this.backingList));
        result = 31 * result + this.capacity;
        result = 31 * result + this.currentSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Deque other = (Deque)obj;
        if (this.capacity != other.capacity) {
            return false;
        }
        if (this.currentSize != other.currentSize) {
            return false;
        }
        return !(this.backingList == null ? other.backingList != null : !this.deepEquals(other));
    }

    private boolean deepEquals(Deque<E> other) {
        Iterator<E> otherIt = other.iterator();
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (otherIt.hasNext() && it.next().equals(otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.backingList.toString() + " capacity: " + this.capacity;
    }
}

