/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.set.hash.TIntHashSet;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.util.AbstractSparseBinaryMatrix;

public class FastConnectionsMatrix
extends AbstractSparseBinaryMatrix
implements Persistable {
    private static final long serialVersionUID = 1L;
    private TIntHashSet[] columns;

    public FastConnectionsMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public FastConnectionsMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.columns = new TIntHashSet[dimensions[0]];
    }

    @Override
    public Object getSlice(int ... coordinates) {
        if (coordinates.length > this.numDimensions - 1) {
            this.sliceError(coordinates);
        }
        int[] slice = new int[this.dimensions[1]];
        for (int i = 0; i < this.dimensions[1]; ++i) {
            slice[i] = this.columns[coordinates[0]].contains(i) ? 1 : 0;
        }
        return slice;
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int index : this.getColumnInput(i).toArray()) {
                if (inputVector[index] == 0) continue;
                int n = i;
                results[n] = results[n] + 1;
            }
        }
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results, double stimulusThreshold) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            int[] columnIndexes = this.getColumnInput(i).toArray();
            for (int j = 0; j < columnIndexes.length; ++j) {
                if (inputVector[columnIndexes[j]] != 0) {
                    int n = i;
                    results[n] = results[n] + 1;
                }
                if (j != columnIndexes.length - 1 || !((double)results[i] < stimulusThreshold)) continue;
                results[i] = 0;
            }
        }
    }

    @Override
    public FastConnectionsMatrix set(int index, Object value) {
        this.set(index, (int)((Integer)value));
        return this;
    }

    @Override
    public AbstractSparseBinaryMatrix set(int value, int ... coordinates) {
        TIntHashSet input = this.getColumnInput(coordinates[0]);
        if (value == 0) {
            input.remove(coordinates[1]);
        } else {
            input.add(coordinates[1]);
        }
        return this;
    }

    @Override
    public Integer get(int index) {
        int[] coordinates = this.computeCoordinates(index);
        return this.getColumnInput(coordinates[0]).contains(coordinates[1]) ? 1 : 0;
    }

    private TIntHashSet getColumnInput(int i) {
        if (this.columns[i] == null) {
            this.columns[i] = new TIntHashSet();
        }
        return this.columns[i];
    }

    @Override
    public void clearStatistics(int row) {
        this.getColumnInput(row).clear();
    }

    @Override
    public int getTrueCount(int index) {
        return this.getColumnInput(index).size();
    }

    @Override
    public int[] getTrueCounts() {
        int[] trueCounts = new int[this.dimensions[0]];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            trueCounts[i] = this.getTrueCount(i);
        }
        return trueCounts;
    }

    @Override
    public AbstractSparseBinaryMatrix setForTest(int index, int value) {
        return this.set(index, value);
    }
}

