/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import chaschev.lang.Pair;
import java.util.List;
import java.util.function.Function;
import org.numenta.nupic.util.Generator;
import org.numenta.nupic.util.IntGenerator;
import org.numenta.nupic.util.PeekableIterator;

public class GroupBy<T, R>
implements Generator<Pair<T, R>>,
PeekableIterator<Pair<T, R>> {
    private static final long serialVersionUID = 1L;
    private List<T> iter;
    private Function<T, R> fn;
    private Generator<Integer> range;
    private Pair<T, R> next;

    public GroupBy(List<T> l, Function<T, R> fn) {
        this.iter = l;
        this.fn = fn;
        this.range = IntGenerator.of(0, this.iter.size());
        if (this.range.hasNext()) {
            T t = this.iter.get(this.range.next());
            this.next = new Pair(t, fn.apply(t));
        }
    }

    @Override
    public Pair<T, R> peek() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Pair<T, R> next() {
        Object t = this.range.hasNext() ? (Object)this.iter.get(this.range.next()) : null;
        Pair<T, R> ret = this.next;
        this.next = t != null ? new Pair(t, this.fn.apply(t)) : null;
        return ret;
    }

    public static <T, R> GroupBy<T, R> of(List<T> l, Function<T, R> fn) {
        return new GroupBy<T, R>(l, fn);
    }
}

