/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.util.AbstractSparseBinaryMatrix;
import org.numenta.nupic.util.ArrayUtils;

public class SparseBinaryMatrix
extends AbstractSparseBinaryMatrix
implements Persistable {
    private static final long serialVersionUID = 1L;
    private Object backingArray;

    public SparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.backingArray = Array.newInstance(Integer.TYPE, dimensions);
    }

    private void back(int val, int ... coordinates) {
        ArrayUtils.setValue(this.backingArray, val, coordinates);
        this.setTrueCount(coordinates[0], ArrayUtils.aggregateArray(((Object[])this.backingArray)[coordinates[0]]));
    }

    @Override
    public Object getSlice(int ... coordinates) {
        Object slice = ArrayUtils.getValue(this.backingArray, coordinates);
        if (!slice.getClass().isArray()) {
            this.sliceError(coordinates);
        }
        return slice;
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            int[] slice = (int[])(this.dimensions.length > 1 ? this.getSlice(i) : this.backingArray);
            for (int j = 0; j < slice.length; ++j) {
                int n = i;
                results[n] = results[n] + inputVector[j] * slice[j];
            }
        }
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results, double stimulusThreshold) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            int[] slice = (int[])(this.dimensions.length > 1 ? this.getSlice(i) : this.backingArray);
            for (int j = 0; j < slice.length; ++j) {
                int n = i;
                results[n] = results[n] + inputVector[j] * slice[j];
                if (j != slice.length - 1) continue;
                int n2 = i;
                results[n2] = results[n2] - ((double)results[i] < stimulusThreshold ? results[i] : 0);
            }
        }
    }

    @Override
    public AbstractSparseBinaryMatrix set(int index, int value) {
        int[] coordinates = this.computeCoordinates(index);
        return this.set(value, coordinates);
    }

    @Override
    public AbstractSparseBinaryMatrix set(int value, int ... coordinates) {
        this.back(value, coordinates);
        return this;
    }

    @Override
    public AbstractSparseBinaryMatrix set(int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    @Override
    public void clearStatistics(int row) {
        this.setTrueCount(row, 0);
        int[] slice = (int[])Array.get(this.backingArray, row);
        Arrays.fill(slice, 0);
    }

    @Override
    public AbstractSparseBinaryMatrix set(int index, Object value) {
        this.set(index, (int)((Integer)value));
        return this;
    }

    @Override
    public Integer get(int index) {
        int[] coordinates = this.computeCoordinates(index);
        if (coordinates.length == 1) {
            return Array.getInt(this.backingArray, index);
        }
        return (Integer)ArrayUtils.getValue(this.backingArray, coordinates);
    }

    @Override
    public AbstractSparseBinaryMatrix setForTest(int index, int value) {
        ArrayUtils.setValue(this.backingArray, value, this.computeCoordinates(index));
        return this;
    }
}

