/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.util.NamedTuple;

public class Statistic
implements Persistable {
    private static final long serialVersionUID = 1L;
    public final double mean;
    public final double variance;
    public final double stdev;
    public final NamedTuple entries;

    public Statistic(double mean, double variance, double stdev) {
        this.mean = mean;
        this.variance = variance;
        this.stdev = stdev;
        this.entries = new NamedTuple(new String[]{"mean", "variance", "stdev"}, new Object[]{mean, variance, stdev});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.stdev);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.variance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statistic other = (Statistic)obj;
        if (Double.doubleToLongBits(this.mean) != Double.doubleToLongBits(other.mean)) {
            return false;
        }
        if (Double.doubleToLongBits(this.stdev) != Double.doubleToLongBits(other.stdev)) {
            return false;
        }
        return Double.doubleToLongBits(this.variance) == Double.doubleToLongBits(other.variance);
    }
}

