/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.numenta.nupic.encoders.DecodeResult;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.RangeList;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.MinMax;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassThroughEncoder<T>
extends Encoder<T> {
    private static final long serialVersionUID = 1L;
    protected final Logger LOGGER = LoggerFactory.getLogger(PassThroughEncoder.class);

    protected PassThroughEncoder() {
    }

    public PassThroughEncoder(int outputWidth, int outputBitsOnCount) {
        super.setW(outputBitsOnCount);
        super.setN(outputWidth);
        super.setForced(false);
        this.LOGGER.info("Building new PassThroughEncoder instance, outputWidth: {} outputBitsOnCount: {}", (Object)outputWidth, (Object)outputBitsOnCount);
    }

    public static Encoder.Builder<Builder, PassThroughEncoder<int[]>> builder() {
        return new Builder();
    }

    public void init() {
        this.setForced(false);
    }

    @Override
    public TDoubleList closenessScores(TDoubleList expValues, TDoubleList actValues, boolean fractional) {
        TDoubleArrayList result = new TDoubleArrayList();
        double ratio = 1.0;
        double expectedSum = expValues.sum();
        double actualSum = actValues.sum();
        if (actualSum > expectedSum) {
            double diff = actualSum - expectedSum;
            ratio = diff < expectedSum ? 1.0 - diff / expectedSum : 1.0 / diff;
        }
        int[] expectedInts = ArrayUtils.toIntArray(expValues.toArray());
        int[] actualInts = ArrayUtils.toIntArray(actValues.toArray());
        int[] overlap = ArrayUtils.and(expectedInts, actualInts);
        int overlapSum = ArrayUtils.sum(overlap);
        double r = 0.0;
        if (expectedSum != 0.0) {
            r = (double)overlapSum / expectedSum;
        }
        r *= ratio;
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("closenessScores for expValues: {} and actValues: {} is: {}", new Object[]{Arrays.toString(expectedInts), actualInts, r});
        }
        result.add(r);
        return result;
    }

    @Override
    public int getWidth() {
        return this.n;
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    @Override
    public void encodeIntoArray(T t, int[] output) {
        int[] input = (int[])t;
        if (input.length != output.length) {
            throw new IllegalArgumentException(String.format("Different input (%d) and output (%d) sizes", input.length, output.length));
        }
        if (ArrayUtils.sum(input) != this.w) {
            throw new IllegalArgumentException(String.format("Input has %d bits but w was set to %d.", ArrayUtils.sum(input), this.w));
        }
        System.arraycopy(input, 0, output, 0, input.length);
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("encodeIntoArray: Input: {} \nOutput: {} ", (Object)Arrays.toString(input), (Object)Arrays.toString(output));
        }
    }

    @Override
    public Tuple decode(int[] encoded, String parentFieldName) {
        String fieldName = this.name;
        if (parentFieldName != null && parentFieldName.length() > 0 && this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("Decoding Field: {}.{}", (Object)parentFieldName, (Object)this.name);
        }
        ArrayList<MinMax> ranges = new ArrayList<MinMax>();
        ranges.add(new MinMax(0.0, 0.0));
        RangeList inner = new RangeList((List<MinMax>)ranges, "input");
        HashMap<String, RangeList> fieldsDict = new HashMap<String, RangeList>();
        fieldsDict.put(fieldName, inner);
        return new DecodeResult((Map<String, RangeList>)fieldsDict, Arrays.asList(fieldName));
    }

    @Override
    public void setLearning(boolean learningEnabled) {
    }

    @Override
    public <T> List<T> getBucketValues(Class<T> returnType) {
        return null;
    }

    public static class Builder
    extends Encoder.Builder<Builder, PassThroughEncoder<int[]>> {
        private Builder() {
        }

        @Override
        public PassThroughEncoder<int[]> build() {
            this.encoder = new PassThroughEncoder();
            super.build();
            ((PassThroughEncoder)this.encoder).init();
            return (PassThroughEncoder)this.encoder;
        }
    }
}

