/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;

public class DistalDendrite
extends Segment
implements Persistable {
    private static final long serialVersionUID = 1L;
    private Cell cell;
    private long lastUsedIteration;
    public int ordinal = -1;

    public DistalDendrite(Cell cell, int flatIdx, long lastUsedIteration, int ordinal) {
        super(flatIdx);
        this.cell = cell;
        this.ordinal = ordinal;
        this.lastUsedIteration = lastUsedIteration;
    }

    public Cell getParentCell() {
        return this.cell;
    }

    public List<Synapse> getAllSynapses(Connections c) {
        return c.getSynapses(this);
    }

    public Set<Synapse> getActiveSynapses(Connections c, Set<Cell> activeCells) {
        LinkedHashSet<Synapse> synapses = new LinkedHashSet<Synapse>();
        for (Synapse synapse : c.getSynapses(this)) {
            if (!activeCells.contains(synapse.getPresynapticCell())) continue;
            synapses.add(synapse);
        }
        return synapses;
    }

    public void setLastUsedIteration(long iteration) {
        this.lastUsedIteration = iteration;
    }

    public long lastUsedIteration() {
        return this.lastUsedIteration;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String toString() {
        return String.valueOf(this.index);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cell == null ? 0 : this.cell.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistalDendrite other = (DistalDendrite)obj;
        return !(this.cell == null ? other.cell != null : !this.cell.equals(other.cell));
    }
}

