/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import gnu.trove.TIntCollection;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.stream.IntStream;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.util.ArrayUtils;

public class Pool
implements Persistable {
    private static final long serialVersionUID = 1L;
    int size;
    private TIntHashSet synapseConnections = new TIntHashSet();
    private TIntObjectMap<Synapse> synapsesBySourceIndex = new TIntObjectHashMap();

    public Pool(int size) {
        this.size = size;
    }

    public double getPermanence(Synapse s) {
        return ((Synapse)this.synapsesBySourceIndex.get(s.getInputIndex())).getPermanence();
    }

    public void setPermanence(Connections c, Synapse s, double permanence) {
        s.setPermanence(c, permanence);
    }

    public void updatePool(Connections c, Synapse s, double permanence) {
        int inputIndex = s.getInputIndex();
        if (this.synapsesBySourceIndex.get(inputIndex) == null) {
            this.synapsesBySourceIndex.put(inputIndex, (Object)s);
        }
        if (permanence >= c.getSynPermConnected()) {
            this.synapseConnections.add(inputIndex);
        } else {
            this.synapseConnections.remove(inputIndex);
        }
    }

    public void resetConnections() {
        this.synapseConnections.clear();
    }

    public Synapse getSynapseWithInput(int inputIndex) {
        return (Synapse)this.synapsesBySourceIndex.get(inputIndex);
    }

    public double[] getSparsePermanences() {
        double[] retVal = new double[this.size];
        int[] keys = this.synapsesBySourceIndex.keys();
        int x = 0;
        int j = this.size - 1;
        while (x < this.size) {
            retVal[j] = ((Synapse)this.synapsesBySourceIndex.get(keys[x])).getPermanence();
            ++x;
            --j;
        }
        return retVal;
    }

    public double[] getDensePermanences(Connections c) {
        int[] keys;
        double[] retVal = new double[c.getNumInputs()];
        for (int inputIndex : keys = this.synapsesBySourceIndex.keys()) {
            retVal[inputIndex] = ((Synapse)this.synapsesBySourceIndex.get(inputIndex)).getPermanence();
        }
        return retVal;
    }

    public int[] getSparsePotential() {
        return ArrayUtils.reverse(this.synapsesBySourceIndex.keys());
    }

    public int[] getDensePotential(Connections c) {
        return IntStream.range(0, c.getNumInputs()).map(i -> this.synapsesBySourceIndex.containsKey(i) ? 1 : 0).toArray();
    }

    public int[] getDenseConnected(Connections c) {
        return IntStream.range(0, c.getNumInputs()).map(i -> this.synapseConnections.contains(i) ? 1 : 0).toArray();
    }

    public void destroySynapse(Synapse synapse) {
        this.synapseConnections.remove(synapse.getInputIndex());
        this.synapsesBySourceIndex.remove(synapse.getInputIndex());
        if (synapse.getSegment() instanceof DistalDendrite) {
            this.destroy();
        }
    }

    public void destroy() {
        this.synapseConnections.clear();
        this.synapsesBySourceIndex.clear();
        this.synapseConnections = null;
        this.synapsesBySourceIndex = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size;
        result = 31 * result + (this.synapseConnections == null ? 0 : this.synapseConnections.toString().hashCode());
        result = 31 * result + (this.synapsesBySourceIndex == null ? 0 : this.synapsesBySourceIndex.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pool other = (Pool)obj;
        if (this.size != other.size) {
            return false;
        }
        if (this.synapseConnections == null ? other.synapseConnections != null : !this.synapseConnections.containsAll((TIntCollection)other.synapseConnections) || !other.synapseConnections.containsAll((TIntCollection)this.synapseConnections)) {
            return false;
        }
        return !(this.synapsesBySourceIndex == null ? other.synapsesBySourceIndex != null : !this.synapsesBySourceIndex.toString().equals(other.synapsesBySourceIndex.toString()));
    }
}

