/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.numenta.nupic.model.Cell;

public class SDR {
    public static int[] asColumnIndices(int[] cells, int cellsPerColumn) {
        IntStream op = Arrays.stream(cells);
        return op.map(cell -> cell / cellsPerColumn).distinct().toArray();
    }

    public static int[] asColumnIndices(List<Integer> cells, int cellsPerColumn) {
        IntStream op = cells.stream().mapToInt(c -> c);
        return op.map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] cellsToColumns(List<Cell> cells, int cellsPerColumn) {
        IntStream op = cells.stream().mapToInt(c -> c.getIndex());
        return op.map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] cellsAsColumnIndices(Set<Cell> cells, int cellsPerColumn) {
        return cells.stream().mapToInt(c -> c.getIndex()).sorted().map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] asColumnList(Collection<Cell> cells) {
        return cells.stream().mapToInt(c -> c.getColumn().getIndex()).sorted().distinct().toArray();
    }

    public static int[] asCellIndices(Collection<Cell> cells) {
        int[] retVal = new int[cells.size()];
        int i = 0;
        ArrayList<Cell> newCells = new ArrayList<Cell>(cells);
        for (Cell cell : newCells) {
            retVal[i++] = cell.getIndex();
        }
        return retVal;
    }
}

