/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.Segment;

public class Synapse
implements Persistable,
Comparable<Synapse> {
    private static final long serialVersionUID = 1L;
    private Cell sourceCell;
    private Segment segment;
    private Pool pool;
    private int synapseIndex;
    private Integer boxedIndex;
    private int inputIndex;
    private double permanence;
    private boolean destroyed;

    public Synapse() {
    }

    public Synapse(Cell presynapticCell, Segment segment, int index, double permanence) {
        this.sourceCell = presynapticCell;
        this.segment = segment;
        this.synapseIndex = index;
        this.boxedIndex = new Integer(index);
        this.inputIndex = presynapticCell.getIndex();
        this.permanence = permanence;
    }

    public Synapse(Connections c, Cell sourceCell, Segment segment, Pool pool, int index, int inputIndex) {
        this.sourceCell = sourceCell;
        this.segment = segment;
        this.pool = pool;
        this.synapseIndex = index;
        this.boxedIndex = new Integer(index);
        this.inputIndex = inputIndex;
    }

    public int getIndex() {
        return this.synapseIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public double getPermanence() {
        return this.permanence;
    }

    public void setPermanence(Connections c, double perm) {
        this.permanence = perm;
        if (this.sourceCell == null) {
            this.pool.updatePool(c, this, perm);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setPresynapticCell(Cell cell) {
        this.sourceCell = cell;
    }

    public Cell getPresynapticCell() {
        return this.sourceCell;
    }

    public boolean destroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean b) {
        this.destroyed = b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("synapse: [ synIdx=").append(this.synapseIndex).append(", inIdx=").append(this.inputIndex).append(", sgmtIdx=").append(this.segment.getIndex());
        if (this.sourceCell != null) {
            sb.append(", srcCellIdx=").append(this.sourceCell.getIndex());
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public int compareTo(Synapse arg0) {
        return this.boxedIndex.compareTo(arg0.boxedIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inputIndex;
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        result = 31 * result + (this.sourceCell == null ? 0 : this.sourceCell.hashCode());
        result = 31 * result + this.synapseIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Synapse other = (Synapse)obj;
        if (this.inputIndex != other.inputIndex) {
            return false;
        }
        if (this.segment == null ? other.segment != null : !this.segment.equals(other.segment)) {
            return false;
        }
        if (this.sourceCell == null ? other.sourceCell != null : !this.sourceCell.equals(other.sourceCell)) {
            return false;
        }
        if (this.synapseIndex != other.synapseIndex) {
            return false;
        }
        return this.permanence == other.permanence;
    }
}

