/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.monitor.mixin;

import com.bethecoder.table.AsciiTableInstance;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.monitor.mixin.BoolsTrace;
import org.numenta.nupic.monitor.mixin.Metric;
import org.numenta.nupic.monitor.mixin.Trace;

public interface MonitorMixinBase {
    public <T> T getMonitor();

    public Connections getConnections();

    public Map<String, Trace<?>> getTraceMap();

    public Map<String, Map<String, ?>> getDataMap();

    public String mmGetName();

    public void mmClearHistory();

    public <T extends Trace<?>> List<T> mmGetDefaultTraces(int var1);

    public List<Metric> mmGetDefaultMetrics(int var1);

    default public String mmPrettyPrintTraces(List<Trace<?>> traces, BoolsTrace breakOnResets) {
        String[] header = new String[traces.size() + 1];
        header[0] = "#";
        for (int i = 0; i < traces.size(); ++i) {
            header[i + 1] = traces.get(i).prettyPrintTitle();
        }
        int len = traces.get((int)0).items.size();
        ArrayList<String[]> table = new ArrayList<String[]>(len);
        for (int i = 0; i < len; ++i) {
            if (breakOnResets != null && ((Boolean)breakOnResets.items.get(i)).booleanValue()) {
                table.add(Collections.nCopies(header.length + 1, "<reset>").toArray(new String[header.length + 1]));
            }
            String[] sa = new String[traces.size() + 1];
            sa[0] = "" + i;
            int x = 1;
            for (Trace<?> t : traces) {
                sa[x++] = t.prettyPrintDatum(t.items.get(i));
            }
            table.add(sa);
        }
        String retVal = AsciiTableInstance.get().getTable(header, (String[][])table.toArray((T[])new String[table.size()][]), 0);
        return retVal;
    }

    default public String mmPrettyPrintMetrics(List<Metric> metrics, int sigFigs) {
        String hashes = "";
        for (int i = 0; i < Math.max(2, sigFigs); ++i) {
            hashes = hashes + "#";
        }
        DecimalFormat df = new DecimalFormat("0." + hashes);
        String[] header = new String[]{"Metric", "mean", "standard deviation", "min", "max", "sum"};
        String[][] data = new String[metrics.size()][header.length];
        int i = 0;
        for (Metric metric : metrics) {
            for (int j = 0; j < header.length; ++j) {
                if (j == 0) {
                    data[i][j] = metric.prettyPrintTitle();
                    continue;
                }
                double[] stats = metric.getStats(sigFigs);
                data[i][j] = (double)((int)stats[j - 1]) == stats[j - 1] ? df.format(stats[j - 1]) + ".0" : df.format(stats[j - 1]);
            }
            ++i;
        }
        String retVal = AsciiTableInstance.get().getTable(header, data, 0);
        return retVal;
    }
}

