/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.joda.time.DateTime;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.algorithms.Classification;
import org.numenta.nupic.algorithms.Classifier;
import org.numenta.nupic.algorithms.SDRClassifier;
import org.numenta.nupic.algorithms.SpatialPooler;
import org.numenta.nupic.algorithms.TemporalMemory;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.encoders.MultiEncoder;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.ComputeCycle;
import org.numenta.nupic.model.Connections;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.model.SDR;
import org.numenta.nupic.network.CheckPointOp;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.ManualInput;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.Persistence;
import org.numenta.nupic.network.PublisherSupplier;
import org.numenta.nupic.network.Region;
import org.numenta.nupic.network.sensor.FileSensor;
import org.numenta.nupic.network.sensor.HTMSensor;
import org.numenta.nupic.network.sensor.ObservableSensor;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;
import org.numenta.nupic.network.sensor.URISensor;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.NamedTuple;
import org.numenta.nupic.util.SparseBinaryMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public class Layer<T>
implements Persistable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(Layer.class);
    protected int numColumns;
    protected Network parentNetwork;
    protected Region parentRegion;
    protected Parameters params;
    protected SensorParams sensorParams;
    protected Connections connections;
    protected HTMSensor<?> sensor;
    protected MultiEncoder encoder;
    protected SpatialPooler spatialPooler;
    protected TemporalMemory temporalMemory;
    private Boolean autoCreateClassifiers;
    private Anomaly anomalyComputer;
    private transient ConcurrentLinkedQueue<Observer<Inference>> subscribers = new ConcurrentLinkedQueue();
    private transient PublishSubject<T> publisher = null;
    private transient Observable<Inference> userObservable;
    private transient Subscription subscription;
    private volatile Inference currentInference;
    FunctionFactory factory;
    private int recordNum = -1;
    private int skip = -1;
    private String name;
    private volatile boolean isClosed;
    private volatile boolean isHalted;
    private volatile boolean isPostSerialized;
    protected volatile boolean isLearn = true;
    private Layer<Inference> next;
    private Layer<Inference> previous;
    private transient List<Observer<Inference>> observers = new ArrayList<Observer<Inference>>();
    private transient CheckPointOperator<?> checkPointOp;
    private transient List<Observer<byte[]>> checkPointOpObservers = new ArrayList<Observer<byte[]>>();
    private List<Object> addedItems = new ArrayList<Object>();
    private boolean hasGenericProcess;
    private List<EncoderTuple> encoderTuples;
    private transient Map<Class<T>, Observable<ManualInput>> observableDispatch = Collections.synchronizedMap(new HashMap());
    private transient Thread LAYER_THREAD;
    static final byte SPATIAL_POOLER = 1;
    static final byte TEMPORAL_MEMORY = 2;
    static final byte CLA_CLASSIFIER = 4;
    static final byte ANOMALY_COMPUTER = 8;
    private byte algo_content_mask = 0;

    public Layer(Network n) {
        this(n, n.getParameters());
    }

    public Layer(Network n, Parameters p) {
        this("[Layer " + System.currentTimeMillis() + "]", n, p);
    }

    public Layer(String name, Network n, Parameters p) {
        this.name = name;
        this.parentNetwork = n;
        this.params = p;
        this.connections = new Connections();
        this.autoCreateClassifiers = (Boolean)p.get(Parameters.KEY.AUTO_CLASSIFY);
        this.factory = new FunctionFactory();
        this.observableDispatch = this.createDispatchMap();
    }

    public Layer<T> preSerialize() {
        this.isPostSerialized = false;
        return this;
    }

    public Layer<T> postDeSerialize() {
        this.recreateSensors();
        FunctionFactory old = this.factory;
        this.factory = new FunctionFactory();
        this.factory.inference = old.inference.postDeSerialize(old.inference);
        this.checkPointOpObservers = new ArrayList<Observer<byte[]>>();
        if (this.sensor != null) {
            this.sensor.setLocalParameters(this.params);
            this.sensor.postDeSerialize();
        } else {
            this.observableDispatch = this.createDispatchMap();
            this.parentNetwork.addDummySubscriber();
        }
        this.isPostSerialized = true;
        this.observers = new ArrayList<Observer<Inference>>();
        return this;
    }

    public void setNetwork(Network network) {
        this.parentNetwork = network;
    }

    public Network getNetwork() {
        return this.parentNetwork;
    }

    public Layer(Parameters params, MultiEncoder e, SpatialPooler sp, TemporalMemory tm, Boolean autoCreateClassifiers, Anomaly a) {
        if (params == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        if (params.get(Parameters.KEY.FIELD_ENCODING_MAP) == null && e != null) {
            throw new IllegalArgumentException("The passed in Parameters must contain a field encoding map specified by org.numenta.nupic.Parameters.KEY.FIELD_ENCODING_MAP");
        }
        this.params = params;
        this.encoder = e;
        this.spatialPooler = sp;
        this.temporalMemory = tm;
        this.autoCreateClassifiers = autoCreateClassifiers;
        this.anomalyComputer = a;
        this.connections = new Connections();
        this.factory = new FunctionFactory();
        this.observableDispatch = this.createDispatchMap();
        this.initializeMask();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Layer successfully created containing: {}{}{}{}{}", new Object[]{this.encoder == null ? "" : "MultiEncoder,", this.spatialPooler == null ? "" : "SpatialPooler,", this.temporalMemory == null ? "" : "TemporalMemory,", autoCreateClassifiers == null ? "" : "Auto creating Classifiers for each input field.", this.anomalyComputer == null ? "" : "Anomaly"});
        }
    }

    public CheckPointOp<byte[]> delegateCheckPointCall() {
        if (this.parentNetwork != null) {
            return this.parentNetwork.getCheckPointOperator();
        }
        return null;
    }

    public void setRegion(Region r) {
        this.parentRegion = r;
    }

    public Region getRegion() {
        return this.parentRegion;
    }

    public Layer<T> close() {
        block18: {
            int columnLength;
            int inputLength;
            int product;
            block19: {
                if (this.isClosed) {
                    LOGGER.warn("Close called on Layer " + this.getName() + " which is already closed.");
                    return this;
                }
                this.params.apply(this.connections);
                if (this.sensor != null) {
                    this.encoder = this.encoder == null ? this.sensor.getEncoder() : this.encoder;
                    this.sensor.initEncoder(this.params);
                    this.connections.setNumInputs(this.encoder.getWidth());
                    if (this.parentNetwork != null && this.parentRegion != null) {
                        this.parentNetwork.setSensorRegion(this.parentRegion);
                        Object supplier = this.sensor.getSensorParams().get("ONSUB");
                        if (supplier != null && supplier instanceof PublisherSupplier) {
                            ((PublisherSupplier)supplier).setNetwork(this.parentNetwork);
                            this.parentNetwork.setPublisher(((PublisherSupplier)supplier).get());
                        }
                    }
                }
                if (this.encoder == null) break block18;
                if (this.encoder.getEncoders(this.encoder) == null || this.encoder.getEncoders(this.encoder).size() < 1) {
                    if (this.params.get(Parameters.KEY.FIELD_ENCODING_MAP) == null || ((Map)this.params.get(Parameters.KEY.FIELD_ENCODING_MAP)).size() < 1) {
                        LOGGER.error("No field encoding map found for specified MultiEncoder");
                        throw new IllegalStateException("No field encoding map found for specified MultiEncoder");
                    }
                    this.encoder.addMultipleEncoders((Map)this.params.get(Parameters.KEY.FIELD_ENCODING_MAP));
                }
                product = 0;
                inputLength = 0;
                columnLength = 0;
                inputLength = ((int[])this.params.get(Parameters.KEY.INPUT_DIMENSIONS)).length;
                if (inputLength != (columnLength = ((int[])this.params.get(Parameters.KEY.COLUMN_DIMENSIONS)).length)) break block19;
                product = ArrayUtils.product((int[])this.params.get(Parameters.KEY.INPUT_DIMENSIONS));
                if (this.encoder.getWidth() == product) break block18;
            }
            LOGGER.warn("The number of Input Dimensions (" + inputLength + ") != number of Column Dimensions (" + columnLength + ") --OR-- Encoder width (" + this.encoder.getWidth() + ") != product of dimensions (" + product + ") -- now attempting to fix it.");
            int[] inferredDims = this.inferInputDimensions(this.encoder.getWidth(), columnLength);
            if (inferredDims != null && inferredDims.length > 0 && this.encoder.getWidth() == ArrayUtils.product(inferredDims)) {
                LOGGER.info("Input dimension fix successful!");
                LOGGER.info("Using calculated input dimensions: " + Arrays.toString(inferredDims));
            }
            this.params.setInputDimensions(inferredDims);
            this.connections.setInputDimensions(inferredDims);
        }
        this.autoCreateClassifiers = this.autoCreateClassifiers != null && this.autoCreateClassifiers | (Boolean)this.params.get(Parameters.KEY.AUTO_CLASSIFY);
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue() && (this.factory.inference.getClassifiers() == null || this.factory.inference.getClassifiers().size() < 1)) {
            this.factory.inference.classifiers(this.makeClassifiers(this.encoder == null ? this.parentNetwork.getEncoder() : this.encoder));
            this.algo_content_mask = (byte)(this.algo_content_mask | 4);
        }
        if (this.parentRegion != null && this.parentRegion.getUpstreamRegion() != null) {
            int[] upstreamDims = new int[]{this.calculateInputWidth()};
            this.params.setInputDimensions(upstreamDims);
            this.connections.setInputDimensions(upstreamDims);
        } else if (this.parentRegion != null && this.parentNetwork != null && this.parentRegion.equals(this.parentNetwork.getSensorRegion()) && this.encoder == null && this.spatialPooler != null) {
            Layer<Inference> curr = this;
            while ((curr = curr.getPrevious()) != null) {
                if (curr.getEncoder() == null) continue;
                int[] dims = (int[])curr.getParameters().get(Parameters.KEY.INPUT_DIMENSIONS);
                this.params.setInputDimensions(dims);
                this.connections.setInputDimensions(dims);
            }
        }
        if (this.spatialPooler != null) {
            int columnLength = 0;
            int inputLength = ((int[])this.params.get(Parameters.KEY.INPUT_DIMENSIONS)).length;
            if (inputLength != (columnLength = ((int[])this.params.get(Parameters.KEY.COLUMN_DIMENSIONS)).length)) {
                LOGGER.error("The number of Input Dimensions (" + inputLength + ") is not same as the number of Column Dimensions (" + columnLength + ") in Parameters! - SpatialPooler not initialized!");
                return this;
            }
            this.spatialPooler.init(this.connections);
        }
        if (this.temporalMemory != null) {
            TemporalMemory.init(this.connections);
        }
        this.numColumns = this.connections.getNumColumns();
        this.isClosed = true;
        LOGGER.debug("Layer " + this.name + " content initialize mask = " + Integer.toBinaryString(this.algo_content_mask));
        return this;
    }

    int calculateInputWidth() {
        if (this.previous == null) {
            if (this.parentRegion.getUpstreamRegion() != null) {
                if ((this.parentRegion.getUpstreamRegion().getHead().algo_content_mask & 2) == 2) {
                    int out = -1;
                    out = this.parentRegion.getUpstreamRegion().getHead().getConnections().getCellsPerColumn() * (this.parentRegion.getUpstreamRegion().getHead().getConnections().getMemory().getMaxIndex() + 1);
                    return out;
                }
                return new SparseBinaryMatrix(this.parentRegion.getUpstreamRegion().getHead().getConnections().getColumnDimensions()).getMaxIndex() + 1;
            }
            if (this.hasTM() && !this.hasSP()) {
                return this.getConnections().getCellsPerColumn() * (this.getConnections().getMemory().getMaxIndex() + 1);
            }
            return this.connections.getNumInputs();
        }
        if ((this.previous.algo_content_mask & 2) == 2) {
            SparseBinaryMatrix matrix = new SparseBinaryMatrix(this.previous.getConnections().getColumnDimensions());
            return this.previous.getConnections().getCellsPerColumn() * (matrix.getMaxIndex() + 1);
        }
        return new SparseBinaryMatrix(this.previous.getConnections().getColumnDimensions()).getMaxIndex() + 1;
    }

    boolean hasTM() {
        return (this.algo_content_mask & 2) == 2;
    }

    boolean hasSP() {
        return (this.algo_content_mask & 1) == 1;
    }

    public int[] inferInputDimensions(int inputWidth, int numDims) {
        BigDecimal dimensions;
        double flatSize = inputWidth;
        double numColDims = numDims;
        int[] retVal = new int[(int)numColDims];
        BigDecimal log = new BigDecimal(Math.log10(flatSize));
        double sliceArrangement = new BigDecimal(Math.pow(10.0, log.divide(dimensions = new BigDecimal(numColDims)).doubleValue()), MathContext.DECIMAL32).doubleValue();
        double remainder = sliceArrangement % (double)((int)sliceArrangement);
        if (remainder > 0.0) {
            int i = 0;
            while ((double)i < numColDims - 1.0) {
                retVal[i] = 1;
                ++i;
            }
            retVal[(int)numColDims - 1] = (int)flatSize;
        } else {
            int i = 0;
            while ((double)i < numColDims) {
                retVal[i] = (int)sliceArrangement;
                ++i;
            }
        }
        return retVal;
    }

    public Observable<Inference> observe() {
        if (this.isHalted) {
            this.clearSubscriberObserverLists();
        }
        if (this.userObservable == null) {
            this.userObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Inference>(){

                public void call(Subscriber<? super Inference> t1) {
                    if (Layer.this.observers == null) {
                        Layer.this.observers = new ArrayList();
                    }
                    Layer.this.observers.add(t1);
                }
            });
        }
        return this.userObservable;
    }

    public Subscription subscribe(Observer<Inference> subscriber) {
        if (this.isHalted) {
            this.clearSubscriberObserverLists();
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        if (this.subscribers == null) {
            this.subscribers = new ConcurrentLinkedQueue();
        }
        this.subscribers.add(subscriber);
        return this.createSubscription(subscriber);
    }

    public Layer<T> using(Connections c) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.connections = c;
        return this;
    }

    public Layer<T> using(Parameters p) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.params = p;
        return this;
    }

    public Layer<T> add(Sensor sensor) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.sensor = (HTMSensor)sensor;
        if (this.parentNetwork != null && this.parentRegion != null) {
            this.parentNetwork.setSensorRegion(this.parentRegion);
            this.parentNetwork.setSensor(this.sensor);
        }
        this.sensorParams = this.sensor.getSensorParams();
        return this;
    }

    public Layer<T> add(MultiEncoder encoder) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.encoder = encoder;
        return this;
    }

    public Layer<T> add(SpatialPooler sp) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(sp);
        this.algo_content_mask = (byte)(this.algo_content_mask | 1);
        this.spatialPooler = sp;
        return this;
    }

    public Layer<T> add(TemporalMemory tm) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(tm);
        this.algo_content_mask = (byte)(this.algo_content_mask | 2);
        this.temporalMemory = tm;
        return this;
    }

    public Layer<T> add(Anomaly anomalyComputer) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        this.addedItems.add(anomalyComputer);
        this.algo_content_mask = (byte)(this.algo_content_mask | 8);
        this.anomalyComputer = anomalyComputer;
        return this;
    }

    public Layer<T> add(Func1<ManualInput, ManualInput> func) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        if (func == null) {
            throw new IllegalArgumentException("Cannot add a null Function");
        }
        this.hasGenericProcess = true;
        this.addedItems.add(func);
        return this;
    }

    public Layer<T> alterParameter(Parameters.KEY key, Object value) {
        if (this.isClosed) {
            throw new IllegalStateException("Layer already \"closed\"");
        }
        int[] inputDims = (int[])this.params.get(Parameters.KEY.INPUT_DIMENSIONS);
        this.params = this.params.copy();
        this.params.set(key, value);
        this.params.set(Parameters.KEY.INPUT_DIMENSIONS, inputDims);
        if (key == Parameters.KEY.AUTO_CLASSIFY) {
            this.autoCreateClassifiers = value == null ? false : (Boolean)value;
            this.algo_content_mask = (byte)(this.algo_content_mask | 4);
        }
        return this;
    }

    public HTMSensor<?> getSensor() {
        return this.sensor;
    }

    public Connections getConnections() {
        return this.connections;
    }

    public void compute(T t) {
        if (!this.isClosed) {
            this.close();
        }
        this.increment();
        if (!this.dispatchCompleted()) {
            this.completeDispatch(t);
        }
        this.publisher.onNext(t);
    }

    public void halt() {
        Object supplier = null;
        if (this.sensor != null && (supplier = this.sensor.getSensorParams().get("ONSUB")) != null && supplier instanceof PublisherSupplier) {
            ((PublisherSupplier)supplier).clearSuppliedInstance();
        }
        if (this.LAYER_THREAD == null) {
            this.publisher.onCompleted();
            if (this.next != null) {
                this.next.halt();
            }
        }
        this.isHalted = true;
    }

    public boolean isHalted() {
        return this.isHalted;
    }

    public void setLearn(boolean isLearn) {
        this.isLearn = isLearn;
    }

    public boolean isLearn() {
        return this.isLearn;
    }

    public void start() {
        if (this.isHalted) {
            this.restart(true);
            return;
        }
        if (!this.isClosed) {
            this.close();
        }
        if (this.sensor == null) {
            throw new IllegalStateException("A sensor must be added when the mode is not Network.Mode.MANUAL");
        }
        this.encoder = this.encoder == null ? this.sensor.getEncoder() : this.encoder;
        try {
            this.completeDispatch(new int[0]);
        }
        catch (Exception e) {
            this.notifyError(e);
        }
        this.startLayerThread();
        LOGGER.debug("Start called on Layer thread {}", (Object)this.LAYER_THREAD);
    }

    public void restart(boolean startAtIndex) {
        this.isHalted = false;
        if (!this.isClosed) {
            this.start();
        } else {
            if (this.sensor == null) {
                throw new IllegalStateException("A sensor must be added when the mode is not Network.Mode.MANUAL");
            }
            if (!this.isPostSerialized) {
                this.recreateSensors();
            }
            if (this.parentNetwork != null) {
                this.parentNetwork.setSensor(this.sensor);
            }
            this.observableDispatch = this.createDispatchMap();
            MultiEncoder multiEncoder = this.encoder = this.encoder == null ? this.sensor.getEncoder() : this.encoder;
            int n = startAtIndex ? (this.sensor.getSensorParams().get("ONSUB") != null ? -1 : this.recordNum) : (this.recordNum = -1);
            this.skip = n;
            try {
                this.completeDispatch(new int[0]);
            }
            catch (Exception e) {
                this.notifyError(e);
            }
            this.startLayerThread();
            LOGGER.debug("Re-Start called on Layer thread {}", (Object)this.LAYER_THREAD);
        }
    }

    public void next(Layer<Inference> l) {
        this.next = l;
    }

    public Layer<Inference> getNext() {
        return this.next;
    }

    public void previous(Layer<Inference> l) {
        this.previous = l;
    }

    public Layer<Inference> getPrevious() {
        return this.previous;
    }

    public boolean hasSensor() {
        return this.sensor != null;
    }

    public Thread getLayerThread() {
        if (this.LAYER_THREAD != null) {
            return this.LAYER_THREAD;
        }
        return Thread.currentThread();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public Set<Cell> getPredictiveCells() {
        return this.currentInference.getPredictiveCells();
    }

    public Set<Cell> getPreviousPredictiveCells() {
        return this.currentInference.getPreviousPredictiveCells();
    }

    public int[] getFeedForwardActiveColumns() {
        return this.currentInference.getFeedForwardActiveColumns();
    }

    public Set<Cell> getActiveCells() {
        return this.currentInference.getActiveCells();
    }

    public int[] getFeedForwardSparseActives() {
        return this.currentInference.getFeedForwardSparseActives();
    }

    public Connections getMemory() {
        return this.connections;
    }

    public int getRecordNum() {
        return this.recordNum;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Layer<T> resetRecordNum() {
        this.recordNum = 0;
        return this;
    }

    public void reset() {
        if (this.temporalMemory == null) {
            LOGGER.debug("Attempt to reset Layer: " + this.getName() + "without TemporalMemory");
        } else {
            this.temporalMemory.reset(this.connections);
        }
    }

    public boolean hasTemporalMemory() {
        return this.temporalMemory != null;
    }

    public Layer<T> increment() {
        if (this.skip > -1) {
            --this.skip;
        } else {
            ++this.recordNum;
        }
        return this;
    }

    public Layer<T> name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Inference getInference() {
        return this.currentInference;
    }

    public MultiEncoder getEncoder() {
        if (this.encoder != null) {
            return this.encoder;
        }
        if (this.hasSensor()) {
            return this.sensor.getEncoder();
        }
        MultiEncoder e = this.parentNetwork.getEncoder();
        if (e != null) {
            return e;
        }
        return null;
    }

    public <V> V[] getAllValues(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        Classification<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getActualValues();
    }

    public double[] getAllPredictions(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        Classification<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getStats(step);
    }

    public <K> K getMostProbableValue(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        Classification<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return (K)c.getMostProbableValue(step);
    }

    public int getMostProbableBucketIndex(String field, int step) {
        if (this.currentInference == null || this.currentInference.getClassifiers() == null) {
            throw new IllegalStateException("Predictions not available. Either classifiers unspecified or inferencing has not yet begun.");
        }
        Classification<Object> c = this.currentInference.getClassification(field);
        if (c == null) {
            LOGGER.debug("No ClassifierResult exists for the specified field: {}", (Object)field);
        }
        return c.getMostProbableBucketIndex(step);
    }

    void notifyComplete() {
        for (Observer<Inference> o : this.subscribers) {
            o.onCompleted();
        }
        for (Observer<Inference> o : this.observers) {
            o.onCompleted();
        }
        this.publisher.onCompleted();
    }

    void notifyError(Exception e) {
        for (Observer<Inference> o : this.subscribers) {
            o.onError((Throwable)e);
        }
        for (Observer<Inference> o : this.observers) {
            o.onError((Throwable)e);
        }
        this.publisher.onError((Throwable)e);
    }

    byte getMask() {
        return this.algo_content_mask;
    }

    private void initializeMask() {
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.spatialPooler == null ? (byte)0 : 1));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.temporalMemory == null ? 0 : 2));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.autoCreateClassifiers == null || this.autoCreateClassifiers == false ? 0 : 4));
        this.algo_content_mask = (byte)(this.algo_content_mask | (this.anomalyComputer == null ? 0 : 8));
    }

    private boolean dispatchCompleted() {
        return this.observableDispatch == null;
    }

    private void completeDispatch(T t) {
        Observable<ManualInput> sequence = this.resolveObservableSequence(t);
        sequence = this.mapEncoderBuckets(sequence);
        sequence = this.fillInSequence(sequence);
        if (this.subscribers == null) {
            this.subscribers = new ConcurrentLinkedQueue();
        }
        this.subscribers.add(this.getDelegateObserver());
        this.subscription = sequence.subscribe(this.getDelegateSubscriber());
        this.observableDispatch.clear();
        this.observableDispatch = null;
        if (this.sensor == null && this.parentNetwork != null && this.parentNetwork.isTail(this)) {
            this.sensor = this.parentNetwork == null ? null : this.parentNetwork.getSensor();
        } else if (this.parentNetwork != null && this.sensor != null) {
            this.parentNetwork.setSensor(this.sensor);
        }
    }

    private Map<Class<T>, Observable<ManualInput>> createDispatchMap() {
        Map<Class<T>, Observable<ManualInput>> observableDispatch = Collections.synchronizedMap(new HashMap());
        this.publisher = PublishSubject.create();
        observableDispatch.put(Map.class, this.factory.createMultiMapFunc(this.publisher));
        observableDispatch.put(ManualInput.class, this.factory.createManualInputFunc(this.publisher));
        observableDispatch.put(String[].class, this.factory.createEncoderFunc(this.publisher));
        observableDispatch.put(int[].class, this.factory.createVectorFunc(this.publisher));
        return observableDispatch;
    }

    private Observable<ManualInput> mapEncoderBuckets(Observable<ManualInput> sequence) {
        if (this.hasSensor()) {
            if (this.getSensor().getMetaInfo().getFieldTypes().stream().anyMatch(ft -> ft == FieldMetaType.SARR || ft == FieldMetaType.DARR || ft == FieldMetaType.COORD || ft == FieldMetaType.GEO)) {
                if (this.autoCreateClassifiers.booleanValue()) {
                    throw new IllegalStateException("Cannot autoclassify with raw array input or  Coordinate based encoders... Remove auto classify setting.");
                }
                return sequence;
            }
            sequence = sequence.map(m -> {
                this.doEncoderBucketMapping((Inference)m, this.getSensor().getInputMap());
                return m;
            });
        }
        return sequence;
    }

    private Observable<ManualInput> resolveObservableSequence(T t) {
        Observable<ManualInput> sequenceStart = null;
        if (this.observableDispatch == null) {
            this.observableDispatch = this.createDispatchMap();
        }
        if (this.observableDispatch != null) {
            if (ManualInput.class.isAssignableFrom(t.getClass())) {
                sequenceStart = this.observableDispatch.get(ManualInput.class);
            } else if (Map.class.isAssignableFrom(t.getClass())) {
                sequenceStart = this.observableDispatch.get(Map.class);
            } else if (t.getClass().isArray()) {
                if (t.getClass().equals(String[].class)) {
                    sequenceStart = this.observableDispatch.get(String[].class);
                } else if (t.getClass().equals(int[].class)) {
                    sequenceStart = this.observableDispatch.get(int[].class);
                }
            }
        }
        if (this.recordNum > 0 && this.skip != -1) {
            sequenceStart = sequenceStart.skip(this.recordNum + 1);
            Integer skipCount = (Integer)this.params.get(Parameters.KEY.SP_PRIMER_DELAY);
            if (skipCount != null) {
                this.params.set(Parameters.KEY.SP_PRIMER_DELAY, Math.max(0, skipCount - this.recordNum));
            }
        }
        sequenceStart = sequenceStart.filter(m -> {
            if (!this.checkPointOpObservers.isEmpty() && this.parentNetwork != null) {
                this.doCheckPoint();
            }
            return true;
        });
        return sequenceStart;
    }

    private void doCheckPoint() {
        byte[] bytes = this.parentNetwork.internalCheckPointOp();
        if (bytes != null) {
            LOGGER.debug("Layer [" + this.getName() + "] checkPointed file: " + Persistence.get().getLastCheckPointFileName());
        } else {
            LOGGER.debug("Layer [" + this.getName() + "] checkPoint   F A I L E D   at: " + new DateTime());
        }
        for (Observer<byte[]> o : this.checkPointOpObservers) {
            o.onNext((Object)bytes);
            o.onCompleted();
        }
        this.checkPointOpObservers.clear();
    }

    private void doEncoderBucketMapping(Inference inference, Map<String, Object> encoderInputMap) {
        if (this.encoderTuples == null) {
            this.encoderTuples = this.encoder.getEncoders(this.encoder);
        }
        int[] encoding = inference.getEncoding();
        for (EncoderTuple t : this.encoderTuples) {
            String name = t.getName();
            Encoder<?> e = t.getEncoder();
            int bucketIdx = -1;
            Object o = encoderInputMap.get(name);
            bucketIdx = DateTime.class.isAssignableFrom(o.getClass()) ? ((DateEncoder)e).getBucketIndices((DateTime)o)[0] : (Number.class.isAssignableFrom(o.getClass()) ? e.getBucketIndices((Double)o)[0] : e.getBucketIndices((String)o)[0]);
            int offset = t.getOffset();
            int[] tempArray = new int[e.getWidth()];
            System.arraycopy(encoding, offset, tempArray, 0, tempArray.length);
            inference.getClassifierInput().put(name, new NamedTuple(new String[]{"name", "inputValue", "bucketIdx", "encoding"}, new Object[]{name, o, bucketIdx, tempArray}));
        }
    }

    private Observable<ManualInput> fillInSequence(Observable<ManualInput> o) {
        if (this.hasGenericProcess) {
            return this.fillInOrderedSequence(o);
        }
        if (this.spatialPooler != null) {
            Integer skipCount = 0;
            skipCount = (Integer)this.params.get(Parameters.KEY.SP_PRIMER_DELAY);
            o = skipCount != null ? o.map(this.factory.createSpatialFunc(this.spatialPooler)).skip(skipCount.intValue()) : o.map(this.factory.createSpatialFunc(this.spatialPooler));
        }
        if (this.temporalMemory != null) {
            o = o.map(this.factory.createTemporalFunc(this.temporalMemory));
        }
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue()) {
            o = o.map(this.factory.createClassifierFunc());
        }
        if (this.anomalyComputer != null) {
            o = o.map(this.factory.createAnomalyFunc(this.anomalyComputer));
        }
        return o;
    }

    private Observable<ManualInput> fillInOrderedSequence(Observable<ManualInput> o) {
        Collections.reverse(this.addedItems);
        for (Object node : this.addedItems) {
            if (node instanceof Func1) {
                o = o.map((Func1)node);
                continue;
            }
            if (node instanceof SpatialPooler) {
                Integer skipCount = 0;
                skipCount = (Integer)this.params.get(Parameters.KEY.SP_PRIMER_DELAY);
                if (skipCount != null) {
                    o = o.map(this.factory.createSpatialFunc(this.spatialPooler)).skip(skipCount.intValue());
                    continue;
                }
                o = o.map(this.factory.createSpatialFunc(this.spatialPooler));
                continue;
            }
            if (!(node instanceof TemporalMemory)) continue;
            o = o.map(this.factory.createTemporalFunc(this.temporalMemory));
        }
        if (this.autoCreateClassifiers != null && this.autoCreateClassifiers.booleanValue()) {
            o = o.map(this.factory.createClassifierFunc());
        }
        if (this.anomalyComputer != null) {
            o = o.map(this.factory.createAnomalyFunc(this.anomalyComputer));
        }
        return o;
    }

    private Subscription createSubscription(final Observer<Inference> sub) {
        return new Subscription(){
            private Observer<Inference> observer;
            {
                this.observer = sub;
            }

            public void unsubscribe() {
                Layer.this.subscribers.remove(this.observer);
                if (Layer.this.subscribers.isEmpty()) {
                    Layer.this.subscription.unsubscribe();
                }
            }

            public boolean isUnsubscribed() {
                return Layer.this.subscribers.contains(this.observer);
            }
        };
    }

    private Observer<Inference> getDelegateSubscriber() {
        return new Observer<Inference>(){

            public void onCompleted() {
                for (Observer o : Layer.this.subscribers) {
                    o.onCompleted();
                }
            }

            public void onError(Throwable e) {
                for (Observer o : Layer.this.subscribers) {
                    o.onError(e);
                }
            }

            public void onNext(Inference i) {
                Layer.this.currentInference = i;
                for (Observer o : Layer.this.subscribers) {
                    o.onNext((Object)i);
                }
            }
        };
    }

    private Observer<Inference> getDelegateObserver() {
        return new Observer<Inference>(){

            public void onCompleted() {
                for (Observer o : Layer.this.observers) {
                    o.onCompleted();
                }
            }

            public void onError(Throwable e) {
                for (Observer o : Layer.this.observers) {
                    o.onError(e);
                    e.printStackTrace();
                }
            }

            public void onNext(Inference i) {
                Layer.this.currentInference = i;
                for (Observer o : Layer.this.observers) {
                    o.onNext((Object)i);
                }
            }
        };
    }

    private void clearSubscriberObserverLists() {
        if (this.observers == null) {
            this.observers = new ArrayList<Observer<Inference>>();
        }
        if (this.subscribers == null) {
            this.subscribers = new ConcurrentLinkedQueue();
        }
        this.subscribers.clear();
        this.userObservable = null;
    }

    NamedTuple makeClassifiers(MultiEncoder encoder) {
        Map inferredFields = (Map)this.params.get(Parameters.KEY.INFERRED_FIELDS);
        if (inferredFields == null || inferredFields.entrySet().size() == 0) {
            throw new IllegalStateException("KEY.AUTO_CLASSIFY has been set to \"true\", but KEY.INFERRED_FIELDS is null or\n\tempty. Must specify desired Classifier for at least one input field in\n\tKEY.INFERRED_FIELDS or set KEY.AUTO_CLASSIFY to \"false\" (which is its default\n\tvalue in Parameters).");
        }
        String[] names = new String[encoder.getEncoders(encoder).size()];
        Classifier[] ca = new Classifier[names.length];
        int i = 0;
        for (EncoderTuple et : encoder.getEncoders(encoder)) {
            names[i] = et.getName();
            Class fieldClassifier = (Class)inferredFields.get(et.getName());
            if (fieldClassifier == null) {
                LOGGER.info("Not classifying \"" + et.getName() + "\" input field");
            } else if (CLAClassifier.class.isAssignableFrom(fieldClassifier)) {
                LOGGER.info("Classifying \"" + et.getName() + "\" input field with CLAClassifier");
                ca[i] = new CLAClassifier();
            } else if (SDRClassifier.class.isAssignableFrom(fieldClassifier)) {
                LOGGER.info("Classifying \"" + et.getName() + "\" input field with SDRClassifier");
                ca[i] = new SDRClassifier();
            } else {
                throw new IllegalStateException("Invalid Classifier class token, \"" + fieldClassifier + "\",\n\tspecified for, \"" + et.getName() + "\", input field.\n\tValid class tokens are CLAClassifier.class and SDRClassifier.class");
            }
            ++i;
        }
        return new NamedTuple(names, (Object[])ca);
    }

    protected int[] spatialInput(int[] input) {
        if (input == null) {
            LOGGER.info("Layer ".concat(this.getName()).concat(" received null input"));
        } else if (input.length < 1) {
            LOGGER.info("Layer ".concat(this.getName()).concat(" received zero length bit vector"));
            return input;
        }
        int[] activeColumns = new int[this.numColumns];
        this.spatialPooler.compute(this.connections, input, activeColumns, this.isLearn || this.sensor != null && this.sensor.getMetaInfo().isLearn());
        return activeColumns;
    }

    protected int[] temporalInput(int[] input, ManualInput mi) {
        ComputeCycle cc = null;
        if (this.sensor != null) {
            if (this.sensor.getMetaInfo().isReset()) {
                this.temporalMemory.reset(this.connections);
            }
            cc = this.temporalMemory.compute(this.connections, input, this.sensor.getMetaInfo().isLearn());
        } else {
            cc = this.temporalMemory.compute(this.connections, input, this.isLearn);
        }
        mi.predictiveCells(cc.predictiveCells());
        mi.activeCells(cc.activeCells);
        mi.computeCycle = cc;
        return SDR.asCellIndices(cc.activeCells);
    }

    protected void startLayerThread() {
        this.LAYER_THREAD = new Thread("Sensor Layer [" + this.getName() + "] Thread"){

            @Override
            public void run() {
                LOGGER.debug("Layer [" + this.getName() + "] started Sensor output stream processing.");
                Layer.this.sensor.getOutputStream().filter(i -> {
                    if (Layer.this.isHalted) {
                        Layer.this.notifyComplete();
                        if (Layer.this.next != null) {
                            Layer.this.next.halt();
                        }
                        return false;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        Layer.this.notifyError(new RuntimeException("Unknown Exception while filtering input"));
                    }
                    return true;
                }).forEach(intArray -> {
                    Layer.this.factory.inference.encoding((int[])intArray);
                    Layer.this.compute(intArray);
                    if (!Layer.this.sensor.hasNext()) {
                        Layer.this.notifyComplete();
                    }
                });
            }
        };
        this.LAYER_THREAD.start();
    }

    CheckPointOp<byte[]> getCheckPointOperator() {
        if (this.checkPointOp == null) {
            this.checkPointOp = new CheckPointOperator(this);
        }
        return this.checkPointOp;
    }

    private void recreateSensors() {
        if (this.sensor != null) {
            Class<Sensor<?>> sensorKlass = this.sensor.getSensorClass();
            if (sensorKlass.toString().indexOf("File") != -1) {
                Object path = this.sensor.getSensorParams().get("PATH");
                this.sensor = (HTMSensor)Sensor.create(FileSensor::create, SensorParams.create(SensorParams.Keys::path, "", path));
            } else if (sensorKlass.toString().indexOf("Observ") != -1) {
                Object supplierOfObservable = this.sensor.getSensorParams().get("ONSUB");
                this.sensor = (HTMSensor)Sensor.create(ObservableSensor::create, SensorParams.create(SensorParams.Keys::obs, "", supplierOfObservable));
            } else if (sensorKlass.toString().indexOf("URI") != -1) {
                Object url = this.sensor.getSensorParams().get("URI");
                this.sensor = (HTMSensor)Sensor.create(URISensor::create, SensorParams.create(SensorParams.Keys::uri, "", url));
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.recordNum;
        result = 31 * result + this.algo_content_mask;
        result = 31 * result + (this.currentInference == null ? 0 : this.currentInference.hashCode());
        result = 31 * result + (this.hasGenericProcess ? 1231 : 1237);
        result = 31 * result + (this.isClosed ? 1231 : 1237);
        result = 31 * result + (this.isHalted ? 1231 : 1237);
        result = 31 * result + (this.isLearn ? 1231 : 1237);
        result = 31 * result + (this.parentRegion == null ? 0 : this.parentRegion.hashCode());
        result = 31 * result + (this.sensorParams == null ? 0 : this.sensorParams.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Layer other = (Layer)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.algo_content_mask != other.algo_content_mask) {
            return false;
        }
        if (this.currentInference == null ? other.currentInference != null : !this.currentInference.equals(other.currentInference)) {
            return false;
        }
        if (this.recordNum != other.recordNum) {
            return false;
        }
        if (this.hasGenericProcess != other.hasGenericProcess) {
            return false;
        }
        if (this.isClosed != other.isClosed) {
            return false;
        }
        if (this.isHalted != other.isHalted) {
            return false;
        }
        if (this.isLearn != other.isLearn) {
            return false;
        }
        if (this.parentRegion == null ? other.parentRegion != null : other.parentRegion == null || !this.parentRegion.getName().equals(other.parentRegion.getName())) {
            return false;
        }
        return !(this.sensorParams == null ? other.sensorParams != null : !this.sensorParams.equals(other.sensorParams));
    }

    class FunctionFactory
    implements Persistable {
        private static final long serialVersionUID = 1L;
        ManualInput inference = new ManualInput();

        FunctionFactory() {
        }

        public Observable<ManualInput> createEncoderFunc(Observable<T> in) {
            return in.ofType(String[].class).compose((Observable.Transformer)new String2Inference());
        }

        public Observable<ManualInput> createMultiMapFunc(Observable<T> in) {
            return in.ofType(Map.class).compose((Observable.Transformer)new Map2Inference());
        }

        public Observable<ManualInput> createVectorFunc(Observable<T> in) {
            return in.ofType(int[].class).compose((Observable.Transformer)new Vector2Inference());
        }

        public Observable<ManualInput> createManualInputFunc(Observable<T> in) {
            return in.ofType(ManualInput.class).compose((Observable.Transformer)new Copy2Inference());
        }

        public Func1<ManualInput, ManualInput> createSpatialFunc(SpatialPooler sp) {
            return new Func1<ManualInput, ManualInput>(){
                int inputWidth = -1;

                public ManualInput call(ManualInput t1) {
                    int[] sdr = t1.getSDR();
                    if (sdr.length > 0 && ArrayUtils.isSparse(sdr)) {
                        if (this.inputWidth == -1) {
                            this.inputWidth = Layer.this.calculateInputWidth();
                        }
                        sdr = ArrayUtils.asDense(sdr, this.inputWidth);
                    }
                    sdr = Layer.this.spatialInput(sdr);
                    return t1.sdr(sdr).feedForwardActiveColumns(sdr);
                }
            };
        }

        public Func1<ManualInput, ManualInput> createTemporalFunc(TemporalMemory tm) {
            return new Func1<ManualInput, ManualInput>(){

                public ManualInput call(ManualInput t1) {
                    int[] sdr = t1.getSDR();
                    if (!ArrayUtils.isSparse(sdr)) {
                        sdr = ArrayUtils.where(sdr, ArrayUtils.WHERE_1);
                        t1.sdr(sdr).feedForwardSparseActives(sdr);
                    }
                    return t1.sdr(Layer.this.temporalInput(sdr, t1));
                }
            };
        }

        public Func1<ManualInput, ManualInput> createClassifierFunc() {
            return new Func1<ManualInput, ManualInput>(){
                private Object bucketIdx;
                private Object actValue;
                Map<String, Object> inputMap = new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object get(Object o) {
                        return o.equals("bucketIdx") ? bucketIdx : actValue;
                    }
                };

                public ManualInput call(ManualInput t1) {
                    Map<String, NamedTuple> ci = t1.getClassifierInput();
                    int recordNum = Layer.this.getRecordNum();
                    for (String key : ci.keySet()) {
                        NamedTuple inputs = ci.get(key);
                        this.bucketIdx = inputs.get("bucketIdx");
                        this.actValue = inputs.get("inputValue");
                        Classifier c = (Classifier)t1.getClassifiers().get(key);
                        if (c == null) continue;
                        Classification<Object> result = c.compute(recordNum, this.inputMap, t1.getSDR(), Layer.this.isLearn, true);
                        t1.recordNum(recordNum).storeClassification((String)inputs.get("name"), result);
                    }
                    return t1;
                }
            };
        }

        public Func1<ManualInput, ManualInput> createAnomalyFunc(Anomaly an) {
            return new Func1<ManualInput, ManualInput>(){
                int isArrayInput = -1;
                int cellsPerColumn;
                {
                    this.cellsPerColumn = Layer.this.connections.getCellsPerColumn();
                }

                public ManualInput call(ManualInput t1) {
                    if (Layer.this.hasSP() && t1.getFeedForwardSparseActives() == null || t1.getPreviousPredictiveCells() == null) {
                        return t1.anomalyScore(1.0);
                    }
                    if (!Layer.this.hasSP() && (this.isArrayInput == 1 || t1.getLayerInput().getClass().equals(int[].class))) {
                        this.isArrayInput = 1;
                        t1.feedForwardSparseActives((int[])t1.getLayerInput());
                    }
                    return t1.anomalyScore(Layer.this.anomalyComputer.compute(t1.getFeedForwardSparseActives(), SDR.cellsAsColumnIndices(t1.getPreviousPredictiveCells(), this.cellsPerColumn), 0.0, 0L));
                }
            };
        }

        class Copy2Inference
        implements Observable.Transformer<ManualInput, ManualInput> {
            Copy2Inference() {
            }

            public Observable<ManualInput> call(Observable<ManualInput> t1) {
                return t1.map((Func1)new Func1<ManualInput, ManualInput>(){
                    NamedTuple swap;
                    boolean swapped;

                    public ManualInput call(ManualInput t1) {
                        if (!this.swapped) {
                            this.swap = FunctionFactory.this.inference.getClassifiers();
                            FunctionFactory.this.inference = t1;
                            FunctionFactory.this.inference.classifiers(this.swap);
                            this.swapped = true;
                        }
                        return FunctionFactory.this.inference.recordNum(Layer.this.getRecordNum()).sdr(t1.getSDR()).recordNum(t1.getRecordNum()).layerInput(t1);
                    }
                });
            }
        }

        class Vector2Inference
        implements Observable.Transformer<int[], ManualInput> {
            Vector2Inference() {
            }

            public Observable<ManualInput> call(Observable<int[]> t1) {
                return t1.map((Func1)new Func1<int[], ManualInput>(){

                    public ManualInput call(int[] t1) {
                        return FunctionFactory.this.inference.recordNum(Layer.this.getRecordNum()).sdr(t1).layerInput(t1);
                    }
                });
            }
        }

        class Map2Inference
        implements Observable.Transformer<Map, ManualInput> {
            Map2Inference() {
            }

            public Observable<ManualInput> call(Observable<Map> t1) {
                return t1.map((Func1)new Func1<Map, ManualInput>(){

                    public ManualInput call(Map t1) {
                        if (Layer.this.encoderTuples == null) {
                            Layer.this.encoderTuples = Layer.this.encoder.getEncoders(Layer.this.encoder);
                        }
                        int[] encoding = Layer.this.encoder.encode(t1);
                        FunctionFactory.this.inference.sdr(encoding).encoding(encoding);
                        Layer.this.doEncoderBucketMapping(FunctionFactory.this.inference, t1);
                        return FunctionFactory.this.inference.recordNum(Layer.this.getRecordNum()).layerInput(t1);
                    }
                });
            }
        }

        class String2Inference
        implements Observable.Transformer<String[], ManualInput> {
            String2Inference() {
            }

            public Observable<ManualInput> call(Observable<String[]> t1) {
                return t1.map((Func1)new Func1<String[], ManualInput>(){

                    public ManualInput call(String[] t1) {
                        int[] sdr = new int[t1.length];
                        for (int i = 0; i < sdr.length; ++i) {
                            sdr[i] = Integer.parseInt(t1[i]);
                        }
                        return FunctionFactory.this.inference.recordNum(Layer.this.getRecordNum()).sdr(sdr).layerInput(sdr);
                    }
                });
            }
        }
    }

    static class CheckPointOperator<T>
    extends Observable<T>
    implements CheckPointOp<T> {
        private CheckPointOperator(final Layer<?> l) {
            this(new Observable.OnSubscribe<T>(){

                public void call(Subscriber<? super T> r) {
                    if (l.LAYER_THREAD != null) {
                        l.checkPointOpObservers.add(r);
                    } else {
                        l.doCheckPoint();
                    }
                }
            });
        }

        protected CheckPointOperator(Observable.OnSubscribe<T> f) {
            super(f);
        }

        @Override
        public Subscription checkPoint(Observer<? super T> t) {
            return super.subscribe(t);
        }
    }
}

