/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import chaschev.lang.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.numenta.nupic.util.Generator;
import org.numenta.nupic.util.GroupBy;
import org.numenta.nupic.util.Tuple;

public class GroupBy2<R extends Comparable<R>>
implements Generator<Tuple> {
    private static final long serialVersionUID = 1L;
    private Pair<List<Object>, Function<Object, R>>[] entries;
    private List<GroupBy<Object, R>> generatorList;
    private R minKeyVal;
    private boolean[] advanceList;
    private Slot<Pair<Object, R>>[] nextList;
    private int numEntries;

    private GroupBy2(Pair<List<Object>, Function<Object, R>>[] entries) {
        this.entries = entries;
    }

    public static <R extends Comparable<R>> GroupBy2<R> of(Pair<List<Object>, Function<Object, R>> ... entries) {
        return new GroupBy2<R>(entries);
    }

    @Override
    public void reset() {
        this.generatorList = new ArrayList<GroupBy<Object, R>>();
        for (int i = 0; i < this.entries.length; ++i) {
            this.generatorList.add(GroupBy.of((List)this.entries[i].getFirst(), (Function)this.entries[i].getSecond()));
        }
        this.numEntries = this.generatorList.size();
        this.advanceList = new boolean[this.numEntries];
        Arrays.fill(this.advanceList, true);
        this.nextList = new Slot[this.numEntries];
        Arrays.fill(this.nextList, Slot.NONE);
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.generatorList == null) {
            this.reset();
        }
        this.advanceSequences();
        return this.nextMinKey();
    }

    @Override
    public Tuple next() {
        Object[] objs = IntStream.range(0, this.numEntries + 1).mapToObj(i -> i == 0 ? this.minKeyVal : new ArrayList()).toArray();
        Tuple retVal = new Tuple(objs);
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            if (this.isEligibleList(i2, this.minKeyVal)) {
                ((List)retVal.get(i2 + 1)).add(this.nextList[i2].get().getFirst());
                this.drainKey(retVal, i2, this.minKeyVal);
                this.advanceList[i2] = true;
                continue;
            }
            this.advanceList[i2] = false;
            ((List)retVal.get(i2 + 1)).add(Slot.empty());
        }
        return retVal;
    }

    private void advanceSequences() {
        for (int i = 0; i < this.numEntries; ++i) {
            if (!this.advanceList[i]) continue;
            this.nextList[i] = this.generatorList.get(i).hasNext() ? Slot.of(this.generatorList.get(i).next()) : Slot.empty();
        }
    }

    private boolean nextMinKey() {
        return Arrays.stream(this.nextList).filter(opt -> opt.isPresent()).map(opt -> (Comparable)((Pair)opt.get()).getSecond()).min((k, k2) -> k.compareTo(k2)).map(k -> {
            this.minKeyVal = k;
            return k;
        }).isPresent();
    }

    private boolean isEligibleList(int listIdx, Object targetKey) {
        return this.nextList[listIdx].isPresent() && ((Comparable)this.nextList[listIdx].get().getSecond()).equals(targetKey);
    }

    private void drainKey(Tuple retVal, int listIdx, R targetVal) {
        while (this.generatorList.get(listIdx).hasNext()) {
            if (((Comparable)this.generatorList.get(listIdx).peek().getSecond()).equals(targetVal)) {
                this.nextList[listIdx] = Slot.of(this.generatorList.get(listIdx).next());
                ((List)retVal.get(listIdx + 1)).add(this.nextList[listIdx].get().getFirst());
                continue;
            }
            this.nextList[listIdx] = Slot.empty();
            break;
        }
    }

    public static final class Slot<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Slot<?> NONE = new Slot();
        private final T value;

        private Slot() {
            this.value = null;
        }

        private Slot(T value) {
            this.value = Objects.requireNonNull(value);
        }

        public static <T> Slot<T> of(T value) {
            return new Slot<T>(value);
        }

        public static <T> Slot<T> ofNullable(T value) {
            return value == null ? NONE : Slot.of(value);
        }

        public T get() {
            if (this.value == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.value;
        }

        public static <T> Slot<T> empty() {
            Slot<?> t = NONE;
            return t;
        }

        public boolean isPresent() {
            return this.value != null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            Slot other = (Slot)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return this.value != null ? String.format("Slot[%s]", this.value) : "NONE";
        }
    }
}

