/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.model.Persistable;
import org.numenta.nupic.util.AbstractSparseBinaryMatrix;
import org.numenta.nupic.util.ArrayUtils;

public class LowMemorySparseBinaryMatrix
extends AbstractSparseBinaryMatrix
implements Persistable {
    private static final long serialVersionUID = 1L;
    private TIntSet sparseSet = new TIntHashSet();

    public LowMemorySparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public LowMemorySparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    @Override
    public Object getSlice(int ... coordinates) {
        int[] dimensions = this.getDimensions();
        if (coordinates.length >= dimensions.length) {
            this.sliceError(coordinates);
        }
        int sliceDimensionsLength = dimensions.length - coordinates.length;
        int[] sliceDimensions = (int[])Array.newInstance(Integer.TYPE, sliceDimensionsLength);
        for (int i = coordinates.length; i < dimensions.length; ++i) {
            sliceDimensions[i - coordinates.length] = dimensions[i];
        }
        int[] elementCoordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
        Object slice = Array.newInstance(Integer.TYPE, sliceDimensions);
        if (coordinates.length + 1 == dimensions.length) {
            for (int i = 0; i < dimensions[coordinates.length]; ++i) {
                elementCoordinates[coordinates.length] = i;
                Array.set(slice, i, this.get(elementCoordinates));
            }
        } else {
            for (int i = 0; i < dimensions[sliceDimensionsLength]; ++i) {
                elementCoordinates[coordinates.length] = i;
                Array.set(slice, i, this.getSlice(elementCoordinates));
            }
        }
        return slice;
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        if (this.dimensions.length > 1) {
            for (int value : this.getSparseIndices()) {
                int[] coordinates = this.computeCoordinates(value);
                if (inputVector[coordinates[1]] == 0) continue;
                int n = coordinates[0];
                results[n] = results[n] + 1;
            }
        } else {
            int i;
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[0] = results[0] + inputVector[i] * this.get(i);
            }
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[i] = results[0];
            }
        }
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results, double stimulusThreshold) {
        if (this.dimensions.length > 1) {
            int[] values = this.getSparseIndices();
            for (int i = 0; i < values.length; ++i) {
                int[] coordinates = this.computeCoordinates(values[i]);
                if (inputVector[coordinates[1]] != 0) {
                    int n = coordinates[0];
                    results[n] = results[n] + 1;
                }
                if (i != values.length - 1 || !((double)results[coordinates[0]] < stimulusThreshold)) continue;
                results[coordinates[0]] = 0;
            }
        } else {
            int i;
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[0] = results[0] + inputVector[i] * this.get(i);
            }
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[i] = results[0];
                if (i != this.dimensions[0] - 1 || !((double)results[i] < stimulusThreshold)) continue;
                results[i] = 0;
            }
        }
    }

    @Override
    public LowMemorySparseBinaryMatrix set(int value, int ... coordinates) {
        int index = this.computeIndex(coordinates);
        if (value == 1) {
            this.sparseSet.add(index);
        } else {
            this.sparseSet.remove(index);
        }
        this.updateTrueCounts(coordinates);
        return this;
    }

    @Override
    public LowMemorySparseBinaryMatrix setForTest(int index, int value) {
        if (value == 1) {
            this.sparseSet.add(index);
        } else {
            this.sparseSet.remove(index);
        }
        return this;
    }

    private void updateTrueCounts(int ... coordinates) {
        Object slice = this.getSlice(coordinates[0]);
        int sum = ArrayUtils.aggregateArray(slice);
        this.setTrueCount(coordinates[0], sum);
    }

    @Override
    public LowMemorySparseBinaryMatrix set(int index, Object value) {
        super.set(index, (int)((Integer)value));
        return this;
    }

    @Override
    public Integer get(int index) {
        return this.sparseSet.contains(index) ? 1 : 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sparseSet == null ? 0 : this.sparseSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LowMemorySparseBinaryMatrix other = (LowMemorySparseBinaryMatrix)obj;
        return !(this.sparseSet == null ? other.sparseSet != null : !this.sparseSet.equals((Object)other.sparseSet));
    }
}

