/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Coordinator;
import org.numenta.nupic.util.IntGenerator;

public class Topology
extends Coordinator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntGenerator[] igs;
    private int[] centerPosition;

    public Topology(int ... shape) {
        super(shape, false);
    }

    public int[] coordinatesFromIndex(int index) {
        return this.computeCoordinates(index);
    }

    public int indexFromCoordinates(int ... coordinates) {
        return this.computeIndex(coordinates);
    }

    public int[] neighborhood(int centerIndex, int radius) {
        this.centerPosition = this.coordinatesFromIndex(centerIndex);
        this.igs = (IntGenerator[])IntStream.range(0, this.dimensions.length).mapToObj(i -> IntGenerator.of(Math.max(0, this.centerPosition[i] - radius), Math.min(this.dimensions[i] - 1, this.centerPosition[i] + radius) + 1)).toArray(IntGenerator[]::new);
        ArrayList<TIntArrayList> result = new ArrayList<TIntArrayList>();
        result.add(new TIntArrayList());
        ArrayList<TIntArrayList> interim = new ArrayList<TIntArrayList>();
        for (IntGenerator pool : this.igs) {
            int size = result.size();
            interim.clear();
            interim.addAll(result);
            result.clear();
            for (int x = 0; x < size; ++x) {
                TIntList lx = (TIntList)interim.get(x);
                pool.reset();
                for (int y = 0; y < pool.size(); ++y) {
                    int py = pool.next();
                    TIntArrayList tl2 = new TIntArrayList();
                    tl2.addAll((TIntCollection)lx);
                    tl2.add(py);
                    result.add(tl2);
                }
            }
        }
        return result.stream().mapToInt(tl -> this.indexFromCoordinates(tl.toArray())).toArray();
    }

    public int[] wrappingNeighborhood(int centerIndex, int radius) {
        int[] cp = this.coordinatesFromIndex(centerIndex);
        IntGenerator[] igs = (IntGenerator[])IntStream.range(0, this.dimensions.length).mapToObj(i -> new IntGenerator(cp[i] - radius, Math.min(cp[i] - radius + this.dimensions[i] - 1, cp[i] + radius) + 1)).toArray(IntGenerator[]::new);
        ArrayList<TIntArrayList> result = new ArrayList<TIntArrayList>();
        result.add(new TIntArrayList());
        ArrayList<TIntArrayList> interim = new ArrayList<TIntArrayList>();
        for (int i2 = 0; i2 < igs.length; ++i2) {
            IntGenerator pool = igs[i2];
            int size = result.size();
            interim.clear();
            interim.addAll(result);
            result.clear();
            for (int x = 0; x < size; ++x) {
                TIntList lx = (TIntList)interim.get(x);
                pool.reset();
                for (int y = 0; y < pool.size(); ++y) {
                    int py = ArrayUtils.modulo(pool.next(), this.dimensions[i2]);
                    TIntArrayList tl2 = new TIntArrayList();
                    tl2.addAll((TIntCollection)lx);
                    tl2.add(py);
                    result.add(tl2);
                }
            }
        }
        return result.stream().mapToInt(tl -> this.indexFromCoordinates(tl.toArray())).toArray();
    }
}

