/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Condition;

public class UniversalRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final MathContext MATH_CONTEXT = new MathContext(9);
    long seed;
    static final String BadBound = "bound must be positive";
    BigInteger bigSeed;

    public UniversalRandom(long seed) {
        this.seed = seed;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    private int[] sampleWithPrintout(TIntArrayList choices, int[] selectedIndices, List<Integer> collectedRandoms) {
        TIntArrayList choiceSupply = new TIntArrayList((TIntCollection)choices);
        int upperBound = choices.size();
        for (int i = 0; i < selectedIndices.length; ++i) {
            int randomIdx = this.nextInt(upperBound);
            collectedRandoms.add(randomIdx);
            selectedIndices[i] = choiceSupply.removeAt(randomIdx);
            --upperBound;
        }
        Arrays.sort(selectedIndices);
        return selectedIndices;
    }

    public int[] sample(TIntArrayList choices, int[] selectedIndices) {
        TIntArrayList choiceSupply = new TIntArrayList((TIntCollection)choices);
        int upperBound = choices.size();
        for (int i = 0; i < selectedIndices.length; ++i) {
            int randomIdx = this.nextInt(upperBound);
            selectedIndices[i] = choiceSupply.removeAt(randomIdx);
            --upperBound;
        }
        Arrays.sort(selectedIndices);
        return selectedIndices;
    }

    public int[] shuffle(int[] array) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = this.nextInt(i + 1);
            if (index == i) continue;
            int n = index;
            array[n] = array[n] ^ array[i];
            int n2 = i;
            array[n2] = array[n2] ^ array[index];
            int n3 = index;
            array[n3] = array[n3] ^ array[i];
        }
        return array;
    }

    public double[][] rand(int rows, int cols) {
        double[][] retval = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                retval[i][j] = this.nextDouble();
            }
        }
        return retval;
    }

    public int[][] binDistrib(int rows, int cols, final double sparsity) {
        double[][] rand = this.rand(rows, cols);
        for (int i = 0; i < rand.length; ++i) {
            int target;
            TIntArrayList sub = new TIntArrayList(ArrayUtils.where(rand[i], new Condition.Adapter<Double>(){

                @Override
                public boolean eval(double d) {
                    return d >= sparsity;
                }
            }));
            int sublen = sub.size();
            if (sublen < (target = (int)(sparsity * (double)cols))) {
                int[] full = IntStream.range(0, cols).toArray();
                TIntHashSet subSet = new TIntHashSet((TIntCollection)sub);
                TIntArrayList toFill = new TIntArrayList(Arrays.stream(full).filter(d -> !subSet.contains(d)).toArray());
                int cnt = toFill.size();
                int x = 0;
                while (x < target - sublen) {
                    int ind = this.nextInt(cnt);
                    int item = toFill.removeAt(ind);
                    rand[i][item] = sparsity;
                    ++x;
                    --cnt;
                }
                continue;
            }
            if (sublen <= target) continue;
            int cnt = sublen;
            int x = 0;
            while (x < sublen - target) {
                int ind = this.nextInt(cnt);
                int item = sub.removeAt(ind);
                rand[i][item] = 0.0;
                ++x;
                --cnt;
            }
        }
        int[][] retval = (int[][])Arrays.stream(rand).map(da -> Arrays.stream(da).mapToInt(d -> d >= sparsity ? 1 : 0).toArray()).toArray(x$0 -> new int[x$0][]);
        return retval;
    }

    @Override
    public double nextDouble() {
        int nd = this.nextInt(10000);
        double retVal = new BigDecimal((double)nd * 1.0E-4, MATH_CONTEXT).doubleValue();
        return retVal;
    }

    @Override
    public int nextInt() {
        int retVal = this.nextInt(Integer.MAX_VALUE);
        return retVal;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = this.next(31);
        int m = bound - 1;
        r = (bound & m) == 0 ? (int)((long)bound * (long)r >> 31) : (r %= bound);
        return r;
    }

    @Override
    protected int next(int nbits) {
        long x = this.seed;
        x ^= x << 21 & 0xFFFFFFFFFFFFFFFFL;
        x ^= x >>> 35;
        x ^= x << 4;
        this.seed = x;
        return (int)(x &= (1L << nbits) - 1L);
    }

    protected int nextX(int nbits) {
        long x = this.seed;
        BigInteger bigX = this.bigSeed == null ? BigInteger.valueOf(this.seed) : this.bigSeed;
        bigX = bigX.shiftLeft(21).xor(bigX).and(new BigInteger("ffffffffffffffff", 16));
        bigX = bigX.shiftRight(35).xor(bigX).and(new BigInteger("ffffffffffffffff", 16));
        this.bigSeed = bigX = bigX.shiftLeft(4).xor(bigX).and(new BigInteger("ffffffffffffffff", 16));
        bigX = bigX.and(BigInteger.valueOf(1L).shiftLeft(nbits).subtract(BigInteger.valueOf(1L)));
        x = bigX.intValue();
        return (int)x;
    }

    public static void main(String[] args) {
        int i;
        UniversalRandom random = new UniversalRandom(42L);
        long s = 2858730232218250L;
        long e = s >>> 35;
        System.out.println("e = " + e);
        int x = random.nextInt(50);
        System.out.println("x = " + x);
        x = random.nextInt(50);
        System.out.println("x = " + x);
        x = random.nextInt(50);
        System.out.println("x = " + x);
        x = random.nextInt(50);
        System.out.println("x = " + x);
        x = random.nextInt(50);
        System.out.println("x = " + x);
        for (i = 0; i < 10; ++i) {
            int o = random.nextInt(50);
            System.out.println("x = " + o);
        }
        random = new UniversalRandom(42L);
        for (i = 0; i < 10; ++i) {
            double o = random.nextDouble();
            System.out.println("d = " + o);
        }
        random = new UniversalRandom(42L);
        TIntArrayList choices = new TIntArrayList(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        int sampleSize = 6;
        int[] selectedIndices = new int[sampleSize];
        ArrayList<Integer> collectedRandoms = new ArrayList<Integer>();
        int[] expectedSample = new int[]{1, 2, 3, 7, 8, 9};
        List expectedRandoms = Arrays.stream(new int[]{0, 0, 0, 5, 3, 3}).boxed().collect(Collectors.toList());
        random.sampleWithPrintout(choices, selectedIndices, collectedRandoms);
        System.out.println("samples are equal ? " + Arrays.equals(expectedSample, selectedIndices));
        System.out.println("used randoms are equal ? " + collectedRandoms.equals(expectedRandoms));
        random = new UniversalRandom(42L);
        int[] coll = ArrayUtils.range(0, 10);
        int[] before = Arrays.copyOf(coll, coll.length);
        random.shuffle(coll);
        System.out.println("collection before: " + Arrays.toString(before));
        System.out.println("collection shuffled: " + Arrays.toString(coll));
        int[] expected = new int[]{5, 1, 8, 6, 2, 4, 7, 3, 9, 0};
        System.out.println(Arrays.equals(expected, coll));
        System.out.println(!Arrays.equals(expected, before));
    }
}

