/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import java.util.LinkedHashSet;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;

public class ComputeCycle {
    public Set<Cell> activeCells = new LinkedHashSet<Cell>();
    public Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    public Set<Cell> predictiveCells = new LinkedHashSet<Cell>();
    public Set<Cell> predictedInactiveCells = new LinkedHashSet<Cell>();
    public Set<Cell> matchingCells = new LinkedHashSet<Cell>();
    public Set<Column> successfullyPredictedColumns = new LinkedHashSet<Column>();
    public Set<DistalDendrite> activeSegments = new LinkedHashSet<DistalDendrite>();
    public Set<DistalDendrite> learningSegments = new LinkedHashSet<DistalDendrite>();
    public Set<DistalDendrite> matchingSegments = new LinkedHashSet<DistalDendrite>();

    public ComputeCycle() {
    }

    public ComputeCycle(Connections c) {
        this.activeCells = new LinkedHashSet<Cell>(c.getActiveCells());
        this.winnerCells = new LinkedHashSet<Cell>(c.getWinnerCells());
        this.predictiveCells = new LinkedHashSet<Cell>(c.getPredictiveCells());
        this.successfullyPredictedColumns = new LinkedHashSet<Column>(c.getSuccessfullyPredictedColumns());
        this.activeSegments = new LinkedHashSet<DistalDendrite>(c.getActiveSegments());
        this.learningSegments = new LinkedHashSet<DistalDendrite>(c.getLearningSegments());
    }

    public Set<Cell> activeCells() {
        return this.activeCells;
    }

    public Set<Cell> winnerCells() {
        return this.winnerCells;
    }

    public Set<Cell> predictiveCells() {
        return this.predictiveCells;
    }

    public Set<Column> successfullyPredictedColumns() {
        return this.successfullyPredictedColumns;
    }

    public Set<DistalDendrite> learningSegments() {
        return this.learningSegments;
    }

    public Set<DistalDendrite> activeSegments() {
        return this.activeSegments;
    }

    public Set<Cell> predictedInactiveCells() {
        return this.predictedInactiveCells;
    }

    public Set<DistalDendrite> matchingSegments() {
        return this.matchingSegments;
    }

    public Set<Cell> matchingCells() {
        return this.matchingCells;
    }
}

