/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.numenta.nupic.model.Cell;

public class SDR {
    public static int[] asColumnIndices(int[] cells, int cellsPerColumn) {
        IntStream op = Arrays.stream(cells);
        return op.map(cell -> cell / cellsPerColumn).distinct().toArray();
    }

    public static int[] asColumnIndices(List<Integer> cells, int cellsPerColumn) {
        IntStream op = cells.stream().mapToInt(c -> c);
        return op.map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] cellsToColumns(List<Cell> cells, int cellsPerColumn) {
        IntStream op = cells.stream().mapToInt(c -> c.getIndex());
        return op.map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] cellsAsColumnIndices(Set<Cell> cells, int cellsPerColumn) {
        return cells.stream().mapToInt(c -> c.getIndex()).sorted().map(cellIdx -> cellIdx / cellsPerColumn).distinct().toArray();
    }

    public static int[] asCellIndices(Collection<Cell> cells) {
        return cells.stream().mapToInt(cell -> cell.getIndex()).sorted().toArray();
    }
}

