/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.numenta.nupic.algorithms.BitHistory;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.util.Deque;
import org.numenta.nupic.util.Tuple;

public class CLAClassifierDeserializer
extends JsonDeserializer<CLAClassifier> {
    public CLAClassifier deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String[] bithists;
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        CLAClassifier retVal = new CLAClassifier();
        retVal.alpha = node.get("alpha").asDouble();
        retVal.actValueAlpha = node.get("actValueAlpha").asDouble();
        retVal.learnIteration = node.get("learnIteration").asInt();
        retVal.recordNumMinusLearnIteration = node.get("recordNumMinusLearnIteration").asInt();
        retVal.maxBucketIdx = node.get("maxBucketIdx").asInt();
        String[] steps = node.get("steps").asText().split(",");
        TIntArrayList t = new TIntArrayList();
        for (String step : steps) {
            t.add(Integer.parseInt(step));
        }
        retVal.steps = t;
        String[] tupleStrs = node.get("patternNZHistory").asText().split(";");
        Deque<Tuple> patterns = new Deque<Tuple>(tupleStrs.length);
        for (String tupleStr : tupleStrs) {
            String[] tupleParts = tupleStr.split("-");
            int iteration = Integer.parseInt(tupleParts[0]);
            String pattern = tupleParts[1].substring(1, tupleParts[1].indexOf("]")).trim();
            String[] indexes = pattern.split(",");
            int[] indices = new int[indexes.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = Integer.parseInt(indexes[i].trim());
            }
            Tuple tup = new Tuple(iteration, indices);
            patterns.append(tup);
        }
        retVal.patternNZHistory = patterns;
        HashMap<Tuple, BitHistory> bitHistoryMap = new HashMap<Tuple, BitHistory>();
        for (String bh : bithists = node.get("activeBitHistory").asText().split(";")) {
            String[] parts = bh.split("-");
            String[] left = parts[0].split(",");
            Tuple iteration = new Tuple(Integer.parseInt(left[0].trim()), Integer.parseInt(left[1].trim()));
            BitHistory bitHistory = new BitHistory();
            String[] right = parts[1].split("=");
            bitHistory.id = right[0].trim();
            TDoubleArrayList dubs = new TDoubleArrayList();
            String[] stats = right[1].substring(1, right[1].indexOf("}")).trim().split(",");
            for (int i = 0; i < stats.length; ++i) {
                dubs.add(Double.parseDouble(stats[i].trim()));
            }
            bitHistory.stats = dubs;
            bitHistory.lastTotalUpdate = Integer.parseInt(right[2].trim());
            bitHistoryMap.put(iteration, bitHistory);
        }
        retVal.activeBitHistory = bitHistoryMap;
        ArrayNode jn = (ArrayNode)node.get("actualValues");
        ArrayList l = new ArrayList();
        for (int i = 0; i < jn.size(); ++i) {
            JsonNode n = jn.get(i);
            try {
                double d = Double.parseDouble(n.asText().trim());
                l.add(d);
                continue;
            }
            catch (Exception e) {
                l.add(n.asText().trim());
            }
        }
        retVal.actualValues = l;
        for (Tuple tuple : bitHistoryMap.keySet()) {
            ((BitHistory)bitHistoryMap.get((Object)tuple)).classifier = retVal;
        }
        return retVal;
    }
}

