/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderResult;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveScalarEncoder
extends ScalarEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveScalarEncoder.class);
    public int recordNum = 0;
    public boolean learningEnabled = true;
    public Double[] slidingWindow = new Double[0];
    public int windowSize = 300;
    public Double bucketValues;

    @Override
    public void init() {
        this.setPeriodic(false);
        super.init();
    }

    @Override
    public void initEncoder(int w, double minVal, double maxVal, int n, double radius, double resolution) {
        this.setPeriodic(false);
        this.encLearningEnabled = true;
        if (this.periodic) {
            throw new IllegalStateException("Adaptive scalar encoder does not encode periodic inputs");
        }
        assert (n != 0);
        super.initEncoder(w, minVal, maxVal, n, radius, resolution);
    }

    public static Builder adaptiveBuilder() {
        return new Builder();
    }

    @Override
    public List<EncoderResult> topDownCompute(int[] encoded) {
        if (this.getMinVal() == 0.0 || this.getMaxVal() == 0.0) {
            ArrayList<EncoderResult> res = new ArrayList<EncoderResult>();
            int[] enArray = new int[this.getN()];
            Arrays.fill(enArray, 0);
            EncoderResult ecResult = new EncoderResult((Object)0, 0, enArray);
            res.add(ecResult);
            return res;
        }
        return super.topDownCompute(encoded);
    }

    @Override
    public void encodeIntoArray(Double input, int[] output) {
        ++this.recordNum;
        boolean learn = false;
        if (!this.encLearningEnabled) {
            learn = true;
        }
        if (input == Double.NaN) {
            Arrays.fill(output, 0);
        } else if (!Double.isNaN(input)) {
            this.setMinAndMax(input, learn);
        }
        super.encodeIntoArray(input, output);
    }

    private void setMinAndMax(Double input, boolean learn) {
        if (this.slidingWindow.length >= this.windowSize) {
            this.slidingWindow = this.deleteItem(this.slidingWindow, 0);
        }
        this.slidingWindow = this.appendItem(this.slidingWindow, input);
        if (this.minVal == this.maxVal) {
            this.minVal = input;
            this.maxVal = input + 1.0;
            this.setEncoderParams();
        } else {
            Object[] sorted = Arrays.copyOf(this.slidingWindow, this.slidingWindow.length);
            Arrays.sort(sorted);
            double minOverWindow = (Double)sorted[0];
            double maxOverWindow = (Double)sorted[sorted.length - 1];
            if (minOverWindow < this.minVal) {
                LOGGER.trace("Input {}={} smaller than minVal {}. Adjusting minVal to {}", new Object[]{this.name, input, this.minVal, minOverWindow});
                this.minVal = minOverWindow;
                this.setEncoderParams();
            }
            if (maxOverWindow > this.maxVal) {
                LOGGER.trace("Input {}={} greater than maxVal {}. Adjusting maxVal to {}", new Object[]{this.name, input, this.minVal, minOverWindow});
                this.maxVal = maxOverWindow;
                this.setEncoderParams();
            }
        }
    }

    private void setEncoderParams() {
        this.rangeInternal = this.maxVal - this.minVal;
        this.resolution = this.rangeInternal / (double)(this.n - this.w);
        this.radius = (double)this.w * this.resolution;
        this.range = this.rangeInternal + this.resolution;
        this.nInternal = this.n - 2 * this.padding;
        this.bucketValues = null;
    }

    private Double[] appendItem(Double[] a, Double input) {
        a = Arrays.copyOf(a, a.length + 1);
        a[a.length - 1] = input;
        return a;
    }

    private Double[] deleteItem(Double[] a, int i) {
        a = Arrays.copyOfRange(a, 1, a.length - 1);
        return a;
    }

    @Override
    public int[] getBucketIndices(String inputString) {
        double input = Double.parseDouble(inputString);
        return this.calculateBucketIndices(input);
    }

    @Override
    public int[] getBucketIndices(double input) {
        return this.calculateBucketIndices(input);
    }

    private int[] calculateBucketIndices(double input) {
        ++this.recordNum;
        boolean learn = false;
        if (!this.encLearningEnabled) {
            learn = true;
        }
        if (Double.isNaN(input) && Double.valueOf(input) instanceof Double) {
            input = Double.NaN;
        }
        if (input == Double.NaN) {
            return new int[this.n];
        }
        this.setMinAndMax(input, learn);
        return super.getBucketIndices(input);
    }

    @Override
    public List<EncoderResult> getBucketInfo(int[] buckets) {
        if (this.minVal == 0.0 || this.maxVal == 0.0) {
            int[] initialBuckets = new int[this.n];
            Arrays.fill(initialBuckets, 0);
            ArrayList<EncoderResult> encoderResultList = new ArrayList<EncoderResult>();
            EncoderResult encoderResult = new EncoderResult((Object)0, 0, initialBuckets);
            encoderResultList.add(encoderResult);
            return encoderResultList;
        }
        return super.getBucketInfo(buckets);
    }

    public static class Builder
    extends Encoder.Builder<Builder, AdaptiveScalarEncoder> {
        private Builder() {
        }

        @Override
        public AdaptiveScalarEncoder build() {
            this.encoder = new AdaptiveScalarEncoder();
            super.build();
            ((AdaptiveScalarEncoder)this.encoder).init();
            return (AdaptiveScalarEncoder)this.encoder;
        }
    }
}

