/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.util.Tuple;

public class DateEncoder
extends Encoder<DateTime> {
    protected int width;
    protected Tuple season;
    protected ScalarEncoder seasonEncoder;
    protected Tuple dayOfWeek;
    protected ScalarEncoder dayOfWeekEncoder;
    protected Tuple weekend;
    protected ScalarEncoder weekendEncoder;
    protected Tuple customDays;
    protected ScalarEncoder customDaysEncoder;
    protected Tuple holiday;
    protected ScalarEncoder holidayEncoder;
    protected Tuple timeOfDay;
    protected ScalarEncoder timeOfDayEncoder;
    protected List<Integer> customDaysList = new ArrayList<Integer>();
    protected List<Tuple> holidaysList = Arrays.asList(new Tuple(12, 25));
    public static DateTimeFormatter FULL_DATE_TIME_ZONE = DateTimeFormat.forPattern((String)"YYYY/MM/dd HH:mm:ss.SSSz");
    public static DateTimeFormatter FULL_DATE_TIME = DateTimeFormat.forPattern((String)"YYYY/MM/dd HH:mm:ss.SSS");
    public static DateTimeFormatter RELAXED_DATE_TIME = DateTimeFormat.forPattern((String)"YYYY/MM/dd HH:mm:ss");
    public static DateTimeFormatter LOOSE_DATE_TIME = DateTimeFormat.forPattern((String)"MM/dd/YY HH:mm");
    public static DateTimeFormatter FULL_DATE = DateTimeFormat.forPattern((String)"YYYY/MM/dd");
    public static DateTimeFormatter FULL_TIME_ZONE = DateTimeFormat.forPattern((String)"HH:mm:ss.SSSz");
    public static DateTimeFormatter FULL_TIME_MILLIS = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
    public static DateTimeFormatter FULL_TIME_SECS = DateTimeFormat.forPattern((String)"HH:mm:ss");
    public static DateTimeFormatter FULL_TIME_MINS = DateTimeFormat.forPattern((String)"HH:mm");
    protected DateTimeFormatter customFormatter;

    DateEncoder() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void init() {
        this.width = 0;
        this.setForced(true);
        if (this.isValidEncoderPropertyTuple(this.season)) {
            this.seasonEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.season.get(0)).radius((Double)this.season.get(1))).minVal(0.0)).maxVal(366.0)).periodic(true)).name("season")).forced(this.isForced())).build();
            this.addChildEncoder(this.seasonEncoder);
        }
        if (this.isValidEncoderPropertyTuple(this.dayOfWeek)) {
            this.dayOfWeekEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.dayOfWeek.get(0)).radius((Double)this.dayOfWeek.get(1))).minVal(0.0)).maxVal(7.0)).periodic(true)).name("day of week")).forced(this.isForced())).build();
            this.addChildEncoder(this.dayOfWeekEncoder);
        }
        if (this.isValidEncoderPropertyTuple(this.weekend)) {
            this.weekendEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.weekend.get(0)).radius((Double)this.weekend.get(1))).minVal(0.0)).maxVal(1.0)).periodic(false)).name("weekend")).forced(this.isForced())).build();
            this.addChildEncoder(this.weekendEncoder);
        }
        if (this.isValidEncoderPropertyTuple(this.customDays)) {
            List days = (List)this.customDays.get(1);
            StringBuilder customDayEncoderName = new StringBuilder();
            if (days.size() == 1) {
                customDayEncoderName.append((String)days.get(0));
            } else {
                for (String day : days) {
                    customDayEncoderName.append(day).append(" ");
                }
            }
            this.customDaysEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.customDays.get(0)).radius(1.0)).minVal(0.0)).maxVal(1.0)).periodic(false)).name(customDayEncoderName.toString())).forced(this.isForced())).build();
            this.addEncoder("customdays", this.customDaysEncoder);
            this.addCustomDays(days);
        }
        if (this.isValidEncoderPropertyTuple(this.holiday)) {
            this.holidayEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.holiday.get(0)).radius((Double)this.holiday.get(1))).minVal(0.0)).maxVal(1.0)).periodic(false)).name("holiday")).forced(this.isForced())).build();
            this.addChildEncoder(this.holidayEncoder);
        }
        if (this.isValidEncoderPropertyTuple(this.timeOfDay)) {
            this.timeOfDayEncoder = ((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)((ScalarEncoder.Builder)ScalarEncoder.builder().w((Integer)this.timeOfDay.get(0)).radius((Double)this.timeOfDay.get(1))).minVal(0.0)).maxVal(24.0)).periodic(true)).name("time of day")).forced(this.isForced())).build();
            this.addChildEncoder(this.timeOfDayEncoder);
        }
    }

    private boolean isValidEncoderPropertyTuple(Tuple encoderPropertyTuple) {
        return encoderPropertyTuple != null && (Integer)encoderPropertyTuple.get(0) != 0;
    }

    public void addEncoder(String name, Encoder child) {
        super.addEncoder(this, name, child, this.width);
        Iterator<Tuple> iterator = child.getDescription().iterator();
        while (iterator.hasNext()) {
            Tuple d;
            Tuple dT = d = iterator.next();
            this.description.add(new Tuple(dT.get(0), (Integer)dT.get(1) + this.getWidth()));
        }
        this.width += child.getWidth();
    }

    protected void addChildEncoder(ScalarEncoder encoder) {
        this.addEncoder(encoder.getName(), encoder);
    }

    protected void addCustomDays(List<String> daysList) {
        block25: for (String dayStr : daysList) {
            switch (dayStr.toLowerCase()) {
                case "mon": 
                case "monday": {
                    this.customDaysList.add(0);
                    continue block25;
                }
                case "tue": 
                case "tuesday": {
                    this.customDaysList.add(1);
                    continue block25;
                }
                case "wed": 
                case "wednesday": {
                    this.customDaysList.add(2);
                    continue block25;
                }
                case "thu": 
                case "thursday": {
                    this.customDaysList.add(3);
                    continue block25;
                }
                case "fri": 
                case "friday": {
                    this.customDaysList.add(4);
                    continue block25;
                }
                case "sat": 
                case "saturday": {
                    this.customDaysList.add(5);
                    continue block25;
                }
                case "sun": 
                case "sunday": {
                    this.customDaysList.add(6);
                    continue block25;
                }
            }
            throw new IllegalArgumentException(String.format("Unable to understand %s as a day of week", dayStr));
        }
    }

    public Tuple getSeason() {
        return this.season;
    }

    public void setSeason(Tuple season) {
        this.season = season;
    }

    public Tuple getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Tuple dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Tuple getWeekend() {
        return this.weekend;
    }

    public void setWeekend(Tuple weekend) {
        this.weekend = weekend;
    }

    public Tuple getCustomDays() {
        return this.customDays;
    }

    public void setCustomDays(Tuple customDays) {
        this.customDays = customDays;
    }

    public Tuple getHoliday() {
        return this.holiday;
    }

    public void setHoliday(Tuple holiday) {
        this.holiday = holiday;
    }

    public Tuple getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(Tuple timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getN() {
        return this.width;
    }

    @Override
    public int getW() {
        return this.width;
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    public void setCustomFormat(DateTimeFormatter formatter) {
        this.customFormatter = formatter;
    }

    public DateTime parse(String dateTimeStr) {
        return this.customFormatter.parseDateTime(dateTimeStr);
    }

    public int[] parseEncode(String dateStr) {
        int[] output = new int[this.getN()];
        this.encodeIntoArray(this.customFormatter.parseDateTime(dateStr), output);
        return output;
    }

    @Override
    public void encodeIntoArray(DateTime inputData, int[] output) {
        if (inputData == null) {
            throw new IllegalArgumentException("DateEncoder requires a valid Date object but got null");
        }
        TDoubleList scalars = this.getScalars(inputData);
        int fieldCounter = 0;
        for (EncoderTuple t : this.getEncoders(this)) {
            Encoder<?> encoder = t.getEncoder();
            int offset = t.getOffset();
            int[] tempArray = new int[encoder.getWidth()];
            encoder.encodeIntoArray(scalars.get(fieldCounter), tempArray);
            System.arraycopy(tempArray, 0, output, offset, tempArray.length);
            ++fieldCounter;
        }
    }

    @Override
    public List<String> getEncodedValues(Date inputData) {
        ArrayList<String> values = new ArrayList<String>();
        List<String> encodedValues = this.getEncodedValues(inputData);
        for (String v : encodedValues) {
            values.add(String.valueOf(v));
        }
        return values;
    }

    @Override
    public TDoubleList getScalars(DateTime inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException("DateEncoder requires a valid Date object but got null");
        }
        TDoubleArrayList values = new TDoubleArrayList();
        double timeOfDay = (double)inputData.getHourOfDay() + (double)inputData.getMinuteOfHour() / 60.0;
        int dayOfWeek = inputData.getDayOfWeek() - 1;
        if (this.seasonEncoder != null) {
            double dayOfYear = inputData.getDayOfYear() - 1;
            values.add(dayOfYear);
        }
        if (this.dayOfWeekEncoder != null) {
            values.add((double)dayOfWeek);
        }
        if (this.weekendEncoder != null) {
            boolean isWeekend = dayOfWeek == 6 || dayOfWeek == 5 || dayOfWeek == 4 && timeOfDay > 18.0;
            boolean weekend = isWeekend;
            values.add((double)weekend);
        }
        if (this.customDaysEncoder != null) {
            boolean isCustomDays = this.customDaysList.contains(dayOfWeek);
            boolean customDay = isCustomDays;
            values.add((double)customDay);
        }
        if (this.holidayEncoder != null) {
            double holidayness = 0.0;
            for (Tuple h : this.holidaysList) {
                long days;
                Duration diff;
                DateTime hdate = new DateTime(inputData.getYear(), ((Integer)h.get(0)).intValue(), ((Integer)h.get(1)).intValue(), 0, 0, 0);
                if (inputData.isAfter((ReadableInstant)hdate)) {
                    diff = new Interval((ReadableInstant)hdate, (ReadableInstant)inputData).toDuration();
                    days = diff.getStandardDays();
                    if (days == 0L) {
                        holidayness = 1.0;
                        break;
                    }
                    if (days != 1L) continue;
                    holidayness = 1.0 - ((double)diff.getStandardSeconds() - 86400.0 * (double)days) / 86400.0;
                    break;
                }
                diff = new Interval((ReadableInstant)inputData, (ReadableInstant)hdate).toDuration();
                days = diff.getStandardDays();
                if (days != 0L) continue;
                holidayness = 1.0 - ((double)diff.getStandardSeconds() - 86400.0 * (double)days) / 86400.0;
            }
            values.add(holidayness);
        }
        if (this.timeOfDayEncoder != null) {
            values.add(timeOfDay);
        }
        return values;
    }

    @Override
    public <S> List<S> getBucketValues(Class<S> returnType) {
        return null;
    }

    public int[] getBucketIndices(DateTime input) {
        TDoubleList scalars = this.getScalars(input);
        TIntArrayList l = new TIntArrayList();
        List<EncoderTuple> encoders = this.getEncoders(this);
        if (encoders != null && encoders.size() > 0) {
            int i = 0;
            for (EncoderTuple t : encoders) {
                l.addAll(t.getEncoder().getBucketIndices(scalars.get(i)));
                ++i;
            }
        } else {
            throw new IllegalStateException("Should be implemented in base classes that are not containers for other encoders");
        }
        return l.toArray();
    }

    @Override
    public void setLearning(boolean learningEnabled) {
        for (EncoderTuple t : this.getEncoders(this)) {
            Encoder<?> encoder = t.getEncoder();
            encoder.setLearningEnabled(learningEnabled);
        }
    }

    public static class Builder
    extends Encoder.Builder<Builder, DateEncoder> {
        protected Tuple season = new Tuple(0, 91.5);
        protected Tuple dayOfWeek = new Tuple(0, 1.0);
        protected Tuple weekend = new Tuple(0, 1.0);
        protected Tuple customDays = new Tuple(0, new ArrayList());
        protected Tuple holiday = new Tuple(0, 1.0);
        protected Tuple timeOfDay = new Tuple(0, 4.0);
        protected DateTimeFormatter customFormatter;

        private Builder() {
        }

        @Override
        public DateEncoder build() {
            this.encoder = new DateEncoder();
            super.build();
            DateEncoder e = (DateEncoder)this.encoder;
            e.setSeason(this.season);
            e.setDayOfWeek(this.dayOfWeek);
            e.setWeekend(this.weekend);
            e.setHoliday(this.holiday);
            e.setTimeOfDay(this.timeOfDay);
            e.setCustomDays(this.customDays);
            e.setCustomFormat(this.customFormatter);
            ((DateEncoder)this.encoder).init();
            return (DateEncoder)this.encoder;
        }

        public Builder season(int season, double radius) {
            this.season = new Tuple(season, radius);
            return this;
        }

        public Builder season(int season) {
            return this.season(season, (Double)this.season.get(1));
        }

        public Builder dayOfWeek(int dayOfWeek, double radius) {
            this.dayOfWeek = new Tuple(dayOfWeek, radius);
            return this;
        }

        public Builder dayOfWeek(int dayOfWeek) {
            return this.dayOfWeek(dayOfWeek, (Double)this.dayOfWeek.get(1));
        }

        public Builder weekend(int weekend, double radius) {
            this.weekend = new Tuple(weekend, radius);
            return this;
        }

        public Builder weekend(int weekend) {
            return this.weekend(weekend, (Double)this.weekend.get(1));
        }

        public Builder customDays(int customDays, List<String> customDaysList) {
            this.customDays = new Tuple(customDays, customDaysList);
            return this;
        }

        public Builder customDays(int customDays) {
            return this.customDays(customDays, (ArrayList)this.customDays.get(1));
        }

        public Builder holiday(int holiday, double radius) {
            this.holiday = new Tuple(holiday, radius);
            return this;
        }

        public Builder holiday(int holiday) {
            return this.holiday(holiday, (Double)this.holiday.get(1));
        }

        public Builder timeOfDay(int timeOfDay, double radius) {
            this.timeOfDay = new Tuple(timeOfDay, radius);
            return this;
        }

        public Builder timeOfDay(int timeOfDay) {
            return this.timeOfDay(timeOfDay, (Double)this.timeOfDay.get(1));
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder formatPattern(String pattern) {
            this.customFormatter = DateTimeFormat.forPattern((String)pattern);
            return this;
        }

        public Builder formatter(DateTimeFormatter formatter) {
            this.customFormatter = formatter;
            return this;
        }
    }
}

