/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.TDoubleCollection;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.encoders.EncoderResult;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.SparseObjectMatrix;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Encoder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Encoder.class);
    public static final double SENTINEL_VALUE_FOR_MISSING_DATA = Double.NaN;
    protected List<Tuple> description = new ArrayList<Tuple>();
    protected int w = 0;
    protected int n = 0;
    protected int halfWidth;
    protected double radius = 0.0;
    protected double resolution = 0.0;
    protected boolean periodic = true;
    protected double minVal = 0.0;
    protected double maxVal = 0.0;
    protected boolean clipInput;
    protected boolean forced;
    protected String name = "";
    protected int padding;
    protected int nInternal;
    protected double rangeInternal;
    protected double range;
    protected boolean encLearningEnabled;
    protected Set<FieldMetaType> flattenedFieldTypeList;
    protected Map<Tuple, List<FieldMetaType>> decoderFieldTypes;
    protected SparseObjectMatrix<int[]> topDownMapping;
    protected double[] topDownValues;
    protected List<?> bucketValues;
    protected LinkedHashMap<EncoderTuple, List<EncoderTuple>> encoders;
    protected List<String> scalarNames;

    protected Encoder() {
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getW() {
        return this.w;
    }

    public void setHalfWidth(int hw) {
        this.halfWidth = hw;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setRangeInternal(double r) {
        this.rangeInternal = r;
    }

    public double getRangeInternal() {
        return this.rangeInternal;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public double getRange() {
        return this.range;
    }

    public void setNInternal(int n) {
        this.nInternal = n;
    }

    public int getNInternal() {
        return this.nInternal;
    }

    public void setTopDownMapping(SparseObjectMatrix<int[]> sm) {
        this.topDownMapping = sm;
    }

    public void setTopDownValues(double[] values) {
        this.topDownValues = values;
    }

    public double[] getTopDownValues() {
        return this.topDownValues;
    }

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    public double getMinVal() {
        return this.minVal;
    }

    public void setMaxVal(double maxVal) {
        this.maxVal = maxVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setClipInput(boolean b) {
        this.clipInput = b;
    }

    public boolean clipInput() {
        return this.clipInput;
    }

    public void setPeriodic(boolean b) {
        this.periodic = b;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setForced(boolean b) {
        this.forced = b;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addEncoder(Encoder<T> parent, String name, Encoder<T> child, int offset) {
        EncoderTuple key;
        if (this.encoders == null) {
            this.encoders = new LinkedHashMap();
        }
        if ((key = this.getEncoderTuple(parent)) == null) {
            key = new EncoderTuple("", this, 0);
            this.encoders.put(key, new ArrayList());
        }
        List<EncoderTuple> childEncoders = null;
        childEncoders = this.encoders.get(key);
        if (childEncoders == null) {
            childEncoders = new ArrayList<EncoderTuple>();
            this.encoders.put(key, childEncoders);
        }
        childEncoders.add(new EncoderTuple(name, child, offset));
    }

    public EncoderTuple getEncoderTuple(Encoder<T> e) {
        if (this.encoders == null) {
            this.encoders = new LinkedHashMap();
        }
        for (EncoderTuple tuple : this.encoders.keySet()) {
            if (!tuple.getEncoder().equals(e)) continue;
            return tuple;
        }
        return null;
    }

    public List<EncoderTuple> getEncoders(Encoder<T> e) {
        return this.getEncoders().get(this.getEncoderTuple(e));
    }

    public Map<EncoderTuple, List<EncoderTuple>> getEncoders() {
        if (this.encoders == null) {
            this.encoders = new LinkedHashMap();
        }
        return this.encoders;
    }

    public void setLearningEnabled(boolean encLearningEnabled) {
        this.encLearningEnabled = encLearningEnabled;
    }

    public boolean isEncoderLearningEnabled() {
        return this.encLearningEnabled;
    }

    public List<FieldMetaType> getFlattenedFieldTypeList(Encoder<T> e) {
        if (this.decoderFieldTypes == null) {
            this.decoderFieldTypes = new HashMap<Tuple, List<FieldMetaType>>();
        }
        EncoderTuple key = this.getEncoderTuple(e);
        List<FieldMetaType> fieldTypes = null;
        fieldTypes = this.decoderFieldTypes.get(key);
        if (fieldTypes == null) {
            fieldTypes = new ArrayList<FieldMetaType>();
            this.decoderFieldTypes.put(key, fieldTypes);
        }
        return fieldTypes;
    }

    public Set<FieldMetaType> getFlattenedFieldTypeList() {
        return this.flattenedFieldTypeList;
    }

    public void setFlattenedFieldTypeList(Set<FieldMetaType> l) {
        this.flattenedFieldTypeList = l;
    }

    public List<String> getScalarNames() {
        return this.scalarNames;
    }

    public void setScalarNames(List<String> names) {
        this.scalarNames = names;
    }

    public abstract int getWidth();

    public abstract boolean isDelta();

    public abstract void encodeIntoArray(T var1, int[] var2);

    public void setLearning(boolean learningEnabled) {
        this.setLearningEnabled(learningEnabled);
    }

    public void setFieldStats(String fieldName, Map<String, Double> fieldStatistics) {
    }

    public int[] encode(T inputData) {
        int[] output = new int[this.getN()];
        this.encodeIntoArray(inputData, output);
        return output;
    }

    public List<String> getScalarNames(String parentFieldName) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.getEncoders() != null) {
            List<EncoderTuple> encoders = this.getEncoders(this);
            for (Tuple tuple : encoders) {
                List<String> subNames = ((Encoder)tuple.get(1)).getScalarNames(this.getName());
                ArrayList<String> hierarchicalNames = new ArrayList<String>();
                if (parentFieldName != null) {
                    for (String name : subNames) {
                        hierarchicalNames.add(String.format("%s.%s", parentFieldName, name));
                    }
                }
                names.addAll(hierarchicalNames);
            }
        } else if (parentFieldName != null) {
            names.add(parentFieldName);
        } else {
            names.add((String)this.getEncoderTuple(this).get(0));
        }
        return names;
    }

    public Set<FieldMetaType> getDecoderOutputFieldTypes() {
        if (this.getFlattenedFieldTypeList() != null) {
            return new HashSet<FieldMetaType>(this.getFlattenedFieldTypeList());
        }
        HashSet<FieldMetaType> retVal = new HashSet<FieldMetaType>();
        for (Tuple tuple : this.getEncoders(this)) {
            Set<FieldMetaType> subTypes = ((Encoder)tuple.get(1)).getDecoderOutputFieldTypes();
            retVal.addAll(subTypes);
        }
        this.setFlattenedFieldTypeList(retVal);
        return retVal;
    }

    public Object getInputValue(Object inputObject, String fieldName) {
        if (Map.class.isAssignableFrom(inputObject.getClass())) {
            Map map = (Map)inputObject;
            if (!map.containsKey(fieldName)) {
                throw new IllegalArgumentException("Unknown field name " + fieldName + " known fields are: " + map.keySet() + ". ");
            }
            return map.get(fieldName);
        }
        return null;
    }

    public <S> TDoubleList getScalars(S d) {
        TDoubleArrayList retVals = new TDoubleArrayList();
        double inputData = (Double)d;
        List<EncoderTuple> encoders = this.getEncoders(this);
        if (encoders != null) {
            for (EncoderTuple t : encoders) {
                TDoubleList values = t.getEncoder().getScalars(inputData);
                retVals.addAll((TDoubleCollection)values);
            }
        }
        return retVals;
    }

    public <S> List<String> getEncodedValues(S inputData) {
        ArrayList<String> retVals = new ArrayList<String>();
        Map<EncoderTuple, List<EncoderTuple>> encoders = this.getEncoders();
        if (encoders != null && encoders.size() > 0) {
            for (EncoderTuple t : encoders.keySet()) {
                retVals.addAll(t.getEncoder().getEncodedValues(inputData));
            }
        } else {
            retVals.add(inputData.toString());
        }
        return retVals;
    }

    public int[] getBucketIndices(String input) {
        TIntArrayList l = new TIntArrayList();
        Map<EncoderTuple, List<EncoderTuple>> encoders = this.getEncoders();
        if (encoders != null && encoders.size() > 0) {
            for (EncoderTuple t : encoders.keySet()) {
                l.addAll(t.getEncoder().getBucketIndices(input));
            }
        } else {
            throw new IllegalStateException("Should be implemented in base classes that are not containers for other encoders");
        }
        return l.toArray();
    }

    public int[] getBucketIndices(double input) {
        TIntArrayList l = new TIntArrayList();
        Map<EncoderTuple, List<EncoderTuple>> encoders = this.getEncoders();
        if (encoders != null && encoders.size() > 0) {
            for (EncoderTuple t : encoders.keySet()) {
                l.addAll(t.getEncoder().getBucketIndices(input));
            }
        } else {
            throw new IllegalStateException("Should be implemented in base classes that are not containers for other encoders");
        }
        return l.toArray();
    }

    public String scalarsToStr(List<?> scalarValues, List<String> scalarNames) {
        if (scalarNames == null || scalarNames.isEmpty()) {
            scalarNames = this.getScalarNames("");
        }
        StringBuilder desc = new StringBuilder();
        for (Tuple t : ArrayUtils.zip(scalarNames, scalarValues)) {
            if (desc.length() > 0) {
                desc.append(String.format(", %s:%.2f", t.get(0), t.get(1)));
                continue;
            }
            desc.append(String.format("%s:%.2f", t.get(0), t.get(1)));
        }
        return desc.toString();
    }

    public List<Tuple> getDescription() {
        return this.description;
    }

    public Tuple encodedBitDescription(int bitOffset, boolean formatted) {
        int width;
        List<Tuple> description = this.getDescription();
        int len = description.size();
        String prevFieldName = null;
        int prevFieldOffset = -1;
        int offset = -1;
        for (int i = 0; i < len; ++i) {
            Tuple t = description.get(i);
            if (formatted && bitOffset == (offset = (Integer)t.get(1) + 1) - 1) {
                prevFieldName = "separator";
                prevFieldOffset = bitOffset;
            }
            if (bitOffset < offset) break;
        }
        int n = width = formatted ? this.getDisplayWidth() : this.getWidth();
        if (prevFieldOffset == -1 || bitOffset > this.getWidth()) {
            throw new IllegalStateException("Bit is outside of allowable range: " + String.format("[0 - %d]", width));
        }
        return new Tuple(prevFieldName, bitOffset - prevFieldOffset);
    }

    public void pprintHeader(String prefix) {
        LOGGER.info(prefix == null ? "" : prefix);
        List<Tuple> description = this.getDescription();
        description.add(new Tuple("end", this.getWidth()));
        int len = description.size() - 1;
        for (int i = 0; i < len; ++i) {
            String name = (String)description.get(i).get(0);
            int width = (Integer)description.get(i + 1).get(1);
            String formatStr = String.format("%%-%ds |", width);
            StringBuilder pname = new StringBuilder(name);
            if (name.length() > width) {
                pname.setLength(width);
            }
            LOGGER.info(String.format(formatStr, pname));
        }
        len = this.getWidth() + (description.size() - 1) * 3 - 1;
        StringBuilder hyphens = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            hyphens.append("-");
        }
        LOGGER.info(prefix + hyphens);
    }

    public void pprint(int[] output, String prefix) {
        LOGGER.info(prefix == null ? "" : prefix);
        List<Tuple> description = this.getDescription();
        description.add(new Tuple("end", this.getWidth()));
        int len = description.size() - 1;
        for (int i = 0; i < len; ++i) {
            int offset = (Integer)description.get(i).get(1);
            int nextOffset = (Integer)description.get(i + 1).get(1);
            LOGGER.info(String.format("%s |", ArrayUtils.bitsToString(ArrayUtils.sub(output, ArrayUtils.range(offset, nextOffset)))));
        }
    }

    public Tuple decode(int[] encoded, String parentFieldName) {
        HashMap fieldsMap = new HashMap();
        ArrayList fieldsOrder = new ArrayList();
        String parentName = parentFieldName == null || parentFieldName.isEmpty() ? this.getName() : String.format("%s.%s", parentFieldName, this.getName());
        List<EncoderTuple> encoders = this.getEncoders(this);
        int len = encoders.size();
        for (int i = 0; i < len; ++i) {
            Tuple threeFieldsTuple = encoders.get(i);
            int nextOffset = 0;
            nextOffset = i < len - 1 ? ((Integer)encoders.get(i + 1).get(2)).intValue() : this.getW();
            int[] fieldOutput = ArrayUtils.sub(encoded, ArrayUtils.range((Integer)threeFieldsTuple.get(2), nextOffset));
            Tuple result = ((Encoder)threeFieldsTuple.get(1)).decode(fieldOutput, parentName);
            fieldsMap.putAll((Map)result.get(0));
            fieldsOrder.addAll((List)result.get(1));
        }
        return new Tuple(fieldsMap, fieldsOrder);
    }

    public String decodedToStr(Tuple decodeResults) {
        StringBuilder desc = new StringBuilder();
        Map fieldsDict = (Map)decodeResults.get(0);
        List fieldsOrder = (List)decodeResults.get(1);
        for (String fieldName : fieldsOrder) {
            Tuple ranges = (Tuple)fieldsDict.get(fieldName);
            if (desc.length() > 0) {
                desc.append(", ").append(fieldName).append(":");
            } else {
                desc.append(fieldName).append(":");
            }
            desc.append("[").append(ranges.get(1)).append("]");
        }
        return desc.toString();
    }

    public abstract <S> List<S> getBucketValues(Class<S> var1);

    public List<EncoderResult> getBucketInfo(int[] buckets) {
        ArrayList<EncoderResult> retVals = new ArrayList<EncoderResult>();
        int bucketOffset = 0;
        for (EncoderTuple encoderTuple : this.getEncoders(this)) {
            int nextBucketOffset = -1;
            List<EncoderTuple> childEncoders = null;
            childEncoders = this.getEncoders(encoderTuple.getEncoder());
            nextBucketOffset = childEncoders != null ? bucketOffset + childEncoders.size() : bucketOffset + 1;
            int[] bucketIndices = ArrayUtils.sub(buckets, ArrayUtils.range(bucketOffset, nextBucketOffset));
            List<EncoderResult> values = encoderTuple.getEncoder().getBucketInfo(bucketIndices);
            retVals.addAll(values);
            bucketOffset = nextBucketOffset;
        }
        return retVals;
    }

    public List<EncoderResult> topDownCompute(int[] encoded) {
        ArrayList<EncoderResult> retVals = new ArrayList<EncoderResult>();
        List<EncoderTuple> encoders = this.getEncoders(this);
        int len = encoders.size();
        for (int i = 0; i < len; ++i) {
            int offset = (Integer)encoders.get(i).get(2);
            Encoder encoder = (Encoder)encoders.get(i).get(1);
            int nextOffset = i < len - 1 ? ((Integer)encoders.get(i + 1).get(2)).intValue() : this.getW();
            int[] fieldOutput = ArrayUtils.sub(encoded, ArrayUtils.range(offset, nextOffset));
            List<EncoderResult> values = encoder.topDownCompute(fieldOutput);
            retVals.addAll(values);
        }
        return retVals;
    }

    public TDoubleList closenessScores(TDoubleList expValues, TDoubleList actValues, boolean fractional) {
        TDoubleArrayList retVal = new TDoubleArrayList();
        List<EncoderTuple> encoders = this.getEncoders(this);
        if (encoders == null || encoders.size() < 1) {
            double err = Math.abs(expValues.get(0) - actValues.get(0));
            double closeness = -1.0;
            if (fractional) {
                double denom = Math.max(expValues.get(0), actValues.get(0));
                if (denom == 0.0) {
                    denom = 1.0;
                }
                if ((closeness = 1.0 - err / denom) < 0.0) {
                    closeness = 0.0;
                }
            } else {
                closeness = err;
            }
            retVal.add(closeness);
            return retVal;
        }
        int scalarIdx = 0;
        for (EncoderTuple res : this.getEncoders(this)) {
            TDoubleList values = res.getEncoder().closenessScores(expValues.subList(scalarIdx, expValues.size()), actValues.subList(scalarIdx, actValues.size()), fractional);
            scalarIdx += values.size();
            retVal.addAll((TDoubleCollection)values);
        }
        return retVal;
    }

    public int[] rightVecProd(SparseObjectMatrix<int[]> matrix, int[] encoded) {
        int[] retVal = new int[matrix.getMaxIndex() + 1];
        for (int i = 0; i < retVal.length; ++i) {
            int[] slice = matrix.getObject(i);
            for (int j = 0; j < slice.length; ++j) {
                int n = i;
                retVal[n] = retVal[n] + slice[j] * encoded[j];
            }
        }
        return retVal;
    }

    public int getDisplayWidth() {
        return this.getWidth() + this.getDescription().size() - 1;
    }

    public static abstract class Builder<K, E> {
        protected int n;
        protected int w;
        protected double minVal;
        protected double maxVal;
        protected double radius;
        protected double resolution;
        protected boolean periodic;
        protected boolean clipInput;
        protected boolean forced;
        protected String name;
        protected Encoder<?> encoder;

        public E build() {
            if (this.encoder == null) {
                throw new IllegalStateException("Subclass did not instantiate builder type before calling this method!");
            }
            this.encoder.setN(this.n);
            this.encoder.setW(this.w);
            this.encoder.setMinVal(this.minVal);
            this.encoder.setMaxVal(this.maxVal);
            this.encoder.setRadius(this.radius);
            this.encoder.setResolution(this.resolution);
            this.encoder.setPeriodic(this.periodic);
            this.encoder.setClipInput(this.clipInput);
            this.encoder.setForced(this.forced);
            this.encoder.setName(this.name);
            return (E)this.encoder;
        }

        public K n(int n) {
            this.n = n;
            return (K)this;
        }

        public K w(int w) {
            this.w = w;
            return (K)this;
        }

        public K minVal(double minVal) {
            this.minVal = minVal;
            return (K)this;
        }

        public K maxVal(double maxVal) {
            this.maxVal = maxVal;
            return (K)this;
        }

        public K radius(double radius) {
            this.radius = radius;
            return (K)this;
        }

        public K resolution(double resolution) {
            this.resolution = resolution;
            return (K)this;
        }

        public K periodic(boolean periodic) {
            this.periodic = periodic;
            return (K)this;
        }

        public K clipInput(boolean clipInput) {
            this.clipInput = clipInput;
            return (K)this;
        }

        public K forced(boolean forced) {
            this.forced = forced;
            return (K)this;
        }

        public K name(String name) {
            this.name = name;
            return (K)this;
        }
    }
}

