/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.numenta.nupic.encoders.CategoryEncoder;
import org.numenta.nupic.encoders.CoordinateEncoder;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.DeltaEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.encoders.GeospatialCoordinateEncoder;
import org.numenta.nupic.encoders.LogEncoder;
import org.numenta.nupic.encoders.PassThroughEncoder;
import org.numenta.nupic.encoders.RandomDistributedScalarEncoder;
import org.numenta.nupic.encoders.SDRCategoryEncoder;
import org.numenta.nupic.encoders.SDRPassThroughEncoder;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.encoders.SparsePassThroughEncoder;
import org.numenta.nupic.util.Tuple;

public class MultiEncoder
extends Encoder<Object> {
    protected TIntObjectMap<String> indexToCategory = new TIntObjectHashMap();
    protected List<Tuple> categoryList;
    protected int width;
    protected static final String CATEGORY_DELIMITER = ";";

    private MultiEncoder() {
    }

    public static Encoder.Builder<Builder, MultiEncoder> builder() {
        return new Builder();
    }

    public void init() {
    }

    @Override
    public void setFieldStats(String fieldName, Map<String, Double> fieldStatistics) {
        for (EncoderTuple t : this.getEncoders(this)) {
            String name = t.getName();
            Encoder<?> encoder = t.getEncoder();
            encoder.setFieldStats(name, fieldStatistics);
        }
    }

    @Override
    public void encodeIntoArray(Object input, int[] output) {
        for (EncoderTuple t : this.getEncoders(this)) {
            String name = t.getName();
            Encoder<?> encoder = t.getEncoder();
            int offset = t.getOffset();
            int[] tempArray = new int[encoder.getWidth()];
            try {
                Object o = this.getInputValue(input, name);
                encoder.encodeIntoArray(o, tempArray);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
            System.arraycopy(tempArray, 0, output, offset, tempArray.length);
        }
    }

    public int[] encodeField(String fieldName, Object value) {
        for (EncoderTuple t : this.getEncoders(this)) {
            String name = t.getName();
            Encoder<?> encoder = t.getEncoder();
            if (!name.equals(fieldName)) continue;
            return encoder.encode(value);
        }
        return new int[0];
    }

    public List<int[]> encodeEachField(Object input) {
        ArrayList<int[]> encodings = new ArrayList<int[]>();
        for (EncoderTuple t : this.getEncoders(this)) {
            String name = t.getName();
            Encoder<?> encoder = t.getEncoder();
            encodings.add(encoder.encode(this.getInputValue(input, name)));
        }
        return encodings;
    }

    public void addEncoder(String name, Encoder child) {
        super.addEncoder(this, name, child, this.width);
        Iterator<Tuple> iterator = child.getDescription().iterator();
        while (iterator.hasNext()) {
            Tuple d;
            Tuple dT = d = iterator.next();
            this.description.add(new Tuple(dT.get(0), (Integer)dT.get(1) + this.getWidth()));
        }
        this.width += child.getWidth();
    }

    public void addMultipleEncoders(Map<String, Map<String, Object>> fieldEncodings) {
        ArrayList<String> sortedFields = new ArrayList<String>(fieldEncodings.keySet());
        Collections.sort(sortedFields);
        for (String field : sortedFields) {
            Map<String, Object> params = fieldEncodings.get(field);
            if (!params.containsKey("fieldName")) {
                throw new IllegalArgumentException("Missing fieldname for encoder " + field);
            }
            String fieldName = (String)params.get("fieldName");
            if (!params.containsKey("encoderType")) {
                throw new IllegalArgumentException("Missing type for encoder " + field);
            }
            String encoderType = (String)params.get("encoderType");
            Encoder.Builder<?, ?> builder = this.getBuilder(encoderType);
            for (String param : params.keySet()) {
                if (param.equals("fieldName") || param.equals("encoderType") || param.equals("fieldType") || param.equals("fieldEncodings")) continue;
                this.setValue(builder, param, params.get(param));
            }
            Encoder encoder = (Encoder)builder.build();
            this.addEncoder(fieldName, encoder);
        }
    }

    public Encoder.Builder<?, ?> getBuilder(String encoderName) {
        switch (encoderName) {
            case "CategoryEncoder": {
                return CategoryEncoder.builder();
            }
            case "CoordinateEncoder": {
                return CoordinateEncoder.builder();
            }
            case "GeospatialCoordinateEncoder": {
                return GeospatialCoordinateEncoder.geobuilder();
            }
            case "LogEncoder": {
                return LogEncoder.builder();
            }
            case "PassThroughEncoder": {
                return PassThroughEncoder.builder();
            }
            case "ScalarEncoder": {
                return ScalarEncoder.builder();
            }
            case "SparsePassThroughEncoder": {
                return SparsePassThroughEncoder.sparseBuilder();
            }
            case "SDRCategoryEncoder": {
                return SDRCategoryEncoder.builder();
            }
            case "RandomDistributedScalarEncoder": {
                return RandomDistributedScalarEncoder.builder();
            }
            case "DateEncoder": {
                return DateEncoder.builder();
            }
            case "DeltaEncoder": {
                return DeltaEncoder.deltaBuilder();
            }
            case "SDRPassThroughEncoder": {
                return SDRPassThroughEncoder.sptBuilder();
            }
        }
        throw new IllegalArgumentException("Invalid encoder: " + encoderName);
    }

    public void setValue(Encoder.Builder builder, String param, Object value) {
        switch (param) {
            case "n": {
                builder.n((Integer)((Object)value));
                break;
            }
            case "w": {
                builder.w((Integer)((Object)value));
                break;
            }
            case "minVal": {
                builder.minVal((Double)((Object)value));
                break;
            }
            case "maxVal": {
                builder.maxVal((Double)((Object)value));
                break;
            }
            case "radius": {
                builder.radius((Double)((Object)value));
                break;
            }
            case "resolution": {
                builder.resolution((Double)((Object)value));
                break;
            }
            case "periodic": {
                builder.periodic((Boolean)((Object)value));
                break;
            }
            case "clipInput": {
                builder.clipInput((Boolean)((Object)value));
                break;
            }
            case "forced": {
                builder.forced((Boolean)((Object)value));
                break;
            }
            case "name": {
                builder.name((String)((Object)value));
                break;
            }
            case "categoryList": {
                if (value instanceof String) {
                    String strVal = (String)((Object)value);
                    if (strVal.indexOf(CATEGORY_DELIMITER) == -1) {
                        throw new IllegalArgumentException("Category field not delimited with ';' character.");
                    }
                    value = Arrays.asList(strVal.split("[\\s]*\\;[\\s]*"));
                }
                if (builder instanceof CategoryEncoder.Builder) {
                    ((CategoryEncoder.Builder)builder).categoryList(value);
                    break;
                }
                ((SDRCategoryEncoder.Builder)builder).categoryList(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter: " + param);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getN() {
        return this.width;
    }

    @Override
    public int getW() {
        return this.width;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    @Override
    public void setLearning(boolean learningEnabled) {
        for (EncoderTuple t : this.getEncoders(this)) {
            Encoder<?> encoder = t.getEncoder();
            encoder.setLearningEnabled(learningEnabled);
        }
    }

    @Override
    public <S> List<S> getBucketValues(Class<S> returnType) {
        return null;
    }

    public static class Builder
    extends Encoder.Builder<Builder, MultiEncoder> {
        private Builder() {
        }

        @Override
        public MultiEncoder build() {
            this.encoder = new MultiEncoder();
            super.build();
            ((MultiEncoder)this.encoder).init();
            return (MultiEncoder)this.encoder;
        }
    }
}

