/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import java.util.Arrays;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.PassThroughEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDRPassThroughEncoder
extends PassThroughEncoder<int[]> {
    protected final Logger LOGGER = LoggerFactory.getLogger(SDRPassThroughEncoder.class);

    protected SDRPassThroughEncoder() {
    }

    public SDRPassThroughEncoder(int outputWidth, Integer outputBitsOnCount) {
        super(outputWidth, outputBitsOnCount);
        this.LOGGER.info("Building new SDRPassThroughEncoder overriding instance, outputWidth: {} outputBitsOnCount: {}", (Object)outputWidth, (Object)outputBitsOnCount);
    }

    public static Encoder.Builder<Builder, SDRPassThroughEncoder> sptBuilder() {
        return new Builder();
    }

    @Override
    public void encodeIntoArray(int[] input, int[] output) {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("encodeIntoArray: input: {} \nOutput: {} ", (Object)Arrays.toString(input), (Object)Arrays.toString(output));
        }
        System.arraycopy(input, 0, output, 0, output.length);
    }

    public static class Builder
    extends Encoder.Builder<Builder, SDRPassThroughEncoder> {
        private Builder() {
        }

        @Override
        public SDRPassThroughEncoder build() {
            this.encoder = new SDRPassThroughEncoder();
            this.w = this.n;
            super.build();
            ((SDRPassThroughEncoder)this.encoder).init();
            return (SDRPassThroughEncoder)this.encoder;
        }
    }
}

