/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.encoders;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.encoders.DecodeResult;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderResult;
import org.numenta.nupic.encoders.RangeList;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Condition;
import org.numenta.nupic.util.MinMax;
import org.numenta.nupic.util.SparseObjectMatrix;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalarEncoder
extends Encoder<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScalarEncoder.class);

    ScalarEncoder() {
    }

    public static Encoder.Builder<Builder, ScalarEncoder> builder() {
        return new Builder();
    }

    @Override
    public boolean isDelta() {
        return false;
    }

    public void init() {
        if (this.getW() % 2 == 0) {
            throw new IllegalStateException("W must be an odd number (to eliminate centering difficulty)");
        }
        this.setHalfWidth((this.getW() - 1) / 2);
        this.setPadding(this.isPeriodic() ? 0 : this.getHalfWidth());
        if (!Double.isNaN(this.getMinVal()) && !Double.isNaN(this.getMaxVal())) {
            if (this.getMinVal() >= this.getMaxVal()) {
                throw new IllegalStateException("maxVal must be > minVal");
            }
            this.setRangeInternal(this.getMaxVal() - this.getMinVal());
        }
        this.initEncoder(this.getW(), this.getMinVal(), this.getMaxVal(), this.getN(), this.getRadius(), this.getResolution());
        this.setNInternal(this.getN() - 2 * this.getPadding());
        if (this.getName() == null) {
            if (this.getMinVal() % (double)((int)this.getMinVal()) > 0.0 || this.getMaxVal() % (double)((int)this.getMaxVal()) > 0.0) {
                this.setName("[" + this.getMinVal() + ":" + this.getMaxVal() + "]");
            } else {
                this.setName("[" + (int)this.getMinVal() + ":" + (int)this.getMaxVal() + "]");
            }
        }
        if (!this.isForced()) {
            this.checkReasonableSettings();
        }
        this.description.add(new Tuple((this.name = this.getName()).equals("None") ? "[" + (int)this.getMinVal() + ":" + (int)this.getMaxVal() + "]" : this.name, 0));
    }

    public void initEncoder(int w, double minVal, double maxVal, int n, double radius, double resolution) {
        if (n != 0) {
            if (!Double.isNaN(minVal) && !Double.isNaN(maxVal)) {
                if (!this.isPeriodic()) {
                    this.setResolution(this.getRangeInternal() / (double)(this.getN() - this.getW()));
                } else {
                    this.setResolution(this.getRangeInternal() / (double)this.getN());
                }
                this.setRadius((double)this.getW() * this.getResolution());
                if (this.isPeriodic()) {
                    this.setRange(this.getRangeInternal());
                } else {
                    this.setRange(this.getRangeInternal() + this.getResolution());
                }
            }
        } else {
            if (radius != 0.0) {
                this.setResolution(this.getRadius() / (double)w);
            } else if (resolution != 0.0) {
                this.setRadius(this.getResolution() * (double)w);
            } else {
                throw new IllegalStateException("One of n, radius, resolution must be specified for a ScalarEncoder");
            }
            if (this.isPeriodic()) {
                this.setRange(this.getRangeInternal());
            } else {
                this.setRange(this.getRangeInternal() + this.getResolution());
            }
            double nFloat = (double)w * (this.getRange() / this.getRadius()) + (double)(2 * this.getPadding());
            this.setN((int)Math.ceil(nFloat));
        }
    }

    public Integer getFirstOnBit(double input) {
        if (input == Double.NaN) {
            return null;
        }
        if (input < this.getMinVal()) {
            if (this.clipInput() && !this.isPeriodic()) {
                LOGGER.info("Clipped input " + this.getName() + "=" + input + " to minval " + this.getMinVal());
                input = this.getMinVal();
            } else {
                throw new IllegalStateException("input (" + input + ") less than range (" + this.getMinVal() + " - " + this.getMaxVal());
            }
        }
        if (this.isPeriodic()) {
            if (input >= this.getMaxVal()) {
                throw new IllegalStateException("input (" + input + ") greater than periodic range (" + this.getMinVal() + " - " + this.getMaxVal());
            }
        } else if (input > this.getMaxVal()) {
            if (this.clipInput()) {
                LOGGER.info("Clipped input " + this.getName() + "=" + input + " to maxval " + this.getMaxVal());
                input = this.getMaxVal();
            } else {
                throw new IllegalStateException("input (" + input + ") greater than periodic range (" + this.getMinVal() + " - " + this.getMaxVal());
            }
        }
        int centerbin = this.isPeriodic() ? (int)((input - this.getMinVal()) * (double)this.getNInternal() / this.getRange()) + this.getPadding() : (int)((input - this.getMinVal() + this.getResolution() / 2.0) / this.getResolution()) + this.getPadding();
        return centerbin - this.getHalfWidth();
    }

    public void checkReasonableSettings() {
        if (this.getW() < 21) {
            throw new IllegalStateException("Number of bits in the SDR (%d) must be greater than 2, and recommended >= 21 (use forced=True to override)");
        }
    }

    @Override
    public Set<FieldMetaType> getDecoderOutputFieldTypes() {
        return new LinkedHashSet<FieldMetaType>(Arrays.asList(FieldMetaType.FLOAT, FieldMetaType.INTEGER));
    }

    @Override
    public int getWidth() {
        return this.getN();
    }

    @Override
    public int[] getBucketIndices(String input) {
        return null;
    }

    @Override
    public int[] getBucketIndices(double input) {
        int bucketIdx;
        int minbin = this.getFirstOnBit(input);
        if (this.isPeriodic()) {
            bucketIdx = minbin + this.getHalfWidth();
            if (bucketIdx < 0) {
                bucketIdx += this.getN();
            }
        } else {
            bucketIdx = minbin;
        }
        return new int[]{bucketIdx};
    }

    @Override
    public void encodeIntoArray(Double input, int[] output) {
        if (Double.isNaN(input)) {
            Arrays.fill(output, 0);
            return;
        }
        Integer bucketVal = this.getFirstOnBit(input);
        if (bucketVal != null) {
            int bucketIdx = bucketVal;
            Arrays.fill(output, 0);
            int minbin = bucketIdx;
            int maxbin = minbin + 2 * this.getHalfWidth();
            if (this.isPeriodic()) {
                if (maxbin >= this.getN()) {
                    int bottombins = maxbin - this.getN() + 1;
                    int[] range = ArrayUtils.range(0, bottombins);
                    ArrayUtils.setIndexesTo(output, range, 1);
                    maxbin = this.getN() - 1;
                }
                if (minbin < 0) {
                    int topbins = -minbin;
                    ArrayUtils.setIndexesTo(output, ArrayUtils.range(this.getN() - topbins, this.getN()), 1);
                    minbin = 0;
                }
            }
            ArrayUtils.setIndexesTo(output, ArrayUtils.range(minbin, maxbin + 1), 1);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("");
            LOGGER.trace("input: " + input);
            LOGGER.trace("range: " + this.getMinVal() + " - " + this.getMaxVal());
            LOGGER.trace("n:" + this.getN() + "w:" + this.getW() + "resolution:" + this.getResolution() + "radius:" + this.getRadius() + "periodic:" + this.isPeriodic());
            LOGGER.trace("output: " + Arrays.toString(output));
            LOGGER.trace("input desc: " + this.decode(output, ""));
        }
    }

    @Override
    public DecodeResult decode(int[] encoded, String parentFieldName) {
        if (encoded == null || encoded.length < 1) {
            return null;
        }
        int[] tmpOutput = Arrays.copyOf(encoded, encoded.length);
        int maxZerosInARow = this.getHalfWidth();
        for (int i = 0; i < maxZerosInARow; ++i) {
            int j;
            int[] searchStr = new int[i + 3];
            Arrays.fill(searchStr, 1);
            ArrayUtils.setRangeTo(searchStr, 1, -1, 0);
            int subLen = searchStr.length;
            if (this.isPeriodic()) {
                for (j = 0; j < this.getN(); ++j) {
                    int[] outputIndices = ArrayUtils.range(j, j + subLen);
                    if (!Arrays.equals(searchStr, ArrayUtils.sub(tmpOutput, outputIndices = ArrayUtils.modulo(outputIndices, this.getN())))) continue;
                    ArrayUtils.setIndexesTo(tmpOutput, outputIndices, 1);
                }
                continue;
            }
            for (j = 0; j < this.getN() - subLen + 1; ++j) {
                if (!Arrays.equals(searchStr, ArrayUtils.sub(tmpOutput, ArrayUtils.range(j, j + subLen)))) continue;
                ArrayUtils.setRangeTo(tmpOutput, j, j + subLen, 1);
            }
        }
        LOGGER.trace("raw output:" + Arrays.toString(ArrayUtils.sub(encoded, ArrayUtils.range(0, this.getN()))));
        LOGGER.trace("filtered output:" + Arrays.toString(tmpOutput));
        int[] nz = ArrayUtils.where(tmpOutput, new Condition.Adapter<Integer>(){

            @Override
            public boolean eval(int n) {
                return n > 0;
            }
        });
        List<Tuple> runs = new ArrayList<Tuple>();
        Arrays.sort(nz);
        int[] run = new int[]{nz[0], 1};
        for (int i = 1; i < nz.length; ++i) {
            if (nz[i] == run[0] + run[1]) {
                run[1] = run[1] + 1;
                continue;
            }
            runs.add(new Tuple(run[0], run[1]));
            run = new int[]{nz[i], 1};
        }
        runs.add(new Tuple(run[0], run[1]));
        if (this.isPeriodic() && runs.size() > 1) {
            int l = runs.size() - 1;
            if ((Integer)((Tuple)runs.get(0)).get(0) == 0 && (Integer)((Tuple)runs.get(l)).get(0) + (Integer)((Tuple)runs.get(l)).get(1) == this.getN()) {
                runs.set(l, new Tuple((Integer)((Tuple)runs.get(l)).get(0), (Integer)((Tuple)runs.get(l)).get(1) + (Integer)((Tuple)runs.get(0)).get(1)));
                runs = runs.subList(1, runs.size());
            }
        }
        int left = 0;
        int right = 0;
        ArrayList<MinMax> ranges = new ArrayList<MinMax>();
        for (Tuple tupleRun : runs) {
            double inMax;
            double inMin;
            int start = (Integer)tupleRun.get(0);
            int runLen = (Integer)tupleRun.get(1);
            if (runLen <= this.getW()) {
                left = right = start + runLen / 2;
            } else {
                left = start + this.getHalfWidth();
                right = start + runLen - 1 - this.getHalfWidth();
            }
            if (!this.isPeriodic()) {
                inMin = (double)(left - this.getPadding()) * this.getResolution() + this.getMinVal();
                inMax = (double)(right - this.getPadding()) * this.getResolution() + this.getMinVal();
            } else {
                inMin = (double)(left - this.getPadding()) * this.getRange() / (double)this.getNInternal() + this.getMinVal();
                inMax = (double)(right - this.getPadding()) * this.getRange() / (double)this.getNInternal() + this.getMinVal();
            }
            if (this.isPeriodic() && inMin >= this.getMaxVal()) {
                inMin -= this.getRange();
                inMax -= this.getRange();
            }
            if (inMin < this.getMinVal()) {
                inMin = this.getMinVal();
            }
            if (inMax < this.getMinVal()) {
                inMax = this.getMinVal();
            }
            if (this.isPeriodic() && inMax >= this.getMaxVal()) {
                ranges.add(new MinMax(inMin, this.getMaxVal()));
                ranges.add(new MinMax(this.getMinVal(), inMax - this.getRange()));
                continue;
            }
            if (inMax > this.getMaxVal()) {
                inMax = this.getMaxVal();
            }
            if (inMin > this.getMaxVal()) {
                inMin = this.getMaxVal();
            }
            ranges.add(new MinMax(inMin, inMax));
        }
        String desc = this.generateRangeDescription(ranges);
        String fieldName = parentFieldName != null && !parentFieldName.isEmpty() ? String.format("%s.%s", parentFieldName, this.getName()) : this.getName();
        RangeList inner = new RangeList((List<MinMax>)ranges, desc);
        HashMap<String, RangeList> fieldsDict = new HashMap<String, RangeList>();
        fieldsDict.put(fieldName, inner);
        return new DecodeResult((Map<String, RangeList>)fieldsDict, Arrays.asList(fieldName));
    }

    public String generateRangeDescription(List<MinMax> ranges) {
        StringBuilder desc = new StringBuilder();
        int numRanges = ranges.size();
        for (int i = 0; i < numRanges; ++i) {
            if (ranges.get(i).min() != ranges.get(i).max()) {
                desc.append(String.format("%.2f-%.2f", ranges.get(i).min(), ranges.get(i).max()));
            } else {
                desc.append(String.format("%.2f", ranges.get(i).min()));
            }
            if (i >= numRanges - 1) continue;
            desc.append(", ");
        }
        return desc.toString();
    }

    public SparseObjectMatrix<int[]> getTopDownMapping() {
        if (this.topDownMapping == null) {
            if (this.isPeriodic()) {
                this.setTopDownValues(ArrayUtils.arange(this.getMinVal() + this.getResolution() / 2.0, this.getMaxVal(), this.getResolution()));
            } else {
                this.setTopDownValues(ArrayUtils.arange(this.getMinVal(), this.getMaxVal() + this.getResolution() / 2.0, this.getResolution()));
            }
        }
        int numCategories = this.getTopDownValues().length;
        SparseObjectMatrix<int[]> topDownMapping = new SparseObjectMatrix<int[]>(new int[]{numCategories});
        this.setTopDownMapping(topDownMapping);
        double[] topDownValues = this.getTopDownValues();
        int[] outputSpace = new int[this.getN()];
        double minVal = this.getMinVal();
        double maxVal = this.getMaxVal();
        for (int i = 0; i < numCategories; ++i) {
            double value = topDownValues[i];
            value = Math.max(value, minVal);
            value = Math.min(value, maxVal);
            this.encodeIntoArray(value, outputSpace);
            topDownMapping.set(i, (Object)Arrays.copyOf(outputSpace, outputSpace.length));
        }
        return topDownMapping;
    }

    @Override
    public <S> TDoubleList getScalars(S d) {
        TDoubleArrayList retVal = new TDoubleArrayList();
        retVal.add(((Double)d).doubleValue());
        return retVal;
    }

    @Override
    public <S> List<S> getBucketValues(Class<S> t) {
        if (this.bucketValues == null) {
            SparseObjectMatrix<int[]> topDownMapping = this.getTopDownMapping();
            int numBuckets = topDownMapping.getMaxIndex() + 1;
            this.bucketValues = new ArrayList();
            int i = 0;
            while (i < numBuckets) {
                this.bucketValues.add((Double)this.getBucketInfo(new int[]{i++}).get(0).get(1));
            }
        }
        return this.bucketValues;
    }

    @Override
    public List<EncoderResult> getBucketInfo(int[] buckets) {
        SparseObjectMatrix<int[]> topDownMapping = this.getTopDownMapping();
        int category = buckets[0];
        int[] encoding = topDownMapping.getObject(category);
        double inputVal = this.isPeriodic() ? this.getMinVal() + this.getResolution() / 2.0 + (double)category * this.getResolution() : this.getMinVal() + (double)category * this.getResolution();
        return Arrays.asList(new EncoderResult((Object)inputVal, inputVal, encoding));
    }

    @Override
    public List<EncoderResult> topDownCompute(int[] encoded) {
        SparseObjectMatrix<int[]> topDownMapping = this.getTopDownMapping();
        int category = ArrayUtils.argmax(this.rightVecProd(topDownMapping, encoded));
        return this.getBucketInfo(new int[]{category});
    }

    public List<Tuple> dict() {
        ArrayList<Tuple> l = new ArrayList<Tuple>();
        l.add(new Tuple("maxval", this.getMaxVal()));
        l.add(new Tuple("bucketValues", this.getBucketValues(Double.class)));
        l.add(new Tuple("nInternal", this.getNInternal()));
        l.add(new Tuple("name", this.getName()));
        l.add(new Tuple("minval", this.getMinVal()));
        l.add(new Tuple("topDownValues", Arrays.toString(this.getTopDownValues())));
        l.add(new Tuple("clipInput", this.clipInput()));
        l.add(new Tuple("n", this.getN()));
        l.add(new Tuple("padding", this.getPadding()));
        l.add(new Tuple("range", this.getRange()));
        l.add(new Tuple("periodic", this.isPeriodic()));
        l.add(new Tuple("radius", this.getRadius()));
        l.add(new Tuple("w", this.getW()));
        l.add(new Tuple("topDownMappingM", this.getTopDownMapping()));
        l.add(new Tuple("halfwidth", this.getHalfWidth()));
        l.add(new Tuple("resolution", this.getResolution()));
        l.add(new Tuple("rangeInternal", this.getRangeInternal()));
        return l;
    }

    public static class Builder
    extends Encoder.Builder<Builder, ScalarEncoder> {
        private Builder() {
        }

        @Override
        public ScalarEncoder build() {
            this.encoder = new ScalarEncoder();
            super.build();
            ((ScalarEncoder)this.encoder).init();
            return (ScalarEncoder)this.encoder;
        }
    }
}

