/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.ProximalDendrite;

public class Column
implements Comparable<Column> {
    private final int index;
    private final Integer boxedIndex;
    private final int numCells;
    private ProximalDendrite proximalDendrite;
    private Cell[] cells;
    private List<Cell> cellList;
    private final int hashcode;

    public Column(int numCells, int index) {
        this.numCells = numCells;
        this.index = index;
        this.boxedIndex = index;
        this.hashcode = this.hashCode();
        this.cells = new Cell[numCells];
        for (int i = 0; i < numCells; ++i) {
            this.cells[i] = new Cell(this, i);
        }
        this.cellList = Collections.unmodifiableList(Arrays.asList(this.cells));
        this.proximalDendrite = new ProximalDendrite(index);
    }

    public Cell getCell(int index) {
        return this.cells[index];
    }

    public List<Cell> getCells() {
        return this.cellList;
    }

    public int getIndex() {
        return this.index;
    }

    public int getNumCellsPerColumn() {
        return this.numCells;
    }

    public Cell getLeastUsedCell(Connections c, Random random) {
        ArrayList<Cell> leastUsedCells = new ArrayList<Cell>();
        int minNumSegments = Integer.MAX_VALUE;
        for (Cell cell : this.cellList) {
            int numSegments = cell.getSegments(c).size();
            if (numSegments < minNumSegments) {
                minNumSegments = numSegments;
                leastUsedCells.clear();
            }
            if (numSegments != minNumSegments) continue;
            leastUsedCells.add(cell);
        }
        int index = random.nextInt(leastUsedCells.size());
        Collections.sort(leastUsedCells);
        return (Cell)leastUsedCells.get(index);
    }

    public ProximalDendrite getProximalDendrite() {
        return this.proximalDendrite;
    }

    public Pool createPotentialPool(Connections c, int[] inputVectorIndexes) {
        return this.proximalDendrite.createPool(c, inputVectorIndexes);
    }

    public void setProximalPermanences(Connections c, double[] permanences) {
        this.proximalDendrite.setPermanences(c, permanences);
    }

    public void setProximalPermanencesSparse(Connections c, double[] permanences, int[] indexes) {
        this.proximalDendrite.setPermanences(c, permanences, indexes);
    }

    public void setProximalConnectedSynapsesForTest(Connections c, int[] connections) {
        this.proximalDendrite.setConnectedSynapsesForTest(c, connections);
    }

    public String toString() {
        return "" + this.index;
    }

    @Override
    public int compareTo(Column otherColumn) {
        return this.boxedIndex.compareTo(otherColumn.boxedIndex);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            return result;
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        return this.index == other.index;
    }
}

