/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.List;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;

public class ProximalDendrite
extends Segment {
    private Pool pool;

    public ProximalDendrite(int index) {
        this.index = index;
    }

    public Pool createPool(Connections c, int[] inputIndexes) {
        this.pool = new Pool(inputIndexes.length);
        for (int i = 0; i < inputIndexes.length; ++i) {
            int synCount = c.getSynapseCount();
            this.pool.setPermanence(c, this.createSynapse(c, c.getSynapses(this), null, this.pool, synCount, inputIndexes[i]), 0.0);
            c.setSynapseCount(synCount + 1);
        }
        return this.pool;
    }

    public void clearSynapses(Connections c) {
        c.getSynapses(this).clear();
    }

    public void setPermanences(Connections c, double[] perms) {
        this.pool.resetConnections();
        c.getConnectedCounts().clearStatistics(this.index);
        List<Synapse> synapses = c.getSynapses(this);
        for (Synapse s : synapses) {
            s.setPermanence(c, perms[s.getInputIndex()]);
            if (!(perms[s.getInputIndex()] >= c.getSynPermConnected())) continue;
            c.getConnectedCounts().set(1, this.index, s.getInputIndex());
        }
    }

    public void setPermanences(Connections c, double[] perms, int[] inputIndexes) {
        this.pool.resetConnections();
        c.getConnectedCounts().clearStatistics(this.index);
        for (int i = 0; i < inputIndexes.length; ++i) {
            this.pool.setPermanence(c, this.pool.getSynapseWithInput(inputIndexes[i]), perms[i]);
            if (!(perms[i] >= c.getSynPermConnected())) continue;
            c.getConnectedCounts().set(1, this.index, i);
        }
    }

    public void setConnectedSynapsesForTest(Connections c, int[] connectedIndexes) {
        Pool pool = this.createPool(c, connectedIndexes);
        c.getPotentialPools().set(this.index, pool);
    }

    public int[] getConnectedSynapsesDense(Connections c) {
        return c.getPotentialPools().get(this.index).getDenseConnections(c);
    }

    public int[] getConnectedSynapsesSparse(Connections c) {
        return c.getPotentialPools().get(this.index).getSparseConnections();
    }
}

