/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.ProximalDendrite;
import org.numenta.nupic.model.Segment;

public class Synapse {
    private Cell sourceCell;
    private Segment segment;
    private Pool pool;
    private int synapseIndex;
    private int inputIndex;
    private double permanence;

    public Synapse() {
    }

    public Synapse(Connections c, Cell sourceCell, Segment segment, Pool pool, int index, int inputIndex) {
        this.sourceCell = sourceCell;
        this.segment = segment;
        this.pool = pool;
        this.synapseIndex = index;
        this.inputIndex = inputIndex;
        if (sourceCell != null) {
            sourceCell.addReceptorSynapse(c, this);
        }
    }

    public int getIndex() {
        return this.synapseIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public double getPermanence() {
        return this.permanence;
    }

    public void setPermanence(Connections c, double perm) {
        this.permanence = perm;
        if (this.sourceCell == null) {
            this.pool.updatePool(c, this, perm);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    public Cell getPresynapticCell() {
        return this.sourceCell;
    }

    public void destroy(Connections c) {
        this.pool.destroySynapse(this);
        if (this.sourceCell != null) {
            c.getSynapses((DistalDendrite)this.segment).remove(this);
            this.sourceCell.removeReceptorSynapse(c, this);
        } else {
            c.getSynapses((ProximalDendrite)this.segment).remove(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("synapse: [ synIdx=").append(this.synapseIndex).append(", inIdx=").append(this.inputIndex).append(", sgmtIdx=").append(this.segment.getIndex());
        if (this.sourceCell != null) {
            sb.append(", srcCellIdx=").append(this.sourceCell.getIndex());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

