/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.monitor.mixin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.numenta.nupic.monitor.mixin.BoolsTrace;
import org.numenta.nupic.monitor.mixin.MonitorMixinBase;
import org.numenta.nupic.monitor.mixin.Trace;
import org.numenta.nupic.util.ArrayUtils;

public class Metric {
    public MonitorMixinBase monitor;
    public String title;
    public double min;
    public double max;
    public double sum;
    public double mean = Double.NaN;
    public double variance;
    public double standardDeviation;

    public Metric(MonitorMixinBase monitor, String title, List<? extends Number> l) {
        this.monitor = monitor;
        this.title = title;
        this.computeStats(l);
    }

    public static <T extends Trace<? extends Number>> Metric createFromTrace(T trace, BoolsTrace excludeResets) {
        List data = trace.items;
        if (excludeResets != null) {
            data = new ArrayList();
            for (int k = 0; k < trace.items.size(); ++k) {
                if (((Boolean)excludeResets.items.get(k)).booleanValue()) continue;
                Number n = (Number)trace.items.get(k);
                data.add(n);
            }
        }
        return new Metric(trace.monitor, trace.title, data);
    }

    public Metric copy() {
        Metric metric = new Metric(this.monitor, this.title, Collections.emptyList());
        metric.min = this.min;
        metric.max = this.max;
        metric.sum = this.sum;
        metric.mean = this.mean;
        metric.variance = this.variance;
        metric.standardDeviation = this.standardDeviation;
        return metric;
    }

    public String prettyPrintTitle() {
        Object[] objectArray;
        String string = this.monitor.mmGetName() == null ? "%s" : "[%s] %s";
        if (this.monitor.mmGetName() == null) {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = this.title;
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = this.monitor.mmGetName();
            objectArray = stringArray;
            stringArray[1] = this.title;
        }
        return String.format(string, objectArray);
    }

    public void computeStats(List<? extends Number> l) {
        double s;
        double v;
        double d;
        if (l.size() < 1) {
            return;
        }
        double[] doubs = null;
        if (Integer.class.isAssignableFrom(l.get(0).getClass())) {
            doubs = ArrayUtils.toDoubleArray(ArrayUtils.toPrimitive(l.toArray(new Integer[l.size()])));
        } else if (Double.class.isAssignableFrom(l.get(0).getClass())) {
            doubs = ArrayUtils.toPrimitive(l.toArray(new Double[l.size()]));
        }
        this.min = ArrayUtils.min(doubs);
        this.max = ArrayUtils.max(doubs);
        this.sum = ArrayUtils.sum(doubs);
        this.mean = d = ArrayUtils.average(doubs);
        this.variance = v = ArrayUtils.variance(doubs, d);
        this.standardDeviation = s = v > 0.0 ? Math.sqrt(v) : 0.0;
    }

    public double[] getStats(int sigFigs) {
        if (Double.isNaN(this.mean)) {
            return new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        }
        return new double[]{BigDecimal.valueOf(this.mean).setScale(sigFigs, 4).doubleValue(), BigDecimal.valueOf(this.standardDeviation).setScale(sigFigs, 4).doubleValue(), BigDecimal.valueOf(this.min).setScale(sigFigs, 4).doubleValue(), BigDecimal.valueOf(this.max).setScale(sigFigs, 4).doubleValue(), BigDecimal.valueOf(this.sum).setScale(sigFigs, 4).doubleValue()};
    }
}

