/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.encoders.MultiEncoder;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.Layer;
import org.numenta.nupic.network.Region;
import org.numenta.nupic.network.sensor.HTMSensor;
import rx.Observable;
import rx.Subscriber;

public class Network {
    private String name;
    private Parameters parameters;
    private HTMSensor<?> sensor;
    private MultiEncoder encoder;
    private Region head;
    private Region tail;
    private Region sensorRegion;
    private boolean isLearn = true;
    private boolean isThreadRunning;
    private List<Region> regions = new ArrayList<Region>();

    public Network(String name, Parameters parameters) {
        this.name = name;
        this.parameters = parameters;
        if (parameters == null) {
            throw new IllegalArgumentException("Network Parameters were null.");
        }
    }

    public static Network create(String name, Parameters parameters) {
        return new Network(name, parameters);
    }

    public static Region createRegion(String name) {
        Network.checkName(name);
        Region r = new Region(name, null);
        return r;
    }

    public static Layer<?> createLayer(String name, Parameters p) {
        Network.checkName(name);
        return new Layer(name, null, p);
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        Region tail;
        if (this.regions.size() < 1) {
            throw new IllegalStateException("Nothing to start - 0 regions");
        }
        Region upstream = tail = this.regions.get(0);
        while ((upstream = upstream.getUpstreamRegion()) != null) {
            tail = upstream;
        }
        this.isThreadRunning = tail.start();
    }

    public boolean isThreadedOperation() {
        return this.isThreadRunning;
    }

    public void halt() {
        if (this.regions.size() == 1) {
            this.tail = this.regions.get(0);
        }
        this.tail.halt();
    }

    public void pause() {
        throw new UnsupportedOperationException("Pausing is not (yet) supported.");
    }

    public void setLearn(boolean isLearn) {
        this.isLearn = isLearn;
        for (Region r : this.regions) {
            r.setLearn(isLearn);
        }
    }

    public boolean isLearn() {
        return this.isLearn;
    }

    public Mode getMode() {
        return null;
    }

    public void reset() {
        for (Region r : this.regions) {
            r.reset();
        }
    }

    public void resetRecordNum() {
        for (Region r : this.regions) {
            r.resetRecordNum();
        }
    }

    public Observable<Inference> observe() {
        if (this.regions.size() == 1) {
            this.head = this.regions.get(0);
        }
        return this.head.observe();
    }

    public Region getHead() {
        if (this.regions.size() == 1) {
            this.head = this.regions.get(0);
        }
        return this.head;
    }

    public Region getTail() {
        if (this.regions.size() == 1) {
            this.tail = this.regions.get(0);
        }
        return this.tail;
    }

    public Iterator<Region> iterator() {
        return this.getRegions().iterator();
    }

    public <T> void compute(T input) {
        if (this.tail == null && this.regions.size() == 1) {
            this.tail = this.regions.get(0);
        }
        if (this.head == null) {
            this.addDummySubscriber();
        }
        this.tail.compute(input);
    }

    public <T> Inference computeImmediate(T input) {
        if (this.isThreadRunning) {
            throw new IllegalStateException("Cannot call computeImmediate() when Network has been started.");
        }
        if (this.tail == null && this.regions.size() == 1) {
            this.tail = this.regions.get(0);
        }
        if (this.head == null) {
            this.addDummySubscriber();
        }
        this.tail.compute(input);
        return this.head.getHead().getInference();
    }

    private void addDummySubscriber() {
        this.observe().subscribe((Subscriber)new Subscriber<Inference>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Inference i) {
            }
        });
    }

    public Network connect(String regionSink, String regionSource) {
        Region source = this.lookup(regionSource);
        if (source == null) {
            throw new IllegalArgumentException("Region with name: " + regionSource + " not added to Network.");
        }
        Region sink = this.lookup(regionSink);
        if (sink == null) {
            throw new IllegalArgumentException("Region with name: " + regionSink + " not added to Network.");
        }
        sink.connect(source);
        this.tail = this.tail == null ? source : this.tail;
        this.head = this.head == null ? sink : this.head;
        Region bottom = source;
        while ((bottom = bottom.getUpstreamRegion()) != null) {
            this.tail = bottom;
        }
        Region top = sink;
        while ((top = top.getDownstreamRegion()) != null) {
            this.head = top;
        }
        return this;
    }

    public Network add(Region region) {
        this.regions.add(region);
        region.setNetwork(this);
        return this;
    }

    public List<Region> getRegions() {
        return new ArrayList<Region>(this.regions);
    }

    public void setSensorRegion(Region r) {
        this.sensorRegion = r;
    }

    public Region getSensorRegion() {
        return this.sensorRegion;
    }

    public Region lookup(String regionName) {
        for (Region r : this.regions) {
            if (!r.getName().equals(regionName)) continue;
            return r;
        }
        return null;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setSensor(HTMSensor<?> sensor) {
        this.sensor = sensor;
        this.sensor.initEncoder(this.parameters);
    }

    public HTMSensor<?> getSensor() {
        return this.sensor;
    }

    public void setEncoder(MultiEncoder e) {
        this.encoder = e;
    }

    public MultiEncoder getEncoder() {
        return this.encoder;
    }

    private static void checkName(String name) {
        if (name.indexOf(":") != -1) {
            throw new IllegalArgumentException("\":\" is a reserved character.");
        }
    }

    public static enum Mode {
        MANUAL,
        AUTO,
        REACTIVE;

    }
}

