/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.joda.time.format.DateTimeFormatter;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.encoders.AdaptiveScalarEncoder;
import org.numenta.nupic.encoders.CategoryEncoder;
import org.numenta.nupic.encoders.CoordinateEncoder;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.DeltaEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.EncoderTuple;
import org.numenta.nupic.encoders.GeospatialCoordinateEncoder;
import org.numenta.nupic.encoders.LogEncoder;
import org.numenta.nupic.encoders.MultiEncoder;
import org.numenta.nupic.encoders.RandomDistributedScalarEncoder;
import org.numenta.nupic.encoders.SDRCategoryEncoder;
import org.numenta.nupic.encoders.SDRPassThroughEncoder;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.network.sensor.Header;
import org.numenta.nupic.network.sensor.MetaStream;
import org.numenta.nupic.network.sensor.Sensor;
import org.numenta.nupic.network.sensor.SensorParams;
import org.numenta.nupic.util.Tuple;

public class HTMSensor<T>
implements Sensor<T> {
    private Sensor<T> delegate;
    private Header header;
    private Parameters localParameters;
    private MultiEncoder encoder;
    private Stream<int[]> outputStream;
    private List<int[]> output;
    private InputMap inputMap;
    private TIntObjectMap<Encoder<?>> indexToEncoderMap;
    private TObjectIntHashMap<String> indexFieldMap = new TObjectIntHashMap();
    private Iterator<int[]> mainIterator;
    private List<LinkedList<int[]>> fanOuts = new ArrayList<LinkedList<int[]>>();
    private Lock criticalAccessLock = new ReentrantLock();

    public HTMSensor(Sensor<T> sensor) {
        this.delegate = sensor;
        this.header = new Header(sensor.getInputStream().getMeta());
        if (this.header == null || this.header.size() < 3) {
            throw new IllegalStateException("Header must always be present; and have 3 lines.");
        }
        this.createEncoder();
    }

    private void createEncoder() {
        Map encoderSettings;
        this.encoder = MultiEncoder.builder().name("MultiEncoder").build();
        if (this.localParameters != null && (encoderSettings = (Map)this.localParameters.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP)) != null && !encoderSettings.isEmpty()) {
            this.initEncoders(encoderSettings);
            this.makeIndexEncoderMap();
        }
    }

    private void makeIndexEncoderMap() {
        this.indexToEncoderMap = new TIntObjectHashMap();
        int size = this.header.getFieldNames().size();
        block7: for (int i = 0; i < size; ++i) {
            switch (this.header.getFieldTypes().get(i)) {
                case DATETIME: {
                    Optional<DateEncoder> de = this.getDateEncoder(this.encoder);
                    if (de.isPresent()) {
                        this.indexToEncoderMap.put(i, (Object)de.get());
                        continue block7;
                    }
                    throw new IllegalArgumentException("DateEncoder never initialized: " + this.header.getFieldNames().get(i));
                }
                case BOOLEAN: 
                case FLOAT: 
                case INTEGER: {
                    Optional<Encoder<?>> ne = this.getNumberEncoder(this.encoder);
                    if (ne.isPresent()) {
                        this.indexToEncoderMap.put(i, ne.get());
                        continue block7;
                    }
                    throw new IllegalArgumentException("Number (or Boolean) encoder never initialized: " + this.header.getFieldNames().get(i));
                }
                case LIST: 
                case STRING: {
                    Optional<Encoder<?>> ce = this.getCategoryEncoder(this.encoder);
                    if (ce.isPresent()) {
                        this.indexToEncoderMap.put(i, ce.get());
                        continue block7;
                    }
                    throw new IllegalArgumentException("Category encoder never initialized: " + this.header.getFieldNames().get(i));
                }
                case COORD: 
                case GEO: {
                    Optional<Encoder<?>> ge = this.getCoordinateEncoder(this.encoder);
                    if (ge.isPresent()) {
                        this.indexToEncoderMap.put(i, ge.get());
                        continue block7;
                    }
                    throw new IllegalArgumentException("Coordinate encoder never initialized: " + this.header.getFieldNames().get(i));
                }
                case SARR: 
                case DARR: {
                    Optional<SDRPassThroughEncoder> spte = this.getSDRPassThroughEncoder(this.encoder);
                    if (spte.isPresent()) {
                        this.indexToEncoderMap.put(i, (Object)spte.get());
                        continue block7;
                    }
                    throw new IllegalArgumentException("SDRPassThroughEncoder encoder never initialized: " + this.header.getFieldNames().get(i));
                }
            }
        }
    }

    @Override
    public SensorParams getParams() {
        return this.delegate.getParams();
    }

    @Override
    public <K> MetaStream<K> getInputStream() {
        return this.delegate.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<int[]> getOutputStream() {
        if (this.isTerminal()) {
            throw new IllegalStateException("Stream is already \"terminal\" (operated upon or empty)");
        }
        MultiEncoder encoder = this.getEncoder();
        if (encoder == null) {
            throw new IllegalStateException("setLocalParameters(Parameters) must be called before calling this method.");
        }
        Stream<int[]> retVal = null;
        try {
            this.criticalAccessLock.lock();
            String[] fieldNames = this.getFieldNames();
            FieldMetaType[] fieldTypes = this.getFieldTypes();
            if (this.outputStream == null) {
                if (this.indexFieldMap.isEmpty()) {
                    for (int i = 0; i < fieldNames.length; ++i) {
                        this.indexFieldMap.put((Object)fieldNames[i], i);
                    }
                }
                if (this.inputMap == null) {
                    this.inputMap = new InputMap();
                    InputMap.access$502(this.inputMap, fieldTypes);
                }
                boolean isParallel = this.delegate.getInputStream().isParallel();
                this.output = new ArrayList<int[]>();
                this.outputStream = this.delegate.getInputStream().map(l -> {
                    String[] arr = (String[])l;
                    InputMap.access$602(this.inputMap, arr);
                    return this.input(arr, fieldNames, fieldTypes, this.output, isParallel);
                });
                this.mainIterator = this.outputStream.iterator();
            }
            LinkedList<int[]> l2 = new LinkedList<int[]>();
            this.fanOuts.add(l2);
            Copy copy = new Copy(l2);
            retVal = StreamSupport.stream(Spliterators.spliteratorUnknownSize(copy, 1296), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.criticalAccessLock.unlock();
        }
        return retVal;
    }

    public boolean hasNext() {
        return this.mainIterator.hasNext();
    }

    private String[] getFieldNames() {
        return this.header.getFieldNames().toArray(new String[this.header.getFieldNames().size()]);
    }

    private FieldMetaType[] getFieldTypes() {
        return this.header.getFieldTypes().toArray(new FieldMetaType[this.header.getFieldTypes().size()]);
    }

    private int[] input(String[] arr, String[] fieldNames, FieldMetaType[] fieldTypes, List<int[]> outputStreamSource, boolean isParallel) {
        this.processHeader(arr);
        int[] encoding = this.encoder.encode(this.inputMap);
        if (isParallel) {
            outputStreamSource.set(HTMSensor.padTo(Integer.parseInt(arr[0]), outputStreamSource), encoding);
        }
        return encoding;
    }

    public Map<String, Object> getInputMap() {
        return this.inputMap;
    }

    static int padTo(int i, List<?> l) {
        for (int x = l.size(); x < i + 1; ++x) {
            l.add(null);
        }
        return i;
    }

    private Optional<Encoder<?>> getCoordinateEncoder(MultiEncoder enc) {
        for (EncoderTuple t : enc.getEncoders(enc)) {
            if (!(t.getEncoder() instanceof CoordinateEncoder) && !(t.getEncoder() instanceof GeospatialCoordinateEncoder)) continue;
            return Optional.of(t.getEncoder());
        }
        return Optional.empty();
    }

    private Optional<Encoder<?>> getCategoryEncoder(MultiEncoder enc) {
        for (EncoderTuple t : enc.getEncoders(enc)) {
            if (!(t.getEncoder() instanceof CategoryEncoder) && !(t.getEncoder() instanceof SDRCategoryEncoder)) continue;
            return Optional.of(t.getEncoder());
        }
        return Optional.empty();
    }

    private Optional<DateEncoder> getDateEncoder(MultiEncoder enc) {
        for (EncoderTuple t : enc.getEncoders(enc)) {
            if (!(t.getEncoder() instanceof DateEncoder)) continue;
            return Optional.of((DateEncoder)t.getEncoder());
        }
        return Optional.empty();
    }

    private Optional<SDRPassThroughEncoder> getSDRPassThroughEncoder(MultiEncoder enc) {
        for (EncoderTuple t : enc.getEncoders(enc)) {
            if (!(t.getEncoder() instanceof SDRPassThroughEncoder)) continue;
            return Optional.of((SDRPassThroughEncoder)t.getEncoder());
        }
        return Optional.empty();
    }

    private Optional<Encoder<?>> getNumberEncoder(MultiEncoder enc) {
        for (EncoderTuple t : enc.getEncoders(enc)) {
            if (!(t.getEncoder() instanceof RandomDistributedScalarEncoder) && !(t.getEncoder() instanceof ScalarEncoder) && !(t.getEncoder() instanceof AdaptiveScalarEncoder) && !(t.getEncoder() instanceof LogEncoder) && !(t.getEncoder() instanceof DeltaEncoder)) continue;
            return Optional.of(t.getEncoder());
        }
        return Optional.empty();
    }

    public boolean isTerminal() {
        return this.delegate.getInputStream().isTerminal();
    }

    @Override
    public Header getMetaInfo() {
        return this.header;
    }

    public void initEncoder(Parameters p) {
        this.localParameters = p;
        Map encoderSettings = (Map)p.getParameterByKey(Parameters.KEY.FIELD_ENCODING_MAP);
        if (encoderSettings != null && this.encoder.getEncoders().isEmpty() && this.indexToEncoderMap == null) {
            this.initEncoders(encoderSettings);
            this.makeIndexEncoderMap();
        }
    }

    public Parameters getLocalParameters() {
        return this.localParameters;
    }

    private void processHeader(String[] entry) {
        this.header.process(entry);
    }

    private void initEncoders(Map<String, Map<String, Object>> encoderSettings) {
        if (this.encoder instanceof MultiEncoder) {
            if (encoderSettings == null || encoderSettings.isEmpty()) {
                throw new IllegalArgumentException("Cannot initialize this Sensor's MultiEncoder with a null settings");
            }
            ArrayList<String> sortedFields = new ArrayList<String>(encoderSettings.keySet());
            Collections.sort(sortedFields);
            for (String field : sortedFields) {
                Map<String, Object> params = encoderSettings.get(field);
                if (!params.containsKey("fieldName")) {
                    throw new IllegalArgumentException("Missing fieldname for encoder " + field);
                }
                String fieldName = (String)params.get("fieldName");
                if (!params.containsKey("encoderType")) {
                    throw new IllegalArgumentException("Missing type for encoder " + field);
                }
                String encoderType = (String)params.get("encoderType");
                Encoder.Builder<?, ?> builder = this.encoder.getBuilder(encoderType);
                if (encoderType.equals("SDRCategoryEncoder")) {
                    this.encoder.setValue(builder, "n", params.get("n"));
                    this.encoder.setValue(builder, "w", params.get("w"));
                    this.encoder.setValue(builder, "forced", params.get("forced"));
                    this.encoder.setValue(builder, "categoryList", params.get("categoryList"));
                } else if (encoderType.equals("DateEncoder")) {
                    this.configureDateBuilder(encoderSettings, (DateEncoder.Builder)builder);
                } else if (encoderType.equals("GeospatialCoordinateEncoder")) {
                    this.configureGeoBuilder(encoderSettings, (GeospatialCoordinateEncoder.Builder)builder);
                } else {
                    for (String param : params.keySet()) {
                        if (param.equals("fieldName") || param.equals("encoderType") || param.equals("fieldType") || param.equals("fieldEncodings")) continue;
                        this.encoder.setValue(builder, param, params.get(param));
                    }
                }
                this.encoder.addEncoder(fieldName, (Encoder)builder.build());
            }
        }
    }

    private void configureDateBuilder(Map<String, Map<String, Object>> encoderSettings, DateEncoder.Builder b) {
        Map<String, Object> dateEncoderSettings = this.getEncoderMap(encoderSettings, "DateEncoder");
        if (dateEncoderSettings == null) {
            throw new IllegalStateException("Input requires missing DateEncoder settings mapping.");
        }
        for (String key : dateEncoderSettings.keySet()) {
            if (key.equals("fieldName") || key.equals("encoderType") || key.equals("fieldType") || key.equals("fieldEncodings")) continue;
            if (!(key.equals("season") || key.equals("dayOfWeek") || key.equals("weekend") || key.equals("holiday") || key.equals("timeOfDay") || key.equals("customDays") || key.equals("formatPattern") || key.equals("dateFormatter"))) {
                this.encoder.setValue(b, key, dateEncoderSettings.get(key));
                continue;
            }
            if (key.equals("formatPattern")) {
                b.formatPattern((String)dateEncoderSettings.get(key));
                continue;
            }
            if (key.equals("dateFormatter")) {
                b.formatter((DateTimeFormatter)dateEncoderSettings.get(key));
                continue;
            }
            this.setDateFieldBits(b, dateEncoderSettings, key);
        }
    }

    private Map<String, Object> getEncoderMap(Map<String, Map<String, Object>> encoderSettings, String encoderType) {
        for (String key : encoderSettings.keySet()) {
            String keyType = null;
            keyType = (String)encoderSettings.get(key).get("encoderType");
            if (keyType == null || !keyType.equals(encoderType)) continue;
            return encoderSettings.get(key);
        }
        return null;
    }

    private void setDateFieldBits(DateEncoder.Builder b, Map<String, Object> m, String key) {
        Tuple t = (Tuple)m.get(key);
        switch (key) {
            case "season": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.season((Integer)t.get(0), (Double)t.get(1));
                    break;
                }
                b.season((Integer)t.get(0));
                break;
            }
            case "dayOfWeek": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.dayOfWeek((Integer)t.get(0), (Double)t.get(1));
                    break;
                }
                b.dayOfWeek((Integer)t.get(0));
                break;
            }
            case "weekend": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.weekend((Integer)t.get(0), (Double)t.get(1));
                    break;
                }
                b.weekend((Integer)t.get(0));
                break;
            }
            case "holiday": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.holiday((Integer)t.get(0), (Double)t.get(1));
                    break;
                }
                b.holiday((Integer)t.get(0));
                break;
            }
            case "timeOfDay": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.timeOfDay((Integer)t.get(0), (Double)t.get(1));
                    break;
                }
                b.timeOfDay((Integer)t.get(0));
                break;
            }
            case "customDays": {
                if (t.size() > 1 && (Double)t.get(1) > 0.0) {
                    b.customDays((Integer)t.get(0), (List)t.get(1));
                    break;
                }
                b.customDays((Integer)t.get(0));
                break;
            }
        }
    }

    public <K> MultiEncoder getEncoder() {
        return this.encoder;
    }

    private void configureGeoBuilder(Map<String, Map<String, Object>> encoderSettings, GeospatialCoordinateEncoder.Builder builder) {
        Map<String, Object> geoEncoderSettings = this.getEncoderMap(encoderSettings, "GeospatialCoordinateEncoder");
        if (geoEncoderSettings == null) {
            throw new IllegalStateException("Input requires missing GeospatialCoordinateEncoder settings mapping.");
        }
        for (String key : geoEncoderSettings.keySet()) {
            if (key.equals("fieldName") || key.equals("encoderType") || key.equals("fieldType") || key.equals("fieldEncodings")) continue;
            if (!key.equals("scale") && !key.equals("timestep")) {
                this.encoder.setValue(builder, key, geoEncoderSettings.get(key));
                continue;
            }
            this.setGeoFieldBits(builder, geoEncoderSettings, key);
        }
    }

    private void setGeoFieldBits(GeospatialCoordinateEncoder.Builder b, Map<String, Object> m, String key) {
        String t = (String)m.get(key);
        switch (key) {
            case "scale": {
                b.scale(Integer.parseInt(t));
                break;
            }
            case "timestep": {
                b.timestep(Integer.parseInt(t));
                break;
            }
        }
    }

    class InputMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;
        private FieldMetaType[] fTypes;
        private String[] arr;

        InputMap() {
        }

        @Override
        public Object get(Object key) {
            int idx = HTMSensor.this.indexFieldMap.get(key);
            return this.fTypes[idx].decodeType(this.arr[idx + 1], (Encoder)HTMSensor.this.indexToEncoderMap.get(idx));
        }

        @Override
        public boolean containsKey(Object key) {
            return HTMSensor.this.indexFieldMap.get(key) != -1;
        }

        static /* synthetic */ FieldMetaType[] access$502(InputMap x0, FieldMetaType[] x1) {
            x0.fTypes = x1;
            return x1;
        }

        static /* synthetic */ String[] access$602(InputMap x0, String[] x1) {
            x0.arr = x1;
            return x1;
        }
    }

    private class Copy
    implements Iterator<int[]> {
        private LinkedList<int[]> list;

        Copy(LinkedList<int[]> l) {
            this.list = l;
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty() || HTMSensor.this.mainIterator.hasNext();
        }

        @Override
        public int[] next() {
            if (this.list.isEmpty()) {
                HTMSensor.this.criticalAccessLock.lock();
                int[] next = (int[])HTMSensor.this.mainIterator.next();
                for (List l : HTMSensor.this.fanOuts) {
                    l.add(next);
                }
                HTMSensor.this.criticalAccessLock.unlock();
            }
            return this.list.remove(0);
        }
    }
}

