/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.SparseBinaryMatrixSupport;

public class LowMemorySparseBinaryMatrix
extends SparseBinaryMatrixSupport {
    public LowMemorySparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public LowMemorySparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    @Override
    public Object getSlice(int ... coordinates) {
        int[] dimensions = this.getDimensions();
        if (coordinates.length >= dimensions.length) {
            this.sliceError(coordinates);
        }
        int sliceDimensionsLength = dimensions.length - coordinates.length;
        int[] sliceDimensions = (int[])Array.newInstance(Integer.TYPE, sliceDimensionsLength);
        for (int i = coordinates.length; i < dimensions.length; ++i) {
            sliceDimensions[i - coordinates.length] = dimensions[i];
        }
        int[] elementCoordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
        Object slice = Array.newInstance(Integer.TYPE, sliceDimensions);
        if (coordinates.length + 1 == dimensions.length) {
            for (int i = 0; i < dimensions[coordinates.length]; ++i) {
                elementCoordinates[coordinates.length] = i;
                Array.set(slice, i, this.get(elementCoordinates));
            }
        } else {
            for (int i = 0; i < dimensions[sliceDimensionsLength]; ++i) {
                elementCoordinates[coordinates.length] = i;
                Array.set(slice, i, this.getSlice(elementCoordinates));
            }
        }
        return slice;
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        if (this.dimensions.length > 1) {
            for (int i = 0; i < this.dimensions[0]; ++i) {
                for (int j = 0; j < this.dimensions[1]; ++j) {
                    int n = i;
                    results[n] = results[n] + inputVector[j] * this.get(i, j);
                }
            }
        } else {
            int i;
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[0] = results[0] + inputVector[i] * this.get(i);
            }
            for (i = 0; i < this.dimensions[0]; ++i) {
                results[i] = results[0];
            }
        }
    }

    @Override
    public LowMemorySparseBinaryMatrix set(int value, int ... coordinates) {
        super.set(value, coordinates);
        this.updateTrueCounts(coordinates);
        return this;
    }

    @Override
    public LowMemorySparseBinaryMatrix setForTest(int index, int value) {
        if (value > 1) {
            super.setForTest(index, value);
        }
        return this;
    }

    private void updateTrueCounts(int ... coordinates) {
        Object slice = this.getSlice(coordinates[0]);
        int sum = ArrayUtils.aggregateArray(slice);
        this.setTrueCount(coordinates[0], sum);
    }

    @Override
    public LowMemorySparseBinaryMatrix set(int index, Object value) {
        super.set(index, (int)((Integer)value));
        return this;
    }
}

