/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.util.SortedSet;
import java.util.TreeSet;
import org.numenta.nupic.util.SparseMatrixSupport;

public class SetSparseMatrix
extends SparseMatrixSupport<Integer> {
    private SortedSet<Integer> indexes = new TreeSet<Integer>();

    public SetSparseMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public SetSparseMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    @Override
    protected int[] values() {
        return this.indexes.stream().mapToInt(i -> i).toArray();
    }

    public SetSparseMatrix set(int[] coordinates, Integer value) {
        return this.set(this.computeIndex(coordinates), value);
    }

    @Override
    public Integer get(int index) {
        return this.indexes.contains(index) ? 0 : 1;
    }

    public SetSparseMatrix set(int index, Integer value) {
        if (value > 0) {
            this.indexes.add(index);
        }
        return this;
    }
}

