/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.SparseBinaryMatrixSupport;

public class SparseBinaryMatrix
extends SparseBinaryMatrixSupport {
    private Object backingArray;

    public SparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.backingArray = Array.newInstance(Integer.TYPE, dimensions);
    }

    private void back(int val, int ... coordinates) {
        ArrayUtils.setValue(this.backingArray, val, coordinates);
        this.setTrueCount(coordinates[0], ArrayUtils.aggregateArray(((Object[])this.backingArray)[coordinates[0]]));
    }

    @Override
    public Object getSlice(int ... coordinates) {
        Object slice = this.backingArray;
        for (int i = 0; i < coordinates.length; ++i) {
            slice = Array.get(slice, coordinates[i]);
        }
        if (!slice.getClass().isArray()) {
            this.sliceError(coordinates);
        }
        return slice;
    }

    @Override
    public void rightVecSumAtNZ(int[] inputVector, int[] results) {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            int[] slice = (int[])(this.dimensions.length > 1 ? this.getSlice(i) : this.backingArray);
            for (int j = 0; j < slice.length; ++j) {
                int n = i;
                results[n] = results[n] + inputVector[j] * slice[j];
            }
        }
    }

    @Override
    public SparseBinaryMatrixSupport set(int index, int value) {
        int[] coordinates = this.computeCoordinates(index);
        return this.set(value, coordinates);
    }

    @Override
    public SparseBinaryMatrixSupport set(int value, int ... coordinates) {
        super.set(value, coordinates);
        this.back(value, coordinates);
        return this;
    }

    @Override
    public SparseBinaryMatrixSupport set(int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    @Override
    public void clearStatistics(int row) {
        super.clearStatistics(row);
        int[] slice = (int[])Array.get(this.backingArray, row);
        Arrays.fill(slice, 0);
    }

    @Override
    public SparseBinaryMatrixSupport set(int index, Object value) {
        this.set(index, (int)((Integer)value));
        return this;
    }
}

