/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import org.numenta.nupic.util.SparseMatrixSupport;

public abstract class SparseBinaryMatrixSupport
extends SparseMatrixSupport {
    private TIntIntMap sparseMap = new TIntIntHashMap();
    private int[] trueCounts;

    public SparseBinaryMatrixSupport(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseBinaryMatrixSupport(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.trueCounts = new int[dimensions[0]];
    }

    public abstract Object getSlice(int ... var1);

    protected void sliceError(int ... coordinates) {
        throw new IllegalArgumentException("This method only returns the array holding the specified index: " + Arrays.toString(coordinates));
    }

    public abstract void rightVecSumAtNZ(int[] var1, int[] var2);

    public SparseBinaryMatrixSupport set(int index, int value) {
        int[] coordinates = this.computeCoordinates(index);
        return this.set(value, coordinates);
    }

    public SparseBinaryMatrixSupport set(int value, int ... coordinates) {
        this.sparseMap.put(this.computeIndex(coordinates), value);
        return this;
    }

    public SparseBinaryMatrixSupport set(int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    @Override
    public Integer get(int ... coordinates) {
        return this.get(this.computeIndex(coordinates));
    }

    @Override
    public Integer get(int index) {
        return this.sparseMap.get(index);
    }

    public SparseBinaryMatrixSupport setForTest(int index, int value) {
        this.sparseMap.put(index, value);
        return this;
    }

    public SparseBinaryMatrixSupport set(int[] indexes, int[] values, boolean isTest) {
        for (int i = 0; i < indexes.length; ++i) {
            if (isTest) {
                this.setForTest(indexes[i], values[i]);
                continue;
            }
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    public int getTrueCount(int index) {
        return this.trueCounts[index];
    }

    public void setTrueCount(int index, int count) {
        this.trueCounts[index] = count;
    }

    public int[] getTrueCounts() {
        return this.trueCounts;
    }

    public void clearStatistics(int row) {
        this.trueCounts[row] = 0;
    }

    protected int[] values() {
        return this.sparseMap.values();
    }

    @Override
    public int getIntValue(int ... coordinates) {
        return this.sparseMap.get(this.computeIndex(coordinates));
    }

    @Override
    public int getIntValue(int index) {
        return this.sparseMap.get(index);
    }

    @Override
    public int[] getSparseIndices() {
        return SparseBinaryMatrixSupport.reverse(this.sparseMap.keys());
    }

    public SparseBinaryMatrixSupport or(SparseBinaryMatrixSupport inputMatrix) {
        int[] mask = inputMatrix.getSparseIndices();
        int[] ones = new int[mask.length];
        Arrays.fill(ones, 1);
        return this.set(mask, ones);
    }

    public SparseBinaryMatrixSupport or(TIntCollection onBitIndexes) {
        int[] ones = new int[onBitIndexes.size()];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes.toArray(), ones);
    }

    public SparseBinaryMatrixSupport or(int[] onBitIndexes) {
        int[] ones = new int[onBitIndexes.length];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes, ones);
    }

    public boolean all(SparseBinaryMatrixSupport matrix) {
        return this.sparseMap.keySet().containsAll(matrix.sparseMap.keys());
    }

    public boolean all(TIntCollection onBits) {
        return this.sparseMap.keySet().containsAll(onBits);
    }

    public boolean all(int[] onBits) {
        return this.sparseMap.keySet().containsAll(onBits);
    }

    public boolean any(SparseBinaryMatrixSupport matrix) {
        for (int i : matrix.sparseMap.keys()) {
            if (!this.sparseMap.containsKey(i)) continue;
            return true;
        }
        return false;
    }

    public boolean any(TIntList onBits) {
        TIntIterator i = onBits.iterator();
        while (i.hasNext()) {
            if (!this.sparseMap.containsKey(i.next())) continue;
            return true;
        }
        return false;
    }

    public boolean any(int[] onBits) {
        for (int i : onBits) {
            if (!this.sparseMap.containsKey(i)) continue;
            return true;
        }
        return false;
    }
}

