/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import org.numenta.nupic.util.FlatMatrixSupport;
import org.numenta.nupic.util.SparseMatrix;
import org.numenta.nupic.util.TypeFactory;

public abstract class SparseMatrixSupport<T>
extends FlatMatrixSupport<T>
implements SparseMatrix<T> {
    public SparseMatrixSupport(int[] dimensions) {
        this(dimensions, false);
    }

    public SparseMatrixSupport(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    protected <S extends SparseMatrixSupport<T>> S set(int index, int value) {
        return null;
    }

    protected <S extends SparseMatrixSupport<T>> S set(int index, double value) {
        return null;
    }

    @Override
    public SparseMatrixSupport<T> set(int[] coordinates, T object) {
        return null;
    }

    protected <S extends SparseMatrixSupport<T>> S set(int value, int ... coordinates) {
        return null;
    }

    protected <S extends SparseMatrixSupport<T>> S set(double value, int ... coordinates) {
        return null;
    }

    protected T getObject(int index) {
        return null;
    }

    protected int getIntValue(int index) {
        return -1;
    }

    protected double getDoubleValue(int index) {
        return -1.0;
    }

    protected abstract <V> V values();

    @Override
    public T get(int ... coordinates) {
        return null;
    }

    protected int getIntValue(int ... coordinates) {
        return -1;
    }

    protected double getDoubleValue(int ... coordinates) {
        return -1.0;
    }

    @Override
    public int[] getSparseIndices() {
        return null;
    }

    @Override
    public int[] get1DIndexes() {
        TIntArrayList results = new TIntArrayList(this.getMaxIndex() + 1);
        this.visit(this.getDimensions(), 0, new int[this.getNumDimensions()], (TIntList)results);
        return results.toArray();
    }

    private void visit(int[] bounds, int currentDimension, int[] p, TIntList results) {
        for (int i = 0; i < bounds[currentDimension]; ++i) {
            p[currentDimension] = i;
            if (currentDimension == p.length - 1) {
                results.add(this.computeIndex(p));
                continue;
            }
            this.visit(bounds, currentDimension + 1, p, results);
        }
    }

    @Override
    public T[] asDense(TypeFactory<T> factory) {
        int[] dimensions = this.getDimensions();
        Object[] retVal = (Object[])Array.newInstance(factory.typeClass(), dimensions);
        this.fill(factory, 0, dimensions, dimensions[0], retVal);
        return retVal;
    }

    protected Object[] fill(TypeFactory<T> f, int dimensionIndex, int[] dimensions, int count, Object[] arr) {
        if (dimensions.length == 1) {
            for (int i = 0; i < count; ++i) {
                arr[i] = f.make(this.getDimensions());
            }
            return arr;
        }
        for (int i = 0; i < count; ++i) {
            int[] inner = this.copyInnerArray(dimensions);
            Object[] r = (Object[])Array.newInstance(f.typeClass(), inner);
            arr[i] = this.fill(f, dimensionIndex + 1, inner, this.getDimensions()[dimensionIndex + 1], r);
        }
        return arr;
    }
}

