/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import org.numenta.nupic.util.SparseMatrixSupport;

public class SparseObjectMatrix<T>
extends SparseMatrixSupport<T> {
    private TIntObjectMap<T> sparseMap = new TIntObjectHashMap();

    public SparseObjectMatrix(int[] dimensions) {
        super(dimensions, false);
    }

    public SparseObjectMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    @Override
    public SparseObjectMatrix<T> set(int index, T object) {
        this.sparseMap.put(index, object);
        return this;
    }

    @Override
    public SparseObjectMatrix<T> set(int[] coordinates, T object) {
        this.set(this.computeIndex(coordinates), (Object)object);
        return this;
    }

    @Override
    protected T[] values() {
        return this.sparseMap.values();
    }

    @Override
    public T getObject(int index) {
        return this.get(index);
    }

    @Override
    public T get(int ... coordinates) {
        return this.get(this.computeIndex(coordinates));
    }

    @Override
    public T get(int index) {
        return (T)this.sparseMap.get(index);
    }

    @Override
    public int[] getSparseIndices() {
        return SparseObjectMatrix.reverse(this.sparseMap.keys());
    }

    public String toString() {
        return Arrays.toString(this.getDimensions());
    }
}

