/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import java.util.LinkedHashSet;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;

public class ComputeCycle
implements Persistable {
    private static final long serialVersionUID = 1L;
    public Set<Cell> activeCells = new LinkedHashSet<Cell>();
    public Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    public Set<Cell> predictiveCells = new LinkedHashSet<Cell>();
    public Set<Cell> predictedInactiveCells = new LinkedHashSet<Cell>();
    public Set<Cell> matchingCells = new LinkedHashSet<Cell>();
    public Set<Column> successfullyPredictedColumns = new LinkedHashSet<Column>();
    public Set<DistalDendrite> activeSegments = new LinkedHashSet<DistalDendrite>();
    public Set<DistalDendrite> learningSegments = new LinkedHashSet<DistalDendrite>();
    public Set<DistalDendrite> matchingSegments = new LinkedHashSet<DistalDendrite>();

    public ComputeCycle() {
    }

    public ComputeCycle(Connections c) {
        this.activeCells = new LinkedHashSet<Cell>(c.getActiveCells());
        this.winnerCells = new LinkedHashSet<Cell>(c.getWinnerCells());
        this.predictiveCells = new LinkedHashSet<Cell>(c.getPredictiveCells());
        this.successfullyPredictedColumns = new LinkedHashSet<Column>(c.getSuccessfullyPredictedColumns());
        this.activeSegments = new LinkedHashSet<DistalDendrite>(c.getActiveSegments());
        this.learningSegments = new LinkedHashSet<DistalDendrite>(c.getLearningSegments());
    }

    public Set<Cell> activeCells() {
        return this.activeCells;
    }

    public Set<Cell> winnerCells() {
        return this.winnerCells;
    }

    public Set<Cell> predictiveCells() {
        return this.predictiveCells;
    }

    public Set<Column> successfullyPredictedColumns() {
        return this.successfullyPredictedColumns;
    }

    public Set<DistalDendrite> learningSegments() {
        return this.learningSegments;
    }

    public Set<DistalDendrite> activeSegments() {
        return this.activeSegments;
    }

    public Set<Cell> predictedInactiveCells() {
        return this.predictedInactiveCells;
    }

    public Set<DistalDendrite> matchingSegments() {
        return this.matchingSegments;
    }

    public Set<Cell> matchingCells() {
        return this.matchingCells;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activeCells == null ? 0 : this.activeCells.hashCode());
        result = 31 * result + (this.activeSegments == null ? 0 : this.activeSegments.hashCode());
        result = 31 * result + (this.learningSegments == null ? 0 : this.learningSegments.hashCode());
        result = 31 * result + (this.matchingCells == null ? 0 : this.matchingCells.hashCode());
        result = 31 * result + (this.matchingSegments == null ? 0 : this.matchingSegments.hashCode());
        result = 31 * result + (this.predictedInactiveCells == null ? 0 : this.predictedInactiveCells.hashCode());
        result = 31 * result + (this.predictiveCells == null ? 0 : this.predictiveCells.hashCode());
        result = 31 * result + (this.successfullyPredictedColumns == null ? 0 : this.successfullyPredictedColumns.hashCode());
        result = 31 * result + (this.winnerCells == null ? 0 : this.winnerCells.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeCycle other = (ComputeCycle)obj;
        if (this.activeCells == null ? other.activeCells != null : !this.activeCells.equals(other.activeCells)) {
            return false;
        }
        if (this.activeSegments == null ? other.activeSegments != null : !this.activeSegments.equals(other.activeSegments)) {
            return false;
        }
        if (this.learningSegments == null ? other.learningSegments != null : !this.learningSegments.equals(other.learningSegments)) {
            return false;
        }
        if (this.matchingCells == null ? other.matchingCells != null : !this.matchingCells.equals(other.matchingCells)) {
            return false;
        }
        if (this.matchingSegments == null ? other.matchingSegments != null : !this.matchingSegments.equals(other.matchingSegments)) {
            return false;
        }
        if (this.predictedInactiveCells == null ? other.predictedInactiveCells != null : !this.predictedInactiveCells.equals(other.predictedInactiveCells)) {
            return false;
        }
        if (this.predictiveCells == null ? other.predictiveCells != null : !this.predictiveCells.equals(other.predictiveCells)) {
            return false;
        }
        if (this.successfullyPredictedColumns == null ? other.successfullyPredictedColumns != null : !this.successfullyPredictedColumns.equals(other.successfullyPredictedColumns)) {
            return false;
        }
        return !(this.winnerCells == null ? other.winnerCells != null : !this.winnerCells.equals(other.winnerCells));
    }
}

