/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.ProximalDendrite;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.util.AbstractSparseBinaryMatrix;
import org.numenta.nupic.util.FlatMatrix;
import org.numenta.nupic.util.MersenneTwister;
import org.numenta.nupic.util.SparseMatrix;
import org.numenta.nupic.util.SparseObjectMatrix;

public class Connections
implements Persistable {
    private static final long serialVersionUID = 1L;
    private int potentialRadius = 16;
    private double potentialPct = 0.5;
    private boolean globalInhibition = false;
    private double localAreaDensity = -1.0;
    private double numActiveColumnsPerInhArea;
    private double stimulusThreshold = 0.0;
    private double synPermInactiveDec = 0.01;
    private double synPermActiveInc = 0.1;
    private double synPermConnected = 0.1;
    private double synPermBelowStimulusInc = this.synPermConnected / 10.0;
    private double minPctOverlapDutyCycles = 0.001;
    private double minPctActiveDutyCycles = 0.001;
    private double predictedSegmentDecrement = 0.0;
    private int dutyCyclePeriod = 1000;
    private double maxBoost = 10.0;
    private int spVerbosity = 0;
    private int numInputs = 1;
    private int numColumns = 1;
    private double synPermMin = 0.0;
    private double synPermMax = 1.0;
    private double synPermTrimThreshold = this.synPermActiveInc / 2.0;
    private int updatePeriod = 50;
    private double initConnectedPct = 0.5;
    private double version = 1.0;
    public int iterationNum = 0;
    public int iterationLearnNum = 0;
    protected SparseMatrix<?> inputMatrix;
    private FlatMatrix<Pool> potentialPools;
    private double[] tieBreaker;
    private AbstractSparseBinaryMatrix connectedCounts;
    private int inhibitionRadius = 0;
    private double[] overlapDutyCycles;
    private double[] activeDutyCycles;
    private double[] minOverlapDutyCycles;
    private double[] minActiveDutyCycles;
    private double[] boostFactors;
    protected Set<Cell> activeCells = new LinkedHashSet<Cell>();
    protected Set<Cell> winnerCells = new LinkedHashSet<Cell>();
    protected Set<Cell> predictiveCells = new LinkedHashSet<Cell>();
    protected Set<Cell> matchingCells = new LinkedHashSet<Cell>();
    protected Set<Column> successfullyPredictedColumns = new LinkedHashSet<Column>();
    protected Set<DistalDendrite> activeSegments = new LinkedHashSet<DistalDendrite>();
    protected Set<DistalDendrite> learningSegments = new LinkedHashSet<DistalDendrite>();
    protected Set<DistalDendrite> matchingSegments = new LinkedHashSet<DistalDendrite>();
    protected int[] columnDimensions = new int[]{2048};
    protected int cellsPerColumn = 32;
    protected int[] inputDimensions = new int[]{32, 32};
    private int activationThreshold = 13;
    private int learningRadius = 2048;
    private int minThreshold = 10;
    private int maxNewSynapseCount = 20;
    private double initialPermanence = 0.21;
    private double connectedPermanence = 0.5;
    private double permanenceIncrement = 0.1;
    private double permanenceDecrement = 0.1;
    private SparseObjectMatrix<Column> memory;
    private Cell[] cells;
    protected Map<Cell, LinkedHashSet<Synapse>> receptorSynapses;
    protected Map<Cell, List<DistalDendrite>> segments;
    protected Map<Segment, List<Synapse>> synapses;
    protected int segmentCounter = -1;
    protected int synapseCounter = -1;
    protected int seed = 42;
    protected Random random = new MersenneTwister(this.seed);
    protected double[] paOverlaps;

    public void setPAOverlaps(double[] overlaps) {
        this.paOverlaps = overlaps;
    }

    public double[] getPAOverlaps() {
        return this.paOverlaps;
    }

    public double getInitConnectedPct() {
        return this.initConnectedPct;
    }

    public void clear() {
        this.activeCells.clear();
        this.winnerCells.clear();
        this.predictiveCells.clear();
        this.matchingCells.clear();
        this.matchingSegments.clear();
        this.successfullyPredictedColumns.clear();
        this.activeSegments.clear();
        this.learningSegments.clear();
    }

    public int getSegmentCount() {
        return this.segmentCounter + 1;
    }

    public int incrementSegments() {
        return ++this.segmentCounter;
    }

    public int decrementSegments() {
        return --this.segmentCounter;
    }

    public void setSegmentCount(int counter) {
        this.segmentCounter = counter;
    }

    public int getIterationNum() {
        return this.iterationNum;
    }

    public void setIterationNum(int num) {
        this.iterationNum = num;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(int period) {
        this.updatePeriod = period;
    }

    public Cell getCell(int index) {
        return this.cells[index];
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public void setCells(Cell[] cells) {
        this.cells = cells;
    }

    public Cell[] getCells(int[] cellIndexes) {
        Cell[] retVal = new Cell[cellIndexes.length];
        for (int i = 0; i < cellIndexes.length; ++i) {
            retVal[i] = this.cells[cellIndexes[i]];
        }
        return retVal;
    }

    public LinkedHashSet<Cell> getCellSet(int[] cellIndexes) {
        LinkedHashSet<Cell> retVal = new LinkedHashSet<Cell>(cellIndexes.length);
        for (int i = 0; i < cellIndexes.length; ++i) {
            retVal.add(this.cells[cellIndexes[i]]);
        }
        return retVal;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getSeed() {
        return this.seed;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setMemory(SparseObjectMatrix<Column> mem) {
        this.memory = mem;
    }

    public SparseObjectMatrix<Column> getMemory() {
        return this.memory;
    }

    public SparseMatrix<?> getInputMatrix() {
        return this.inputMatrix;
    }

    public void setInputMatrix(SparseMatrix<?> matrix) {
        this.inputMatrix = matrix;
    }

    public int getInhibitionRadius() {
        return this.inhibitionRadius;
    }

    public void setInhibitionRadius(int radius) {
        this.inhibitionRadius = radius;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public void setNumInputs(int n) {
        this.numInputs = n;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int n) {
        this.numColumns = n;
        this.paOverlaps = new double[n];
    }

    public void setPotentialRadius(int potentialRadius) {
        this.potentialRadius = potentialRadius;
    }

    public int getPotentialRadius() {
        return Math.min(this.numInputs, this.potentialRadius);
    }

    public void setPotentialPct(double potentialPct) {
        this.potentialPct = potentialPct;
    }

    public double getPotentialPct() {
        return this.potentialPct;
    }

    public void setPermanences(SparseObjectMatrix<double[]> s) {
        for (int idx : s.getSparseIndices()) {
            this.memory.getObject(idx).setProximalPermanences(this, s.getObject(idx));
        }
    }

    public int getSynapseCount() {
        return this.synapseCounter + 1;
    }

    public void setSynapseCount(int i) {
        this.synapseCounter = i;
    }

    public int incrementSynapses() {
        return ++this.synapseCounter;
    }

    public int decrementSynapses() {
        return --this.synapseCounter;
    }

    public AbstractSparseBinaryMatrix getConnectedCounts() {
        return this.connectedCounts;
    }

    public int getConnectedCount(int columnIndex) {
        return this.connectedCounts.getTrueCount(columnIndex);
    }

    public void setConnectedCounts(int[] counts) {
        for (int i = 0; i < counts.length; ++i) {
            this.connectedCounts.setTrueCount(i, counts[i]);
        }
    }

    public void setConnectedMatrix(AbstractSparseBinaryMatrix matrix) {
        this.connectedCounts = matrix;
    }

    public void setTieBreaker(double[] tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public double[] getTieBreaker() {
        return this.tieBreaker;
    }

    public void setGlobalInhibition(boolean globalInhibition) {
        this.globalInhibition = globalInhibition;
    }

    public boolean getGlobalInhibition() {
        return this.globalInhibition;
    }

    public void setLocalAreaDensity(double localAreaDensity) {
        this.localAreaDensity = localAreaDensity;
    }

    public double getLocalAreaDensity() {
        return this.localAreaDensity;
    }

    public void setNumActiveColumnsPerInhArea(double numActiveColumnsPerInhArea) {
        this.numActiveColumnsPerInhArea = numActiveColumnsPerInhArea;
    }

    public double getNumActiveColumnsPerInhArea() {
        return this.numActiveColumnsPerInhArea;
    }

    public void setStimulusThreshold(double stimulusThreshold) {
        this.stimulusThreshold = stimulusThreshold;
    }

    public double getStimulusThreshold() {
        return this.stimulusThreshold;
    }

    public void setSynPermInactiveDec(double synPermInactiveDec) {
        this.synPermInactiveDec = synPermInactiveDec;
    }

    public double getSynPermInactiveDec() {
        return this.synPermInactiveDec;
    }

    public void setSynPermActiveInc(double synPermActiveInc) {
        this.synPermActiveInc = synPermActiveInc;
    }

    public double getSynPermActiveInc() {
        return this.synPermActiveInc;
    }

    public void setSynPermConnected(double synPermConnected) {
        this.synPermConnected = synPermConnected;
    }

    public double getSynPermConnected() {
        return this.synPermConnected;
    }

    public void setSynPermBelowStimulusInc(double stim) {
        this.synPermBelowStimulusInc = stim;
    }

    public double getSynPermBelowStimulusInc() {
        return this.synPermBelowStimulusInc;
    }

    public void setMinPctOverlapDutyCycles(double minPctOverlapDutyCycle) {
        this.minPctOverlapDutyCycles = minPctOverlapDutyCycle;
    }

    public double getMinPctOverlapDutyCycles() {
        return this.minPctOverlapDutyCycles;
    }

    public void setMinPctActiveDutyCycles(double minPctActiveDutyCycle) {
        this.minPctActiveDutyCycles = minPctActiveDutyCycle;
    }

    public double getMinPctActiveDutyCycles() {
        return this.minPctActiveDutyCycles;
    }

    public void setDutyCyclePeriod(int dutyCyclePeriod) {
        this.dutyCyclePeriod = dutyCyclePeriod;
    }

    public int getDutyCyclePeriod() {
        return this.dutyCyclePeriod;
    }

    public void setMaxBoost(double maxBoost) {
        this.maxBoost = maxBoost;
    }

    public double getMaxBoost() {
        return this.maxBoost;
    }

    public void setSpVerbosity(int spVerbosity) {
        this.spVerbosity = spVerbosity;
    }

    public int getSpVerbosity() {
        return this.spVerbosity;
    }

    public void setSynPermTrimThreshold(double threshold) {
        this.synPermTrimThreshold = threshold;
    }

    public double getSynPermTrimThreshold() {
        return this.synPermTrimThreshold;
    }

    public void setPotentialPools(FlatMatrix<Pool> pools) {
        this.potentialPools = pools;
    }

    public FlatMatrix<Pool> getPotentialPools() {
        return this.potentialPools;
    }

    public double getSynPermMin() {
        return this.synPermMin;
    }

    public double getSynPermMax() {
        return this.synPermMax;
    }

    public int getVerbosity() {
        return this.spVerbosity;
    }

    public double getVersion() {
        return this.version;
    }

    public double[] getOverlapDutyCycles() {
        return this.overlapDutyCycles;
    }

    public void setOverlapDutyCycles(double[] overlapDutyCycles) {
        this.overlapDutyCycles = overlapDutyCycles;
    }

    public double[] getActiveDutyCycles() {
        return this.activeDutyCycles;
    }

    public void setActiveDutyCycles(double[] activeDutyCycles) {
        this.activeDutyCycles = activeDutyCycles;
    }

    public void updateActiveDutyCycles(double[] denseActiveDutyCycles) {
        for (int i = 0; i < denseActiveDutyCycles.length; ++i) {
            if (denseActiveDutyCycles[i] == -1.0) continue;
            this.activeDutyCycles[i] = denseActiveDutyCycles[i];
        }
    }

    public double[] getMinOverlapDutyCycles() {
        return this.minOverlapDutyCycles;
    }

    public void setMinOverlapDutyCycles(double[] minOverlapDutyCycles) {
        this.minOverlapDutyCycles = minOverlapDutyCycles;
    }

    public double[] getMinActiveDutyCycles() {
        return this.minActiveDutyCycles;
    }

    public void setMinActiveDutyCycles(double[] minActiveDutyCycles) {
        this.minActiveDutyCycles = minActiveDutyCycles;
    }

    public double[] getBoostFactors() {
        return this.boostFactors;
    }

    public void setBoostFactors(double[] boostFactors) {
        this.boostFactors = boostFactors;
    }

    public void printParameters() {
        System.out.println("------------ SpatialPooler Parameters ------------------");
        System.out.println("numInputs                  = " + this.getNumInputs());
        System.out.println("numColumns                 = " + this.getNumColumns());
        System.out.println("cellsPerColumn             = " + this.getCellsPerColumn());
        System.out.println("columnDimensions           = " + Arrays.toString(this.getColumnDimensions()));
        System.out.println("numActiveColumnsPerInhArea = " + this.getNumActiveColumnsPerInhArea());
        System.out.println("potentialPct               = " + this.getPotentialPct());
        System.out.println("potentialRadius            = " + this.getPotentialRadius());
        System.out.println("globalInhibition           = " + this.getGlobalInhibition());
        System.out.println("localAreaDensity           = " + this.getLocalAreaDensity());
        System.out.println("inhibitionRadius           = " + this.getInhibitionRadius());
        System.out.println("stimulusThreshold          = " + this.getStimulusThreshold());
        System.out.println("synPermActiveInc           = " + this.getSynPermActiveInc());
        System.out.println("synPermInactiveDec         = " + this.getSynPermInactiveDec());
        System.out.println("synPermConnected           = " + this.getSynPermConnected());
        System.out.println("minPctOverlapDutyCycle     = " + this.getMinPctOverlapDutyCycles());
        System.out.println("minPctActiveDutyCycle      = " + this.getMinPctActiveDutyCycles());
        System.out.println("dutyCyclePeriod            = " + this.getDutyCyclePeriod());
        System.out.println("maxBoost                   = " + this.getMaxBoost());
        System.out.println("spVerbosity                = " + this.getSpVerbosity());
        System.out.println("version                    = " + this.getVersion());
        System.out.println("\n------------ TemporalMemory Parameters ------------------");
        System.out.println("activationThreshold        = " + this.getActivationThreshold());
        System.out.println("learningRadius             = " + this.getLearningRadius());
        System.out.println("minThreshold               = " + this.getMinThreshold());
        System.out.println("maxNewSynapseCount         = " + this.getMaxNewSynapseCount());
        System.out.println("initialPermanence          = " + this.getInitialPermanence());
        System.out.println("connectedPermanence        = " + this.getConnectedPermanence());
        System.out.println("permanenceIncrement        = " + this.getPermanenceIncrement());
        System.out.println("permanenceDecrement        = " + this.getPermanenceDecrement());
    }

    public Set<Cell> getActiveCells() {
        return this.activeCells;
    }

    public void setActiveCells(Set<Cell> cells) {
        this.activeCells = cells;
    }

    public Set<Cell> getWinnerCells() {
        return this.winnerCells;
    }

    public void setWinnerCells(Set<Cell> cells) {
        this.winnerCells = cells;
    }

    public Set<Cell> getPredictiveCells() {
        return this.predictiveCells;
    }

    public void setPredictiveCells(Set<Cell> cells) {
        this.predictiveCells = cells;
    }

    public Set<Cell> getMatchingCells() {
        return this.matchingCells;
    }

    public void setMatchingCells(Set<Cell> cells) {
        this.matchingCells = cells;
    }

    public Set<Column> getSuccessfullyPredictedColumns() {
        return this.successfullyPredictedColumns;
    }

    public void setSuccessfullyPredictedColumns(Set<Column> columns) {
        this.successfullyPredictedColumns = columns;
    }

    public Set<DistalDendrite> getLearningSegments() {
        return this.learningSegments;
    }

    public void setLearningSegments(Set<DistalDendrite> segments) {
        this.learningSegments = segments;
    }

    public Set<DistalDendrite> getActiveSegments() {
        return this.activeSegments;
    }

    public void setActiveSegments(Set<DistalDendrite> segments) {
        this.activeSegments = segments;
    }

    public Set<DistalDendrite> getMatchingSegments() {
        return this.matchingSegments;
    }

    public void setMatchingSegments(Set<DistalDendrite> segments) {
        this.matchingSegments = segments;
    }

    public Set<Synapse> getReceptorSynapses(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell was null");
        }
        if (this.receptorSynapses == null) {
            this.receptorSynapses = new LinkedHashMap<Cell, LinkedHashSet<Synapse>>();
        }
        LinkedHashSet<Synapse> retVal = null;
        retVal = this.receptorSynapses.get(cell);
        if (retVal == null) {
            retVal = new LinkedHashSet();
            this.receptorSynapses.put(cell, retVal);
        }
        return retVal;
    }

    public List<DistalDendrite> getSegments(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell was null");
        }
        if (this.segments == null) {
            this.segments = new LinkedHashMap<Cell, List<DistalDendrite>>();
        }
        List<DistalDendrite> retVal = null;
        retVal = this.segments.get(cell);
        if (retVal == null) {
            retVal = new ArrayList<DistalDendrite>();
            this.segments.put(cell, retVal);
        }
        return retVal;
    }

    public List<Synapse> getSynapses(DistalDendrite segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment was null");
        }
        if (this.synapses == null) {
            this.synapses = new LinkedHashMap<Segment, List<Synapse>>();
        }
        List<Synapse> retVal = null;
        retVal = this.synapses.get(segment);
        if (retVal == null) {
            retVal = new ArrayList<Synapse>();
            this.synapses.put(segment, retVal);
        }
        return retVal;
    }

    public List<Synapse> getSynapses(ProximalDendrite segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment was null");
        }
        if (this.synapses == null) {
            this.synapses = new LinkedHashMap<Segment, List<Synapse>>();
        }
        List<Synapse> retVal = null;
        retVal = this.synapses.get(segment);
        if (retVal == null) {
            retVal = new ArrayList<Synapse>();
            this.synapses.put(segment, retVal);
        }
        return retVal;
    }

    public Column getColumn(int index) {
        return this.memory.getObject(index);
    }

    public void setColumnDimensions(int[] columnDimensions) {
        this.columnDimensions = columnDimensions;
    }

    public int[] getColumnDimensions() {
        return this.columnDimensions;
    }

    public void setInputDimensions(int[] inputDimensions) {
        this.inputDimensions = inputDimensions;
    }

    public int[] getInputDimensions() {
        return this.inputDimensions;
    }

    public void setCellsPerColumn(int cellsPerColumn) {
        this.cellsPerColumn = cellsPerColumn;
    }

    public int getCellsPerColumn() {
        return this.cellsPerColumn;
    }

    public void setActivationThreshold(int activationThreshold) {
        this.activationThreshold = activationThreshold;
    }

    public int getActivationThreshold() {
        return this.activationThreshold;
    }

    public void setLearningRadius(int learningRadius) {
        this.learningRadius = learningRadius;
    }

    public int getLearningRadius() {
        return this.learningRadius;
    }

    public void setMinThreshold(int minThreshold) {
        this.minThreshold = minThreshold;
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public void setMaxNewSynapseCount(int maxNewSynapseCount) {
        this.maxNewSynapseCount = maxNewSynapseCount;
    }

    public int getMaxNewSynapseCount() {
        return this.maxNewSynapseCount;
    }

    public void setInitialPermanence(double initialPermanence) {
        this.initialPermanence = initialPermanence;
    }

    public double getInitialPermanence() {
        return this.initialPermanence;
    }

    public void setConnectedPermanence(double connectedPermanence) {
        this.connectedPermanence = connectedPermanence;
    }

    public double getConnectedPermanence() {
        return this.connectedPermanence;
    }

    public void setPermanenceIncrement(double permanenceIncrement) {
        this.permanenceIncrement = permanenceIncrement;
    }

    public double getPermanenceIncrement() {
        return this.permanenceIncrement;
    }

    public void setPermanenceDecrement(double permanenceDecrement) {
        this.permanenceDecrement = permanenceDecrement;
    }

    public double getPermanenceDecrement() {
        return this.permanenceDecrement;
    }

    public void setPredictedSegmentDecrement(double predictedSegmentDecrement) {
        this.predictedSegmentDecrement = predictedSegmentDecrement;
    }

    public double getPredictedSegmentDecrement() {
        return this.predictedSegmentDecrement;
    }

    public static List<Integer> asCellIndexes(Collection<Cell> cells) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (Cell cell : cells) {
            ints.add(cell.getIndex());
        }
        return ints;
    }

    public static List<Integer> asColumnIndexes(Collection<Column> columns) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (Column col : columns) {
            ints.add(col.getIndex());
        }
        return ints;
    }

    public List<Cell> asCellObjects(Collection<Integer> cells) {
        ArrayList<Cell> objs = new ArrayList<Cell>();
        for (int i : cells) {
            objs.add(this.cells[i]);
        }
        return objs;
    }

    public List<Column> asColumnObjects(Collection<Integer> cols) {
        ArrayList<Column> objs = new ArrayList<Column>();
        for (int i : cols) {
            objs.add(this.memory.getObject(i));
        }
        return objs;
    }

    public LinkedHashSet<Column> getColumnSet(int[] indexes) {
        LinkedHashSet<Column> retVal = new LinkedHashSet<Column>();
        for (int i = 0; i < indexes.length; ++i) {
            retVal.add(this.memory.getObject(indexes[i]));
        }
        return retVal;
    }

    public List<Column> getColumnList(int[] indexes) {
        ArrayList<Column> retVal = new ArrayList<Column>();
        for (int i = 0; i < indexes.length; ++i) {
            retVal.add(this.memory.getObject(indexes[i]));
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.activationThreshold;
        result = 31 * result + (this.activeCells == null ? 0 : this.activeCells.hashCode());
        result = 31 * result + Arrays.hashCode(this.activeDutyCycles);
        result = 31 * result + (this.activeSegments == null ? 0 : this.activeSegments.hashCode());
        result = 31 * result + Arrays.hashCode(this.boostFactors);
        result = 31 * result + Arrays.hashCode(this.cells);
        result = 31 * result + this.cellsPerColumn;
        result = 31 * result + Arrays.hashCode(this.columnDimensions);
        result = 31 * result + (this.connectedCounts == null ? 0 : this.connectedCounts.hashCode());
        long temp = Double.doubleToLongBits(this.connectedPermanence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.dutyCyclePeriod;
        result = 31 * result + (this.globalInhibition ? 1231 : 1237);
        result = 31 * result + this.inhibitionRadius;
        temp = Double.doubleToLongBits(this.initConnectedPct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.initialPermanence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.inputDimensions);
        result = 31 * result + (this.inputMatrix == null ? 0 : this.inputMatrix.hashCode());
        result = 31 * result + this.iterationLearnNum;
        result = 31 * result + this.iterationNum;
        result = 31 * result + this.learningRadius;
        result = 31 * result + (this.learningSegments == null ? 0 : this.learningSegments.hashCode());
        temp = Double.doubleToLongBits(this.localAreaDensity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.matchingCells == null ? 0 : this.matchingCells.hashCode());
        result = 31 * result + (this.matchingSegments == null ? 0 : this.matchingSegments.hashCode());
        temp = Double.doubleToLongBits(this.maxBoost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxNewSynapseCount;
        result = 31 * result + (this.memory == null ? 0 : this.memory.hashCode());
        result = 31 * result + Arrays.hashCode(this.minActiveDutyCycles);
        result = 31 * result + Arrays.hashCode(this.minOverlapDutyCycles);
        temp = Double.doubleToLongBits(this.minPctActiveDutyCycles);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minPctOverlapDutyCycles);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.minThreshold;
        temp = Double.doubleToLongBits(this.numActiveColumnsPerInhArea);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numColumns;
        result = 31 * result + this.numInputs;
        result = 31 * result + Arrays.hashCode(this.overlapDutyCycles);
        result = 31 * result + Arrays.hashCode(this.paOverlaps);
        temp = Double.doubleToLongBits(this.permanenceDecrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.permanenceIncrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.potentialPct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.potentialPools == null ? 0 : this.potentialPools.hashCode());
        result = 31 * result + this.potentialRadius;
        temp = Double.doubleToLongBits(this.predictedSegmentDecrement);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.predictiveCells == null ? 0 : this.predictiveCells.hashCode());
        result = 31 * result + (this.random == null ? 0 : this.random.hashCode());
        result = 31 * result + (this.receptorSynapses == null ? 0 : this.receptorSynapses.hashCode());
        result = 31 * result + this.seed;
        result = 31 * result + this.segmentCounter;
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        result = 31 * result + this.spVerbosity;
        temp = Double.doubleToLongBits(this.stimulusThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.successfullyPredictedColumns == null ? 0 : this.successfullyPredictedColumns.hashCode());
        temp = Double.doubleToLongBits(this.synPermActiveInc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermBelowStimulusInc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermConnected);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermInactiveDec);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermMax);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermMin);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.synPermTrimThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.synapseCounter;
        result = 31 * result + (this.synapses == null ? 0 : this.synapses.hashCode());
        result = 31 * result + Arrays.hashCode(this.tieBreaker);
        result = 31 * result + this.updatePeriod;
        temp = Double.doubleToLongBits(this.version);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.winnerCells == null ? 0 : this.winnerCells.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connections other = (Connections)obj;
        if (this.activationThreshold != other.activationThreshold) {
            return false;
        }
        if (this.activeCells == null ? other.activeCells != null : !this.activeCells.equals(other.activeCells)) {
            return false;
        }
        if (!Arrays.equals(this.activeDutyCycles, other.activeDutyCycles)) {
            return false;
        }
        if (this.activeSegments == null ? other.activeSegments != null : !this.activeSegments.equals(other.activeSegments)) {
            return false;
        }
        if (!Arrays.equals(this.boostFactors, other.boostFactors)) {
            return false;
        }
        if (!Arrays.equals(this.cells, other.cells)) {
            return false;
        }
        if (this.cellsPerColumn != other.cellsPerColumn) {
            return false;
        }
        if (!Arrays.equals(this.columnDimensions, other.columnDimensions)) {
            return false;
        }
        if (this.connectedCounts == null ? other.connectedCounts != null : !this.connectedCounts.equals(other.connectedCounts)) {
            return false;
        }
        if (Double.doubleToLongBits(this.connectedPermanence) != Double.doubleToLongBits(other.connectedPermanence)) {
            return false;
        }
        if (this.dutyCyclePeriod != other.dutyCyclePeriod) {
            return false;
        }
        if (this.globalInhibition != other.globalInhibition) {
            return false;
        }
        if (this.inhibitionRadius != other.inhibitionRadius) {
            return false;
        }
        if (Double.doubleToLongBits(this.initConnectedPct) != Double.doubleToLongBits(other.initConnectedPct)) {
            return false;
        }
        if (Double.doubleToLongBits(this.initialPermanence) != Double.doubleToLongBits(other.initialPermanence)) {
            return false;
        }
        if (!Arrays.equals(this.inputDimensions, other.inputDimensions)) {
            return false;
        }
        if (this.inputMatrix == null ? other.inputMatrix != null : !this.inputMatrix.equals(other.inputMatrix)) {
            return false;
        }
        if (this.iterationLearnNum != other.iterationLearnNum) {
            return false;
        }
        if (this.iterationNum != other.iterationNum) {
            return false;
        }
        if (this.learningRadius != other.learningRadius) {
            return false;
        }
        if (this.learningSegments == null ? other.learningSegments != null : !this.learningSegments.equals(other.learningSegments)) {
            return false;
        }
        if (Double.doubleToLongBits(this.localAreaDensity) != Double.doubleToLongBits(other.localAreaDensity)) {
            return false;
        }
        if (this.matchingCells == null ? other.matchingCells != null : !this.matchingCells.equals(other.matchingCells)) {
            return false;
        }
        if (this.matchingSegments == null ? other.matchingSegments != null : !this.matchingSegments.equals(other.matchingSegments)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxBoost) != Double.doubleToLongBits(other.maxBoost)) {
            return false;
        }
        if (this.maxNewSynapseCount != other.maxNewSynapseCount) {
            return false;
        }
        if (this.memory == null ? other.memory != null : !this.memory.equals(other.memory)) {
            return false;
        }
        if (!Arrays.equals(this.minActiveDutyCycles, other.minActiveDutyCycles)) {
            return false;
        }
        if (!Arrays.equals(this.minOverlapDutyCycles, other.minOverlapDutyCycles)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minPctActiveDutyCycles) != Double.doubleToLongBits(other.minPctActiveDutyCycles)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minPctOverlapDutyCycles) != Double.doubleToLongBits(other.minPctOverlapDutyCycles)) {
            return false;
        }
        if (this.minThreshold != other.minThreshold) {
            return false;
        }
        if (Double.doubleToLongBits(this.numActiveColumnsPerInhArea) != Double.doubleToLongBits(other.numActiveColumnsPerInhArea)) {
            return false;
        }
        if (this.numColumns != other.numColumns) {
            return false;
        }
        if (this.numInputs != other.numInputs) {
            return false;
        }
        if (!Arrays.equals(this.overlapDutyCycles, other.overlapDutyCycles)) {
            return false;
        }
        if (!Arrays.equals(this.paOverlaps, other.paOverlaps)) {
            return false;
        }
        if (Double.doubleToLongBits(this.permanenceDecrement) != Double.doubleToLongBits(other.permanenceDecrement)) {
            return false;
        }
        if (Double.doubleToLongBits(this.permanenceIncrement) != Double.doubleToLongBits(other.permanenceIncrement)) {
            return false;
        }
        if (Double.doubleToLongBits(this.potentialPct) != Double.doubleToLongBits(other.potentialPct)) {
            return false;
        }
        if (this.potentialPools == null ? other.potentialPools != null : !this.potentialPools.equals(other.potentialPools)) {
            return false;
        }
        if (this.potentialRadius != other.potentialRadius) {
            return false;
        }
        if (Double.doubleToLongBits(this.predictedSegmentDecrement) != Double.doubleToLongBits(other.predictedSegmentDecrement)) {
            return false;
        }
        if (this.predictiveCells == null ? other.predictiveCells != null : !this.predictiveCells.equals(other.predictiveCells)) {
            return false;
        }
        if (this.receptorSynapses == null ? other.receptorSynapses != null : !this.receptorSynapses.toString().equals(other.receptorSynapses.toString())) {
            return false;
        }
        if (this.seed != other.seed) {
            return false;
        }
        if (this.segmentCounter != other.segmentCounter) {
            return false;
        }
        if (this.segments == null ? other.segments != null : !this.segments.equals(other.segments)) {
            return false;
        }
        if (this.spVerbosity != other.spVerbosity) {
            return false;
        }
        if (Double.doubleToLongBits(this.stimulusThreshold) != Double.doubleToLongBits(other.stimulusThreshold)) {
            return false;
        }
        if (this.successfullyPredictedColumns == null ? other.successfullyPredictedColumns != null : !this.successfullyPredictedColumns.equals(other.successfullyPredictedColumns)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermActiveInc) != Double.doubleToLongBits(other.synPermActiveInc)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermBelowStimulusInc) != Double.doubleToLongBits(other.synPermBelowStimulusInc)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermConnected) != Double.doubleToLongBits(other.synPermConnected)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermInactiveDec) != Double.doubleToLongBits(other.synPermInactiveDec)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermMax) != Double.doubleToLongBits(other.synPermMax)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermMin) != Double.doubleToLongBits(other.synPermMin)) {
            return false;
        }
        if (Double.doubleToLongBits(this.synPermTrimThreshold) != Double.doubleToLongBits(other.synPermTrimThreshold)) {
            return false;
        }
        if (this.synapseCounter != other.synapseCounter) {
            return false;
        }
        if (this.synapses == null ? other.synapses != null : !this.synapses.equals(other.synapses)) {
            return false;
        }
        if (!Arrays.equals(this.tieBreaker, other.tieBreaker)) {
            return false;
        }
        if (this.updatePeriod != other.updatePeriod) {
            return false;
        }
        if (Double.doubleToLongBits(this.version) != Double.doubleToLongBits(other.version)) {
            return false;
        }
        return !(this.winnerCells == null ? other.winnerCells != null : !this.winnerCells.equals(other.winnerCells));
    }
}

