/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic;

import java.util.Arrays;
import org.numenta.nupic.encoders.CoordinateEncoder;
import org.numenta.nupic.encoders.DateEncoder;
import org.numenta.nupic.encoders.Encoder;
import org.numenta.nupic.encoders.GeospatialCoordinateEncoder;
import org.numenta.nupic.encoders.RandomDistributedScalarEncoder;
import org.numenta.nupic.encoders.SDRCategoryEncoder;
import org.numenta.nupic.encoders.SDRPassThroughEncoder;
import org.numenta.nupic.encoders.ScalarEncoder;
import org.numenta.nupic.util.Tuple;

public enum FieldMetaType {
    STRING("string"),
    DATETIME("datetime"),
    INTEGER("int"),
    FLOAT("float"),
    BOOLEAN("bool"),
    LIST("list"),
    COORD("coord"),
    GEO("geo"),
    SARR("sarr"),
    DARR("darr");

    private String displayString;

    private FieldMetaType(String s) {
        this.displayString = s;
    }

    public Encoder<?> newEncoder() {
        switch (this) {
            case LIST: 
            case STRING: {
                return SDRCategoryEncoder.builder().build();
            }
            case DATETIME: {
                return DateEncoder.builder().build();
            }
            case BOOLEAN: {
                return ScalarEncoder.builder().build();
            }
            case COORD: {
                return CoordinateEncoder.builder().build();
            }
            case GEO: {
                return GeospatialCoordinateEncoder.geobuilder().build();
            }
            case INTEGER: 
            case FLOAT: {
                return RandomDistributedScalarEncoder.builder().build();
            }
            case DARR: 
            case SARR: {
                return SDRPassThroughEncoder.sptBuilder().build();
            }
        }
        return null;
    }

    public <T> T decodeType(String input, Encoder<?> enc) {
        switch (this) {
            case LIST: 
            case STRING: {
                return (T)input;
            }
            case DATETIME: {
                return (T)((DateEncoder)enc).parse(input);
            }
            case BOOLEAN: {
                return (T)(Boolean.valueOf(input) == true ? new Integer(1) : new Integer(0));
            }
            case COORD: 
            case GEO: {
                String[] parts = input.split("[\\s]*\\;[\\s]*");
                return (T)new Tuple(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]));
            }
            case INTEGER: 
            case FLOAT: {
                return (T)new Double(input);
            }
            case DARR: 
            case SARR: {
                return (T)Arrays.stream(input.replace("[", "").replace("]", "").split("[\\s]*\\,[\\s]*")).mapToInt(Integer::parseInt).toArray();
            }
        }
        return null;
    }

    public String display() {
        return this.displayString;
    }

    public static FieldMetaType fromString(Object s) {
        String val;
        switch (val = s.toString().toLowerCase()) {
            case "char": 
            case "string": 
            case "category": {
                return STRING;
            }
            case "date": 
            case "date time": 
            case "datetime": 
            case "time": {
                return DATETIME;
            }
            case "int": 
            case "integer": 
            case "long": {
                return INTEGER;
            }
            case "double": 
            case "float": 
            case "number": 
            case "numeral": 
            case "num": 
            case "scalar": 
            case "floating point": {
                return FLOAT;
            }
            case "bool": 
            case "boolean": {
                return BOOLEAN;
            }
            case "list": {
                return LIST;
            }
            case "geo": {
                return GEO;
            }
            case "coord": {
                return COORD;
            }
            case "sarr": {
                return SARR;
            }
            case "darr": {
                return DARR;
            }
        }
        return FLOAT;
    }
}

