/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.algorithms.AnomalyLikelihood;

public class AnomalyLikelihoodMetrics
implements Persistable {
    private static final long serialVersionUID = 1L;
    private AnomalyLikelihood.AnomalyParams params;
    private Anomaly.AveragedAnomalyRecordList aggRecordList;
    private double[] likelihoods;

    public AnomalyLikelihoodMetrics(double[] likelihoods, Anomaly.AveragedAnomalyRecordList aggRecordList, AnomalyLikelihood.AnomalyParams params) {
        this.params = params;
        this.aggRecordList = aggRecordList;
        this.likelihoods = likelihoods;
    }

    public AnomalyLikelihoodMetrics copy() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (String key : this.params.keys()) {
            vals.add(this.params.get(key));
        }
        return new AnomalyLikelihoodMetrics(Arrays.copyOf(this.likelihoods, this.likelihoods.length), this.aggRecordList, new AnomalyLikelihood.AnomalyParams(this.params.keys(), vals.toArray()));
    }

    public double[] getLikelihoods() {
        return this.likelihoods;
    }

    public Anomaly.AveragedAnomalyRecordList getAvgRecordList() {
        return this.aggRecordList;
    }

    public AnomalyLikelihood.AnomalyParams getParams() {
        return this.params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggRecordList == null ? 0 : this.aggRecordList.hashCode());
        result = 31 * result + Arrays.hashCode(this.likelihoods);
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnomalyLikelihoodMetrics other = (AnomalyLikelihoodMetrics)obj;
        if (this.aggRecordList == null ? other.aggRecordList != null : !this.aggRecordList.equals(other.aggRecordList)) {
            return false;
        }
        if (!Arrays.equals(this.likelihoods, other.likelihoods)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

