/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.algorithms.CLAClassifier;
import org.numenta.nupic.util.ArrayUtils;

public class BitHistory
implements Persistable {
    private static final long serialVersionUID = 1L;
    CLAClassifier classifier;
    String id;
    TDoubleList stats;
    int lastTotalUpdate = -1;
    private static final int DUTY_CYCLE_UPDATE_INTERVAL = Integer.MAX_VALUE;

    BitHistory() {
    }

    public BitHistory(CLAClassifier classifier, int bitNum, int nSteps) {
        this.classifier = classifier;
        this.id = String.format("%d[%d]", bitNum, nSteps);
        this.stats = new TDoubleArrayList();
    }

    public void store(int iteration, int bucketIdx) {
        int statsLen;
        if (this.lastTotalUpdate == -1) {
            this.lastTotalUpdate = iteration;
        }
        if (bucketIdx > (statsLen = this.stats.size() - 1)) {
            this.stats.add(new double[bucketIdx - statsLen]);
        }
        double dc = this.stats.get(bucketIdx);
        double denom = Math.pow(1.0 - this.classifier.alpha, iteration - this.lastTotalUpdate);
        double dcNew = 0.0;
        if (denom > 0.0) {
            dcNew = dc + this.classifier.alpha / denom;
        }
        if (denom == 0.0 || dcNew > 2.147483647E9) {
            double exp = Math.pow(1.0 - this.classifier.alpha, iteration - this.lastTotalUpdate);
            double dcT = 0.0;
            for (int i = 0; i < this.stats.size(); ++i) {
                this.stats.set(i, dcT *= exp);
            }
            this.lastTotalUpdate = iteration;
            dc = this.stats.get(bucketIdx) + this.classifier.alpha;
        } else {
            dc = dcNew;
        }
        this.stats.set(bucketIdx, dc);
        if (this.classifier.verbosity >= 2) {
            System.out.println(String.format("updated DC for %s,  bucket %d to %f", this.id, bucketIdx, dc));
        }
    }

    public void infer(int iteration, double[] votes) {
        double total = 0.0;
        for (int i = 0; i < this.stats.size(); ++i) {
            double dc = this.stats.get(i);
            if (!(dc > 0.0)) continue;
            votes[i] = dc;
            total += dc;
        }
        if (total > 0.0) {
            double[] temp = ArrayUtils.divide(votes, total);
            for (int i = 0; i < temp.length; ++i) {
                votes[i] = temp[i];
            }
        }
        if (this.classifier.verbosity >= 2) {
            System.out.println(String.format("bucket votes for %s:", this.id, this.pFormatArray(votes)));
        }
    }

    private String pFormatArray(double[] arr) {
        StringBuilder sb = new StringBuilder("[ ");
        for (double d : arr) {
            sb.append(String.format("%.2f", d));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

