/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.algorithms.BitHistory;
import org.numenta.nupic.algorithms.CLAClassifierDeserializer;
import org.numenta.nupic.algorithms.CLAClassifierSerializer;
import org.numenta.nupic.algorithms.Classification;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Deque;
import org.numenta.nupic.util.Tuple;

@JsonSerialize(using=CLAClassifierSerializer.class)
@JsonDeserialize(using=CLAClassifierDeserializer.class)
public class CLAClassifier
implements Persistable {
    private static final long serialVersionUID = 1L;
    int verbosity = 0;
    double alpha = 0.001;
    double actValueAlpha = 0.3;
    int learnIteration;
    int recordNumMinusLearnIteration = -1;
    int maxBucketIdx;
    TIntList steps = new TIntArrayList();
    Deque<Tuple> patternNZHistory;
    Map<Tuple, BitHistory> activeBitHistory = new HashMap<Tuple, BitHistory>();
    List<?> actualValues = new ArrayList();
    String g_debugPrefix = "CLAClassifier";

    public CLAClassifier() {
        this((TIntList)new TIntArrayList(new int[]{1}), 0.001, 0.3, 0);
    }

    public CLAClassifier(TIntList steps, double alpha, double actValueAlpha, int verbosity) {
        this.steps = steps;
        this.alpha = alpha;
        this.actValueAlpha = actValueAlpha;
        this.verbosity = verbosity;
        this.actualValues.add(null);
        this.patternNZHistory = new Deque(ArrayUtils.max(steps.toArray()) + 1);
    }

    public <T> Classification<T> compute(int recordNum, Map<String, Object> classification, int[] patternNZ, boolean learn, boolean infer) {
        Classification<Object> retVal = new Classification<Object>();
        List<?> actualValues = this.actualValues;
        if (this.recordNumMinusLearnIteration == -1) {
            this.recordNumMinusLearnIteration = recordNum - this.learnIteration;
        }
        this.learnIteration = recordNum - this.recordNumMinusLearnIteration;
        if (this.verbosity >= 1) {
            System.out.println(String.format("\n%s: compute ", this.g_debugPrefix));
            System.out.println(" recordNum: " + recordNum);
            System.out.println(" learnIteration: " + this.learnIteration);
            System.out.println(String.format(" patternNZ(%d): ", patternNZ.length, patternNZ));
            System.out.println(" classificationIn: " + classification);
        }
        this.patternNZHistory.append(new Tuple(this.learnIteration, patternNZ));
        if (infer) {
            Object defaultValue = null;
            defaultValue = this.steps.get(0) == 0 ? Integer.valueOf(0) : classification.get("actValue");
            Object[] actValues = new Object[this.actualValues.size()];
            for (int i = 0; i < actualValues.size(); ++i) {
                actValues[i] = actualValues.get(i) == null ? defaultValue : actualValues.get(i);
            }
            retVal.setActualValues(actValues);
            for (int nSteps2 : this.steps.toArray()) {
                double[] sumVotes = new double[this.maxBucketIdx + 1];
                double[] bitVotes = new double[this.maxBucketIdx + 1];
                for (int bit : patternNZ) {
                    Tuple key = new Tuple(bit, nSteps2);
                    BitHistory bitHistory = this.activeBitHistory.get(key);
                    if (bitHistory == null) continue;
                    bitHistory.infer(this.learnIteration, bitVotes);
                    sumVotes = ArrayUtils.d_add(sumVotes, bitVotes);
                }
                double total = ArrayUtils.sum(sumVotes);
                if (total > 0.0) {
                    sumVotes = ArrayUtils.divide(sumVotes, total);
                } else if (sumVotes.length > 0) {
                    Arrays.fill(sumVotes, 1.0 / (double)sumVotes.length);
                }
                retVal.setStats(nSteps2, sumVotes);
            }
        }
        if (learn && classification.get("bucketIdx") != null) {
            int bucketIdx = (Integer)classification.get("bucketIdx");
            Object actValue = classification.get("actValue");
            this.maxBucketIdx = Math.max(this.maxBucketIdx, bucketIdx);
            while (this.maxBucketIdx > actualValues.size() - 1) {
                actualValues.add(null);
            }
            if (actualValues.get(bucketIdx) == null) {
                actualValues.set(bucketIdx, actValue);
            } else if (Number.class.isAssignableFrom(actValue.getClass())) {
                Double val = (1.0 - this.actValueAlpha) * ((Number)actualValues.get(bucketIdx)).doubleValue() + this.actValueAlpha * ((Number)actValue).doubleValue();
                actualValues.set(bucketIdx, val);
            } else {
                actualValues.set(bucketIdx, actValue);
            }
            int nSteps = -1;
            int iteration = 0;
            int[] learnPatternNZ = null;
            int[] nSteps2 = this.steps.toArray();
            int n = nSteps2.length;
            for (int i = 0; i < n; ++i) {
                int n2;
                nSteps = n2 = nSteps2[i];
                boolean found = false;
                for (Tuple t : this.patternNZHistory) {
                    iteration = (Integer)t.get(0);
                    learnPatternNZ = (int[])t.get(1);
                    if (iteration == this.learnIteration - nSteps) {
                        found = true;
                        break;
                    }
                    ++iteration;
                }
                if (!found) continue;
                for (Iterator<Tuple> iterator : learnPatternNZ) {
                    Tuple key = new Tuple(Integer.valueOf(iterator), nSteps);
                    BitHistory history = this.activeBitHistory.get(key);
                    if (history == null) {
                        history = new BitHistory(this, (int)iterator, nSteps);
                        this.activeBitHistory.put(key, history);
                    }
                    history.store(this.learnIteration, bucketIdx);
                }
            }
        }
        if (infer && this.verbosity >= 1) {
            System.out.println(" inference: combined bucket likelihoods:");
            System.out.println("   actual bucket values: " + Arrays.toString(retVal.getActualValues()));
            for (int key : retVal.stepSet()) {
                if (retVal.getActualValue(key) == null) continue;
                Object[] actual = new Object[]{retVal.getActualValue(key)};
                System.out.println(String.format("  %d steps: ", key, this.pFormatArray(actual)));
                int bestBucketIdx = retVal.getMostProbableBucketIndex(key);
                System.out.println(String.format("   most likely bucket idx: %d, value: %s ", bestBucketIdx, retVal.getActualValue(bestBucketIdx)));
            }
        }
        return retVal;
    }

    private <T> String pFormatArray(T[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[ ");
        for (T t : arr) {
            sb.append(String.format("%.2s", t));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public String serialize() {
        String json = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static CLAClassifier deSerialize(String jsonStrategy) {
        ObjectMapper om = new ObjectMapper();
        CLAClassifier c = null;
        try {
            Object o = om.readValue(jsonStrategy, CLAClassifier.class);
            c = (CLAClassifier)o;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }
}

